/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;
import com.esotericsoftware.spine.utils.SkeletonClipping;
import com.esotericsoftware.spine.utils.TwoColorPolygonBatch;

public class SkeletonRenderer {
    private static final short[] quadTriangles;
    private boolean premultipliedAlpha;
    private final FloatArray vertices = new FloatArray(32);
    private final SkeletonClipping clipper = new SkeletonClipping();
    private VertexEffect vertexEffect;
    private final Vector2 temp = new Vector2();
    private final Vector2 temp2 = new Vector2();
    private final Color temp3 = new Color();
    private final Color temp4 = new Color();
    private final Color temp5 = new Color();
    private final Color temp6 = new Color();

    static {
        short[] sArray = new short[6];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 2;
        sArray[4] = 3;
        quadTriangles = sArray;
    }

    /*
     * Unable to fully structure code
     */
    public void draw(Batch batch, Skeleton skeleton) {
        if (batch instanceof TwoColorPolygonBatch) {
            this.draw((TwoColorPolygonBatch)batch, skeleton);
            return;
        }
        if (batch instanceof PolygonSpriteBatch) {
            this.draw((PolygonSpriteBatch)batch, skeleton);
            return;
        }
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        vertexEffect = this.vertexEffect;
        if (vertexEffect != null) {
            vertexEffect.begin(skeleton);
        }
        premultipliedAlpha = this.premultipliedAlpha;
        blendMode = null;
        vertices = this.vertices.items;
        skeletonColor = skeleton.color;
        r = skeletonColor.r;
        g = skeletonColor.g;
        b = skeletonColor.b;
        a = skeletonColor.a;
        drawOrder = skeleton.drawOrder;
        i = 0;
        n = drawOrder.size;
        while (i < n) {
            block16: {
                block17: {
                    block15: {
                        slot = drawOrder.get(i);
                        if (slot.bone.active) break block15;
                        this.clipper.clipEnd(slot);
                        break block16;
                    }
                    attachment = slot.attachment;
                    if (!(attachment instanceof RegionAttachment)) break block17;
                    region = (RegionAttachment)attachment;
                    region.computeWorldVertices(slot.getBone(), vertices, 0, 5);
                    color = region.getColor();
                    slotColor = slot.getColor();
                    alpha = a * slotColor.a * color.a * 255.0f;
                    multiplier = premultipliedAlpha != false ? alpha : 255.0f;
                    slotBlendMode = slot.data.getBlendMode();
                    if (slotBlendMode != blendMode) {
                        if (slotBlendMode == BlendMode.additive && premultipliedAlpha) {
                            slotBlendMode = BlendMode.normal;
                            alpha = 0.0f;
                        }
                        blendMode = slotBlendMode;
                        batch.setBlendFunction(blendMode.getSource(premultipliedAlpha), blendMode.getDest());
                    }
                    c = NumberUtils.intToFloatColor((int)alpha << 24 | (int)(b * slotColor.b * color.b * multiplier) << 16 | (int)(g * slotColor.g * color.g * multiplier) << 8 | (int)(r * slotColor.r * color.r * multiplier));
                    uvs = region.getUVs();
                    u = 0;
                    v = 2;
                    while (u < 8) {
                        vertices[v] = c;
                        vertices[v + 1] = uvs[u];
                        vertices[v + 2] = uvs[u + 1];
                        u += 2;
                        v += 5;
                    }
                    if (vertexEffect != null) {
                        this.applyVertexEffect(vertices, 20, 5, c, 0.0f);
                    }
                    batch.draw(region.getRegion().getTexture(), vertices, 0, 20);
                    ** GOTO lbl70
                }
                if (attachment instanceof ClippingAttachment) {
                    this.clipper.clipStart(slot, (ClippingAttachment)attachment);
                } else {
                    if (attachment instanceof MeshAttachment) {
                        throw new RuntimeException(String.valueOf(batch.getClass().getSimpleName()) + " cannot render meshes, PolygonSpriteBatch or TwoColorPolygonBatch is required.");
                    }
                    if (attachment instanceof SkeletonAttachment && (attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                        this.draw(batch, attachmentSkeleton);
                    }
lbl70:
                    // 4 sources

                    this.clipper.clipEnd(slot);
                }
            }
            ++i;
        }
        this.clipper.clipEnd();
        if (vertexEffect != null) {
            vertexEffect.end();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void draw(PolygonSpriteBatch batch, Skeleton skeleton) {
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        tempPosition = this.temp;
        tempUV = this.temp2;
        tempLight1 = this.temp3;
        tempDark1 = this.temp4;
        tempLight2 = this.temp5;
        tempDark2 = this.temp6;
        vertexEffect = this.vertexEffect;
        if (vertexEffect != null) {
            vertexEffect.begin(skeleton);
        }
        premultipliedAlpha = this.premultipliedAlpha;
        blendMode = null;
        verticesLength = 0;
        vertices = null;
        uvs = null;
        triangles = null;
        color = null;
        skeletonColor = skeleton.color;
        r = skeletonColor.r;
        g = skeletonColor.g;
        b = skeletonColor.b;
        a = skeletonColor.a;
        drawOrder = skeleton.drawOrder;
        i = 0;
        n = drawOrder.size;
        while (i < n) {
            block19: {
                block21: {
                    block20: {
                        block18: {
                            slot = drawOrder.get(i);
                            if (slot.bone.active) break block18;
                            this.clipper.clipEnd(slot);
                            break block19;
                        }
                        texture = null;
                        vertexSize = this.clipper.isClipping() != false ? 2 : 5;
                        attachment = slot.attachment;
                        if (!(attachment instanceof RegionAttachment)) break block20;
                        region = (RegionAttachment)attachment;
                        verticesLength = vertexSize << 2;
                        vertices = this.vertices.items;
                        region.computeWorldVertices(slot.getBone(), vertices, 0, vertexSize);
                        triangles = SkeletonRenderer.quadTriangles;
                        texture = region.getRegion().getTexture();
                        uvs = region.getUVs();
                        color = region.getColor();
                        ** GOTO lbl68
                    }
                    if (!(attachment instanceof MeshAttachment)) break block21;
                    mesh = (MeshAttachment)attachment;
                    count = mesh.getWorldVerticesLength();
                    verticesLength = (count >> 1) * vertexSize;
                    vertices = this.vertices.setSize(verticesLength);
                    mesh.computeWorldVertices(slot, 0, count, vertices, 0, vertexSize);
                    triangles = mesh.getTriangles();
                    texture = mesh.getRegion().getTexture();
                    uvs = mesh.getUVs();
                    color = mesh.getColor();
                    ** GOTO lbl68
                }
                if (attachment instanceof ClippingAttachment) {
                    clip = (ClippingAttachment)attachment;
                    this.clipper.clipStart(slot, clip);
                } else {
                    if (attachment instanceof SkeletonAttachment && (attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                        this.draw(batch, attachmentSkeleton);
                    }
lbl68:
                    // 5 sources

                    if (texture != null) {
                        slotColor = slot.getColor();
                        alpha = a * slotColor.a * color.a * 255.0f;
                        multiplier = premultipliedAlpha != false ? alpha : 255.0f;
                        slotBlendMode = slot.data.getBlendMode();
                        if (slotBlendMode != blendMode) {
                            if (slotBlendMode == BlendMode.additive && premultipliedAlpha) {
                                slotBlendMode = BlendMode.normal;
                                alpha = 0.0f;
                            }
                            blendMode = slotBlendMode;
                            batch.setBlendFunction(blendMode.getSource(premultipliedAlpha), blendMode.getDest());
                        }
                        c = NumberUtils.intToFloatColor((int)alpha << 24 | (int)(b * slotColor.b * color.b * multiplier) << 16 | (int)(g * slotColor.g * color.g * multiplier) << 8 | (int)(r * slotColor.r * color.r * multiplier));
                        if (this.clipper.isClipping()) {
                            this.clipper.clipTriangles(vertices, verticesLength, triangles, triangles.length, uvs, c, 0.0f, false);
                            clippedVertices = this.clipper.getClippedVertices();
                            clippedTriangles = this.clipper.getClippedTriangles();
                            if (vertexEffect != null) {
                                this.applyVertexEffect(clippedVertices.items, clippedVertices.size, 5, c, 0.0f);
                            }
                            batch.draw(texture, clippedVertices.items, 0, clippedVertices.size, clippedTriangles.items, 0, clippedTriangles.size);
                        } else {
                            if (vertexEffect != null) {
                                tempLight1.set(NumberUtils.floatToIntColor(c));
                                tempDark1.set(0);
                                v = 0;
                                u = 0;
                                while (v < verticesLength) {
                                    tempPosition.x = vertices[v];
                                    tempPosition.y = vertices[v + 1];
                                    tempLight2.set(tempLight1);
                                    tempDark2.set(tempDark1);
                                    tempUV.x = uvs[u];
                                    tempUV.y = uvs[u + 1];
                                    vertexEffect.transform(tempPosition, tempUV, tempLight2, tempDark2);
                                    vertices[v] = tempPosition.x;
                                    vertices[v + 1] = tempPosition.y;
                                    vertices[v + 2] = tempLight2.toFloatBits();
                                    vertices[v + 3] = tempUV.x;
                                    vertices[v + 4] = tempUV.y;
                                    v += 5;
                                    u += 2;
                                }
                            } else {
                                v = 2;
                                u = 0;
                                while (v < verticesLength) {
                                    vertices[v] = c;
                                    vertices[v + 1] = uvs[u];
                                    vertices[v + 2] = uvs[u + 1];
                                    v += 5;
                                    u += 2;
                                }
                            }
                            batch.draw(texture, vertices, 0, verticesLength, triangles, 0, triangles.length);
                        }
                    }
                    this.clipper.clipEnd(slot);
                }
            }
            ++i;
        }
        this.clipper.clipEnd();
        if (vertexEffect != null) {
            vertexEffect.end();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void draw(TwoColorPolygonBatch batch, Skeleton skeleton) {
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        tempPosition = this.temp;
        tempUV = this.temp2;
        tempLight1 = this.temp3;
        tempDark1 = this.temp4;
        tempLight2 = this.temp5;
        tempDark2 = this.temp6;
        vertexEffect = this.vertexEffect;
        if (vertexEffect != null) {
            vertexEffect.begin(skeleton);
        }
        premultipliedAlpha = this.premultipliedAlpha;
        batch.setPremultipliedAlpha(premultipliedAlpha);
        blendMode = null;
        verticesLength = 0;
        vertices = null;
        uvs = null;
        triangles = null;
        color = null;
        skeletonColor = skeleton.color;
        r = skeletonColor.r;
        g = skeletonColor.g;
        b = skeletonColor.b;
        a = skeletonColor.a;
        drawOrder = skeleton.drawOrder;
        i = 0;
        n = drawOrder.size;
        while (i < n) {
            block19: {
                block21: {
                    block20: {
                        block18: {
                            slot = drawOrder.get(i);
                            if (slot.bone.active) break block18;
                            this.clipper.clipEnd(slot);
                            break block19;
                        }
                        texture = null;
                        vertexSize = this.clipper.isClipping() != false ? 2 : 6;
                        attachment = slot.attachment;
                        if (!(attachment instanceof RegionAttachment)) break block20;
                        region = (RegionAttachment)attachment;
                        verticesLength = vertexSize << 2;
                        vertices = this.vertices.items;
                        region.computeWorldVertices(slot.getBone(), vertices, 0, vertexSize);
                        triangles = SkeletonRenderer.quadTriangles;
                        texture = region.getRegion().getTexture();
                        uvs = region.getUVs();
                        color = region.getColor();
                        ** GOTO lbl69
                    }
                    if (!(attachment instanceof MeshAttachment)) break block21;
                    mesh = (MeshAttachment)attachment;
                    count = mesh.getWorldVerticesLength();
                    verticesLength = (count >> 1) * vertexSize;
                    vertices = this.vertices.setSize(verticesLength);
                    mesh.computeWorldVertices(slot, 0, count, vertices, 0, vertexSize);
                    triangles = mesh.getTriangles();
                    texture = mesh.getRegion().getTexture();
                    uvs = mesh.getUVs();
                    color = mesh.getColor();
                    ** GOTO lbl69
                }
                if (attachment instanceof ClippingAttachment) {
                    clip = (ClippingAttachment)attachment;
                    this.clipper.clipStart(slot, clip);
                } else {
                    if (attachment instanceof SkeletonAttachment && (attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                        this.draw(batch, attachmentSkeleton);
                    }
lbl69:
                    // 5 sources

                    if (texture != null) {
                        lightColor = slot.getColor();
                        alpha = a * lightColor.a * color.a * 255.0f;
                        multiplier = premultipliedAlpha != false ? alpha : 255.0f;
                        slotBlendMode = slot.data.getBlendMode();
                        if (slotBlendMode != blendMode) {
                            if (slotBlendMode == BlendMode.additive && premultipliedAlpha) {
                                slotBlendMode = BlendMode.normal;
                                alpha = 0.0f;
                            }
                            blendMode = slotBlendMode;
                            batch.setBlendFunction(blendMode.getSource(premultipliedAlpha), blendMode.getDest());
                        }
                        red = r * color.r * multiplier;
                        green = g * color.g * multiplier;
                        blue = b * color.b * multiplier;
                        light = NumberUtils.intToFloatColor((int)alpha << 24 | (int)(blue * lightColor.b) << 16 | (int)(green * lightColor.g) << 8 | (int)(red * lightColor.r));
                        darkColor = slot.getDarkColor();
                        v0 = dark = darkColor == null ? 0.0f : NumberUtils.intToFloatColor((int)(blue * darkColor.b) << 16 | (int)(green * darkColor.g) << 8 | (int)(red * darkColor.r));
                        if (this.clipper.isClipping()) {
                            this.clipper.clipTriangles(vertices, verticesLength, triangles, triangles.length, uvs, light, dark, true);
                            clippedVertices = this.clipper.getClippedVertices();
                            clippedTriangles = this.clipper.getClippedTriangles();
                            if (vertexEffect != null) {
                                this.applyVertexEffect(clippedVertices.items, clippedVertices.size, 6, light, dark);
                            }
                            batch.drawTwoColor(texture, clippedVertices.items, 0, clippedVertices.size, clippedTriangles.items, 0, clippedTriangles.size);
                        } else {
                            if (vertexEffect != null) {
                                tempLight1.set(NumberUtils.floatToIntColor(light));
                                tempDark1.set(NumberUtils.floatToIntColor(dark));
                                v = 0;
                                u = 0;
                                while (v < verticesLength) {
                                    tempPosition.x = vertices[v];
                                    tempPosition.y = vertices[v + 1];
                                    tempLight2.set(tempLight1);
                                    tempDark2.set(tempDark1);
                                    tempUV.x = uvs[u];
                                    tempUV.y = uvs[u + 1];
                                    vertexEffect.transform(tempPosition, tempUV, tempLight2, tempDark2);
                                    vertices[v] = tempPosition.x;
                                    vertices[v + 1] = tempPosition.y;
                                    vertices[v + 2] = tempLight2.toFloatBits();
                                    vertices[v + 3] = tempDark2.toFloatBits();
                                    vertices[v + 4] = tempUV.x;
                                    vertices[v + 5] = tempUV.y;
                                    v += 6;
                                    u += 2;
                                }
                            } else {
                                v = 2;
                                u = 0;
                                while (v < verticesLength) {
                                    vertices[v] = light;
                                    vertices[v + 1] = dark;
                                    vertices[v + 2] = uvs[u];
                                    vertices[v + 3] = uvs[u + 1];
                                    v += 6;
                                    u += 2;
                                }
                            }
                            batch.drawTwoColor(texture, vertices, 0, verticesLength, triangles, 0, triangles.length);
                        }
                    }
                    this.clipper.clipEnd(slot);
                }
            }
            ++i;
        }
        this.clipper.clipEnd();
        if (vertexEffect != null) {
            vertexEffect.end();
        }
    }

    private void applyVertexEffect(float[] vertices, int verticesLength, int stride, float light, float dark) {
        Vector2 tempPosition = this.temp;
        Vector2 tempUV = this.temp2;
        Color tempLight1 = this.temp3;
        Color tempDark1 = this.temp4;
        Color tempLight2 = this.temp5;
        Color tempDark2 = this.temp6;
        VertexEffect vertexEffect = this.vertexEffect;
        tempLight1.set(NumberUtils.floatToIntColor(light));
        tempDark1.set(NumberUtils.floatToIntColor(dark));
        if (stride == 5) {
            int v = 0;
            while (v < verticesLength) {
                tempPosition.x = vertices[v];
                tempPosition.y = vertices[v + 1];
                tempUV.x = vertices[v + 3];
                tempUV.y = vertices[v + 4];
                tempLight2.set(tempLight1);
                tempDark2.set(tempDark1);
                vertexEffect.transform(tempPosition, tempUV, tempLight2, tempDark2);
                vertices[v] = tempPosition.x;
                vertices[v + 1] = tempPosition.y;
                vertices[v + 2] = tempLight2.toFloatBits();
                vertices[v + 3] = tempUV.x;
                vertices[v + 4] = tempUV.y;
                v += stride;
            }
        } else {
            int v = 0;
            while (v < verticesLength) {
                tempPosition.x = vertices[v];
                tempPosition.y = vertices[v + 1];
                tempUV.x = vertices[v + 4];
                tempUV.y = vertices[v + 5];
                tempLight2.set(tempLight1);
                tempDark2.set(tempDark1);
                vertexEffect.transform(tempPosition, tempUV, tempLight2, tempDark2);
                vertices[v] = tempPosition.x;
                vertices[v + 1] = tempPosition.y;
                vertices[v + 2] = tempLight2.toFloatBits();
                vertices[v + 3] = tempDark2.toFloatBits();
                vertices[v + 4] = tempUV.x;
                vertices[v + 5] = tempUV.y;
                v += stride;
            }
        }
    }

    public boolean getPremultipliedAlpha() {
        return this.premultipliedAlpha;
    }

    public void setPremultipliedAlpha(boolean premultipliedAlpha) {
        this.premultipliedAlpha = premultipliedAlpha;
    }

    public VertexEffect getVertexEffect() {
        return this.vertexEffect;
    }

    public void setVertexEffect(VertexEffect vertexEffect) {
        this.vertexEffect = vertexEffect;
    }

    public static interface VertexEffect {
        public void begin(Skeleton var1);

        public void transform(Vector2 var1, Vector2 var2, Color var3, Color var4);

        public void end();
    }
}

