/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.ObjectMap;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterBox;
import com.esotericsoftware.gloomhavenhelper.model.AttackModifier;
import com.esotericsoftware.gloomhavenhelper.model.CharacterClass;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Monster;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.util.DesatDrawable;
import com.esotericsoftware.gloomhavenhelper.util.DragAdjust;
import com.esotericsoftware.gloomhavenhelper.util.Menu;
import com.esotericsoftware.gloomhavenhelper.util.TextMenu;
import com.esotericsoftware.gloomhavenhelper.util.builders.ImageButtonBuilder;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;

public class MonsterBoxMenu
extends Menu {
    final MonsterBox box;
    final Monster monster;
    Table left = new Table();
    private ImageButton hpPlusButton;
    private ImageButton hpMinusButton;
    private Image hpImage;
    private ImageButton blessPlusButton;
    private ImageButton blessMinusButton;
    private ImageButton cursePlusButton;
    private ImageButton curseMinusButton;
    ImageButton killButton;
    ImageTextButton levelButton;
    Label hpLabel;
    Label blessLabel;
    Label curseLabel;
    Label moveLabel;
    Label attackLabel;
    Label rangeLabel;
    private Image curseImage;
    Table conditionsTable;
    Table buttonsTable;
    ImageButton summonButton;
    boolean lastArrowFlip;

    public MonsterBoxMenu(MonsterBox box) {
        this.box = box;
        this.monster = box.monster;
        this.create();
        this.layoutUI();
        this.events();
        if (this.monster.type == MonsterType.summon) {
            this.setBackgroundOffset(-1.0f, 7.0f, 7.0f, 6.0f);
        } else {
            this.setBackgroundOffset(-1.0f, -4.0f, 7.0f, -6.0f);
        }
    }

    private void create() {
        ImageButtonBuilder sub = App.imageButton().imageUp("psd/sub", App.buttonGray).imageOver("psd/sub").imageDisabled("psd/sub", App.disabledGray);
        ImageButtonBuilder add = App.imageButton().imageUp("psd/add", App.buttonGray).imageOver("psd/add").imageDisabled("psd/add", App.disabledGray);
        this.hpMinusButton = sub.create();
        this.hpImage = App.image("blood-large");
        this.hpPlusButton = add.create();
        this.blessMinusButton = sub.create();
        this.blessPlusButton = add.create();
        this.curseMinusButton = sub.create();
        this.cursePlusButton = add.create();
        this.hpLabel = new Label((CharSequence)"", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE);
        this.hpLabel.setTouchable(Touchable.disabled);
        this.blessLabel = new Label((CharSequence)"", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE);
        this.blessLabel.setTouchable(Touchable.disabled);
        this.curseLabel = new Label((CharSequence)"", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE);
        this.curseLabel.setTouchable(Touchable.disabled);
        if (this.monster.stats.immuneCurse) {
            this.curseMinusButton.setDisabled(true);
            this.cursePlusButton.setDisabled(true);
            this.curseImage = App.image(new DesatDrawable(new Drawable[]{App.drawable("curse-large")}));
            this.curseImage.setColor(App.disabledDim);
            this.curseLabel.setColor(App.lightGray);
        } else {
            this.curseImage = App.image("curse-large");
        }
        this.buttonsTable = new Table();
        this.conditionsTable = new Table();
        this.summonButton = ((ImageButtonBuilder)((ImageButtonBuilder)App.imageButton().imageUp("conditions/summon-large").checked("selected")).over("selected", App.buttonGray)).create();
        this.summonButton.setUserObject((Object)Condition.summon);
        this.killButton = App.imageButton().imageUp("psd/skull", App.buttonGray).imageOver("psd/skull", Color.WHITE).create();
        this.levelButton = App.imageTextButton("").imageUp("psd/level", App.buttonGray).imageOver("psd/level").font("plainLargeOutlineFixedNumbers").create();
        this.levelButton.clearChildren();
        this.levelButton.add(this.levelButton.getLabel()).space(8.0f);
        this.levelButton.add(this.levelButton.getImage()).padBottom(4.0f);
    }

    private void layoutUI() {
        this.buttonsTable.columnDefaults(0).size(100.0f);
        this.buttonsTable.columnDefaults(1).fill();
        this.buttonsTable.columnDefaults(2).size(100.0f);
        this.buttonsTable.add(this.hpMinusButton);
        this.buttonsTable.add(new Stack(this.hpImage, new Container<Label>(this.hpLabel).pad(0.0f, 0.0f, -48.0f, -44.0f)));
        this.buttonsTable.add(this.hpPlusButton).row();
        if (this.monster.type != MonsterType.summon) {
            this.buttonsTable.add(this.blessMinusButton);
            this.buttonsTable.add(new Stack(App.image("bless-large"), new Container<Label>(this.blessLabel).pad(0.0f, 0.0f, -48.0f, -44.0f)));
            this.buttonsTable.add(this.blessPlusButton).row();
            this.buttonsTable.add(this.curseMinusButton);
            this.buttonsTable.add(new Stack(this.curseImage, new Container<Label>(this.curseLabel).pad(0.0f, 0.0f, -48.0f, -44.0f)));
            this.buttonsTable.add(this.cursePlusButton).row();
        } else {
            Table stats = new Table();
            stats.defaults().spaceTop(18.0f).spaceRight(9.0f);
            stats.add(App.image("abilities/move"));
            this.moveLabel = new Label((CharSequence)"", App.skin, "plainLargeOutline", Color.WHITE);
            stats.add(this.moveLabel).row();
            stats.add(App.image("abilities/attack"));
            this.attackLabel = new Label((CharSequence)"", App.skin, "plainLargeOutline", Color.WHITE);
            stats.add(this.attackLabel).row();
            stats.add(App.image("abilities/range"));
            this.rangeLabel = new Label((CharSequence)"", App.skin, "plainLargeOutline", Color.WHITE);
            stats.add(this.rangeLabel).row();
            this.buttonsTable.add(stats).colspan(3).growY().row();
        }
        this.left.add(this.buttonsTable).colspan(3).growY().top().row();
        this.left.add(this.killButton).size(100.0f);
        this.left.add(this.levelButton).size(100.0f);
        this.conditionsTable.defaults().size(100.0f);
        this.add(this.left).growY();
        this.add(this.conditionsTable);
    }

    private void events() {
        this.hpPlusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (MonsterBoxMenu.this.monster.hp >= MonsterBoxMenu.this.monster.hpMax) {
                    return;
                }
                ++MonsterBoxMenu.this.monster.hp;
                MonsterBoxMenu.this.box.hpChanged(1);
                int hp = MonsterBoxMenu.this.hpLabel.getText().length == 0 ? 1 : App.parseInt(MonsterBoxMenu.this.hpLabel.getText().toString()) + 1;
                MonsterBoxMenu.this.hpLabel.setText(hp == 0 ? "" : String.valueOf(hp > 0 ? "+" : "") + hp);
                MonsterBoxMenu.this.hpLabel.setColor(hp < 0 ? App.healthRed : App.healthGreen);
            }
        });
        this.hpMinusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (MonsterBoxMenu.this.monster.hp <= 0) {
                    return;
                }
                --MonsterBoxMenu.this.monster.hp;
                MonsterBoxMenu.this.box.hpChanged(-1);
                int hp = MonsterBoxMenu.this.hpLabel.getText().length == 0 ? -1 : App.parseInt(MonsterBoxMenu.this.hpLabel.getText().toString()) - 1;
                MonsterBoxMenu.this.hpLabel.setText(hp == 0 ? "" : String.valueOf(hp > 0 ? "+" : "") + hp);
                MonsterBoxMenu.this.hpLabel.setColor(hp < 0 ? App.healthRed : App.healthGreen);
            }
        });
        new DragAdjust(this.hpLabel, new Actor[]{this.hpPlusButton, this.hpImage, this.hpMinusButton}){
            long lastAnimateIcon;

            @Override
            protected int getValue() {
                return MonsterBoxMenu.this.monster.hp;
            }

            @Override
            protected int getMax() {
                return MonsterBoxMenu.this.monster.hpMax;
            }

            @Override
            protected void setValue(int value) {
                if (MonsterBoxMenu.this.monster.hp != value) {
                    MonsterBoxMenu.this.box.hpChanged(value + this.extra - this.start);
                }
                MonsterBoxMenu.this.monster.hp = value;
                MonsterBoxMenu.this.hpLabel.setColor(value + this.extra < this.start ? App.healthRed : App.healthGreen);
            }
        };
        this.blessPlusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.bless, false) >= 10) {
                    return;
                }
                int bless = App.parseInt(MonsterBoxMenu.this.blessLabel.getText().toString()) + 1;
                MonsterBoxMenu.this.blessLabel.setText("" + bless);
                App.state.add(AttackModifier.bless);
                App.state.attackModifiers.shuffle();
            }
        });
        this.blessMinusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.bless, false) == 0) {
                    return;
                }
                int bless = Math.max(0, App.parseInt(MonsterBoxMenu.this.blessLabel.getText().toString()) - 1);
                MonsterBoxMenu.this.blessLabel.setText("" + bless);
                App.state.remove(AttackModifier.bless);
                App.state.attackModifiers.shuffle();
            }
        });
        this.cursePlusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.curse, false) >= 10) {
                    return;
                }
                int curse = App.parseInt(MonsterBoxMenu.this.curseLabel.getText().toString()) + 1;
                MonsterBoxMenu.this.curseLabel.setText("" + curse);
                App.state.addCurse();
            }
        });
        this.curseMinusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.curse, false) == 0) {
                    return;
                }
                int curse = Math.max(0, App.parseInt(MonsterBoxMenu.this.curseLabel.getText().toString()) - 1);
                MonsterBoxMenu.this.curseLabel.setText("" + curse);
                App.state.remove(AttackModifier.curse);
                App.state.attackModifiers.shuffle();
            }
        });
        this.summonButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (MonsterBoxMenu.this.summonButton.isChecked()) {
                    MonsterBoxMenu.this.monster.conditions.add(Condition.summonNew);
                    MonsterBoxMenu.this.monster.conditions.sort();
                } else {
                    MonsterBoxMenu.this.monster.conditions.removeValue(Condition.summon, true);
                    if (MonsterBoxMenu.this.monster.conditions.removeValue(Condition.summonNew, true)) {
                        MonsterBoxMenu.this.monster.conditions.add(Condition.summon);
                        MonsterBoxMenu.this.monster.conditions.sort();
                        MonsterBoxMenu.this.summonButton.setChecked(true);
                    }
                }
            }
        });
        this.conditionsTable.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ImageButton button = (ImageButton)actor;
                if (button == MonsterBoxMenu.this.summonButton) {
                    return;
                }
                Condition condition = (Condition)((Object)button.getUserObject());
                if (button.isChecked()) {
                    if (!App.state.canDraw && MonsterBoxMenu.this.box.row.isCurrentTurn()) {
                        MonsterBoxMenu.this.monster.currentTurnConditions.add(condition);
                    }
                    MonsterBoxMenu.this.monster.conditions.add(condition);
                    MonsterBoxMenu.this.monster.conditions.sort();
                    MonsterBoxMenu.this.box.flashIcon(condition.name());
                } else {
                    MonsterBoxMenu.this.monster.conditions.removeValue(condition, true);
                    MonsterBoxMenu.this.monster.currentTurnConditions.removeValue(condition, true);
                }
            }
        });
        this.killButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MonsterBoxMenu.this.animate = false;
                MonsterBoxMenu.this.hide();
                MonsterBoxMenu.this.animate = true;
                MonsterBoxMenu.this.box.removeMonster(true);
                App.state.changed();
            }
        });
        this.levelButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MonsterBoxMenu.this.animate = false;
                MonsterBoxMenu.this.hide();
                MonsterBoxMenu.this.animate = true;
                TextMenu menu = new TextMenu(){

                    @Override
                    public boolean hide() {
                        boolean hidden = super.hide();
                        if (hidden) {
                            App.state.changed();
                        }
                        return hidden;
                    }
                };
                final ImageButton starButton = ((ImageButtonBuilder)((ImageButtonBuilder)App.imageButton().imageUp("conditions/star-large").checked("selected")).over("selected", App.buttonGray)).create();
                starButton.setChecked(MonsterBoxMenu.this.monster.conditions.contains(Condition.star, true));
                starButton.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        boolean checked = starButton.isChecked();
                        if (checked) {
                            (this).MonsterBoxMenu.this.monster.conditions.add(Condition.star);
                            (this).MonsterBoxMenu.this.monster.conditions.sort();
                            (this).MonsterBoxMenu.this.box.flashIcon("star");
                            (this).MonsterBoxMenu.this.box.row.animateIcon((this).MonsterBoxMenu.this.box, "conditions/star-large", 1.6f, 54.0f, 40.0f);
                        } else {
                            (this).MonsterBoxMenu.this.monster.conditions.removeValue(Condition.star, true);
                        }
                        int scenario = App.state.scenarioNumber;
                        String name = (this).MonsterBoxMenu.this.monster.data.english;
                        boolean elite = (this).MonsterBoxMenu.this.monster.type == MonsterType.elite;
                        boolean hpTimesPlayers = false;
                        hpTimesPlayers |= scenario == 62 && name.equals("Living Bones") && elite;
                        boolean bl = scenario == 87 && name.equals("Ooze") && elite;
                        int playerCount = App.gloom.playerCount();
                        if ((hpTimesPlayers |= bl) && playerCount > 0) {
                            (this).MonsterBoxMenu.this.monster.hpMax = (this).MonsterBoxMenu.this.monster.stats.hpMax();
                            if (checked) {
                                (this).MonsterBoxMenu.this.monster.hpMax *= playerCount;
                            }
                            (this).MonsterBoxMenu.this.monster.hp = (this).MonsterBoxMenu.this.monster.hpMax;
                        }
                    }
                });
                starButton.addListener(App.tooltip("Special monsters can be marked with a star to denote that they are not affected by character abilities that target only normal or elite monsters."));
                if (MonsterBoxMenu.this.monster.type != MonsterType.summon) {
                    Table levelTable = new Table(App.skin);
                    levelTable.pad(5.0f, 12.0f, 0.0f, 12.0f).defaults().size(100.0f);
                    levelTable.add(App.image("psd/level"));
                    ButtonGroup<Button> buttonGroup = new ButtonGroup<Button>();
                    int i = 0;
                    while (i <= 7) {
                        Button button = ((TextButtonBuilder)App.textButton(String.valueOf(i)).checkedFontColor(Color.WHITE)).create();
                        buttonGroup.add(button);
                        final int level = i;
                        button.addListener(new ChangeListener(){

                            @Override
                            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                (this).MonsterBoxMenu.this.box.row.setLevel(level);
                            }
                        });
                        if (i == MonsterBoxMenu.this.box.row.getLevel()) {
                            button.setChecked(true);
                        }
                        if (App.state.scenarioNumber >= 0 && i == App.state.scenarioLevel) {
                            ((TextButton)button).getStyle().up = App.drawable("selected", App.disabledGray);
                        }
                        levelTable.add(button);
                        if (i == 3) {
                            levelTable.row();
                        }
                        ++i;
                    }
                    levelTable.add(starButton);
                    menu.table.add(levelTable).row();
                }
                ImageButtonBuilder sub = App.imageButton().imageUp("psd/sub", App.buttonGray).imageOver("psd/sub").imageDisabled("psd/sub", App.disabledGray);
                ImageButtonBuilder add = App.imageButton().imageUp("psd/add", App.buttonGray).imageOver("psd/add");
                ImageButton hpMinusButton = sub.create();
                Image hpImage = App.image("blood-large");
                ImageButton hpPlusButton = add.create();
                Label hpMaxLabel = new Label("", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE){

                    @Override
                    public void draw(Batch batch, float parentAlpha) {
                        this.setText(String.valueOf((this).MonsterBoxMenu.this.monster.hp) + "/" + (this).MonsterBoxMenu.this.monster.hpMax);
                        super.draw(batch, parentAlpha);
                    }
                };
                hpMaxLabel.setAlignment(1);
                hpMaxLabel.setTouchable(Touchable.disabled);
                hpPlusButton.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if ((this).MonsterBoxMenu.this.monster.hp >= (this).MonsterBoxMenu.this.monster.hpMax) {
                            (this).MonsterBoxMenu.this.monster.hp = (this).MonsterBoxMenu.this.monster.hpMax + 1;
                        }
                        ++(this).MonsterBoxMenu.this.monster.hpMax;
                    }
                });
                hpMinusButton.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if ((this).MonsterBoxMenu.this.monster.hpMax <= 1) {
                            return;
                        }
                        if ((this).MonsterBoxMenu.this.monster.hp <= (this).MonsterBoxMenu.this.monster.hpMax) {
                            (this).MonsterBoxMenu.this.monster.hp = (this).MonsterBoxMenu.this.monster.hpMax - 1;
                        }
                        --(this).MonsterBoxMenu.this.monster.hpMax;
                    }
                });
                Actor[] actorArray = new Actor[]{hpPlusButton, hpImage, hpMinusButton};
                new DragAdjust(null, (Actor[])actorArray){

                    @Override
                    protected int getValue() {
                        return (this).MonsterBoxMenu.this.monster.hpMax;
                    }

                    @Override
                    protected void setValue(int value) {
                        if ((this).MonsterBoxMenu.this.monster.hp >= (this).MonsterBoxMenu.this.monster.hpMax) {
                            (this).MonsterBoxMenu.this.monster.hp = value;
                        }
                        (this).MonsterBoxMenu.this.monster.hpMax = value;
                    }
                }.min = 1;
                Table buttons = new Table();
                buttons.add(hpMinusButton).size(100.0f);
                buttons.add(new Stack(hpImage, new Container<4>(hpMaxLabel).bottom().width(0.0f))).fill();
                buttons.add(hpPlusButton).size(100.0f).row();
                menu.table.add(buttons);
                if (MonsterBoxMenu.this.monster.type == MonsterType.summon) {
                    ImageButton moveMinusButton = sub.create();
                    Image moveImage = App.image("abilities/move");
                    ImageButton movePlusButton = add.create();
                    Label moveLabel = new Label("", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE){

                        @Override
                        public void draw(Batch batch, float parentAlpha) {
                            if ((this).MonsterBoxMenu.this.monster.summonMove == 0) {
                                this.setText("-");
                            } else {
                                this.setText((this).MonsterBoxMenu.this.monster.summonMove);
                            }
                            super.draw(batch, parentAlpha);
                        }
                    };
                    moveLabel.setAlignment(1);
                    moveLabel.setTouchable(Touchable.disabled);
                    movePlusButton.addListener(new ChangeListener(){

                        @Override
                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            ++(this).MonsterBoxMenu.this.monster.summonMove;
                        }
                    });
                    moveMinusButton.addListener(new ChangeListener(){

                        @Override
                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            if ((this).MonsterBoxMenu.this.monster.summonMove > 0) {
                                --(this).MonsterBoxMenu.this.monster.summonMove;
                            }
                        }
                    });
                    ImageButton attackMinusButton = sub.create();
                    Image attackImage = App.image("abilities/attack");
                    ImageButton attackPlusButton = add.create();
                    Label attackLabel = new Label("", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE){

                        @Override
                        public void draw(Batch batch, float parentAlpha) {
                            if ((this).MonsterBoxMenu.this.monster.summonAttack == 0) {
                                this.setText("-");
                            } else {
                                this.setText((this).MonsterBoxMenu.this.monster.summonAttack);
                            }
                            super.draw(batch, parentAlpha);
                        }
                    };
                    attackLabel.setAlignment(1);
                    attackLabel.setTouchable(Touchable.disabled);
                    attackPlusButton.addListener(new ChangeListener(){

                        @Override
                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            ++(this).MonsterBoxMenu.this.monster.summonAttack;
                        }
                    });
                    attackMinusButton.addListener(new ChangeListener(){

                        @Override
                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            if ((this).MonsterBoxMenu.this.monster.summonAttack > 0) {
                                --(this).MonsterBoxMenu.this.monster.summonAttack;
                            }
                        }
                    });
                    ImageButton rangeMinusButton = sub.create();
                    Image rangeImage = App.image("abilities/range");
                    ImageButton rangePlusButton = add.create();
                    Label rangeLabel = new Label("", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE){

                        @Override
                        public void draw(Batch batch, float parentAlpha) {
                            if ((this).MonsterBoxMenu.this.monster.summonRange == 0) {
                                this.setText("-");
                            } else {
                                this.setText((this).MonsterBoxMenu.this.monster.summonRange);
                            }
                            super.draw(batch, parentAlpha);
                        }
                    };
                    rangeLabel.setAlignment(1);
                    rangeLabel.setTouchable(Touchable.disabled);
                    rangePlusButton.addListener(new ChangeListener(){

                        @Override
                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            ++(this).MonsterBoxMenu.this.monster.summonRange;
                        }
                    });
                    rangeMinusButton.addListener(new ChangeListener(){

                        @Override
                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            if ((this).MonsterBoxMenu.this.monster.summonRange > 0) {
                                --(this).MonsterBoxMenu.this.monster.summonRange;
                            }
                        }
                    });
                    buttons.add(moveMinusButton).size(100.0f);
                    buttons.add(new Stack(moveImage, new Container<8>(moveLabel).bottom().width(0.0f))).fill();
                    buttons.add(movePlusButton).size(100.0f).row();
                    buttons.add(attackMinusButton).size(100.0f);
                    buttons.add(new Stack(attackImage, new Container<11>(attackLabel).bottom().width(0.0f))).fill();
                    buttons.add(attackPlusButton).size(100.0f).row();
                    buttons.add(rangeMinusButton).size(100.0f);
                    buttons.add(new Stack(rangeImage, new Container<14>(rangeLabel).bottom().width(0.0f))).fill();
                    buttons.add(rangePlusButton).size(100.0f).row();
                }
                menu.setBackgroundOffset(-1.0f, -2.0f, 7.0f, 3.0f);
                menu.animate = false;
                menu.show(MonsterBoxMenu.this);
                menu.animate = true;
            }
        });
    }

    private ImageButton newConditionButton(Condition condition, ObjectMap<Condition, ImageButton> buttons) {
        Drawable drawable = App.drawable("conditions/" + condition.name() + "-large");
        ImageButton button = ((ImageButtonBuilder)((ImageButtonBuilder)((ImageButtonBuilder)App.imageButton().imageUp(drawable).checked("selected")).over("selected", App.buttonGray)).disabled("white", Color.CLEAR)).imageDisabled(new DesatDrawable(new Drawable[]{drawable})).create();
        button.setUserObject((Object)condition);
        buttons.put(condition, button);
        return button;
    }

    @Override
    public boolean show(Actor positionActor, float positionX, float positionY, float positionWidth, float positionHeight, boolean preferRight) {
        int startCondition;
        this.hpLabel.setText("");
        this.blessLabel.setText(String.valueOf(App.state.count(AttackModifier.bless, false)));
        this.curseLabel.setText(String.valueOf(App.state.count(AttackModifier.curse, false)));
        this.levelButton.setText(String.valueOf(this.box.row.getLevel()));
        this.conditionsTable.clearChildren();
        ObjectMap<Condition, ImageButton> buttons = new ObjectMap<Condition, ImageButton>();
        int i = startCondition = 3;
        int n = Condition.values.length;
        while (i < n) {
            Condition condition = Condition.values[i];
            if (condition != Condition.doom) {
                ImageButton button = this.newConditionButton(condition, buttons);
                Cell<ImageButton> cell = this.conditionsTable.add(button);
                if ((i - startCondition + 1) % 3 == 0) {
                    this.conditionsTable.row();
                }
                if (condition == Condition.poison) {
                    Table table = new Table();
                    table.defaults().size(100.0f);
                    if (this.monster.type != MonsterType.summon) {
                        table.add(this.summonButton);
                    }
                    if (App.gloom.hasCharacterClass(CharacterClass.Doomstalker)) {
                        table.add(this.newConditionButton(Condition.doom, buttons));
                    }
                    if (table.hasChildren()) {
                        this.conditionsTable.add(table).colspan(3).row();
                    } else {
                        this.conditionsTable.add().height(100.0f).row();
                    }
                }
                if (this.monster.stats.immunities.contains(condition)) {
                    button.setDisabled(true);
                    button.setColor(App.disabledDim);
                }
            }
            ++i;
        }
        if (this.monster.type == MonsterType.summon) {
            this.moveLabel.setText(this.monster.summonMove == 0 ? "-" : Integer.toString(this.monster.summonMove));
            this.attackLabel.setText(this.monster.summonAttack == 0 ? "-" : Integer.toString(this.monster.summonAttack));
            this.rangeLabel.setText(this.monster.summonRange == 0 ? "-" : Integer.toString(this.monster.summonRange));
        }
        for (ImageButton button : buttons.values()) {
            button.setChecked(false);
        }
        this.summonButton.setChecked(false);
        for (Condition condition : this.monster.conditions) {
            if (condition == Condition.summon || condition == Condition.summonNew || condition == Condition.star) {
                this.summonButton.setChecked(true);
                continue;
            }
            ImageButton button = buttons.get(condition);
            if (button == null) continue;
            button.setChecked(true);
        }
        return super.show(positionActor, positionX, positionY, positionWidth, positionHeight, preferRight);
    }

    @Override
    public boolean hide() {
        super.hide();
        this.box.checkDead(true);
        App.state.changed();
        return true;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.hpMinusButton.setDisabled(this.monster.hp <= 0);
        int blesses = App.state.count(AttackModifier.bless, false);
        this.blessMinusButton.setDisabled(blesses <= 0);
        this.blessPlusButton.setDisabled(blesses >= 10);
        int curses = App.state.count(AttackModifier.curse, false);
        this.curseMinusButton.setDisabled(curses <= 0 || this.monster.stats.immuneCurse);
        this.cursePlusButton.setDisabled(curses >= 10 || this.monster.stats.immuneCurse);
    }

    @Override
    protected void updatePosition() {
        super.updatePosition();
        if (this.lastArrowFlip != this.arrowFlip) {
            this.lastArrowFlip = this.arrowFlip;
            this.clearChildren();
            this.left.clearChildren();
            this.left.add(this.buttonsTable).colspan(3).growY().top().row();
            if (this.arrowFlip) {
                if (this.monster.type != MonsterType.summon) {
                    this.left.add(this.summonButton).size(100.0f);
                }
                this.left.add(this.levelButton).size(100.0f);
                this.left.add(this.killButton).size(100.0f);
                this.add(this.conditionsTable);
                this.add(this.left).fill().growY();
            } else {
                this.left.add(this.killButton).size(100.0f);
                this.left.add(this.levelButton).size(100.0f);
                if (this.monster.type != MonsterType.summon) {
                    this.left.add(this.summonButton).size(100.0f);
                }
                this.add(this.left).fill().growY();
                this.add(this.conditionsTable);
            }
            this.buttonsTable.invalidate();
        }
    }
}

