/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class GlyphLayout
implements Pool.Poolable {
    public final Array<GlyphRun> runs = new Array();
    public float width;
    public float height;
    private final Array<Color> colorStack = new Array(4);

    public GlyphLayout() {
    }

    public GlyphLayout(BitmapFont font, CharSequence str) {
        this.setText(font, str);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, color, targetWidth, halign, wrap);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        this.setText(font, str, start, end, color, targetWidth, halign, wrap, truncate);
    }

    public void setText(BitmapFont font, CharSequence str) {
        this.setText(font, str, 0, str.length(), font.getColor(), 0.0f, 8, false, null);
    }

    public void setText(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, 0, str.length(), color, targetWidth, halign, wrap, null);
    }

    public void setText(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        int n;
        BitmapFont.BitmapFontData fontData = font.data;
        if (truncate != null) {
            wrap = true;
        } else if (targetWidth <= fontData.spaceXadvance * 3.0f) {
            wrap = false;
        }
        boolean markupEnabled = fontData.markupEnabled;
        Pool<GlyphRun> glyphRunPool = Pools.get(GlyphRun.class);
        Array<GlyphRun> runs = this.runs;
        glyphRunPool.freeAll(runs);
        runs.clear();
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        int lines = 0;
        int blankLines = 0;
        BitmapFont.Glyph lastGlyph = null;
        Array<Color> colorStack = this.colorStack;
        Color nextColor = color;
        colorStack.add(color);
        Pool<Color> colorPool = Pools.get(Color.class);
        int runStart = start;
        block4: while (true) {
            int runEnd = -1;
            boolean newline = false;
            if (start == end) {
                if (runStart == end) break;
                runEnd = end;
            } else {
                switch (str.charAt(start++)) {
                    case '\n': {
                        runEnd = start - 1;
                        newline = true;
                        break;
                    }
                    case '[': {
                        if (!markupEnabled) break;
                        int length = this.parseColorMarkup(str, start, end, colorPool);
                        if (length >= 0) {
                            runEnd = start - 1;
                            start += length + 1;
                            nextColor = colorStack.peek();
                            break;
                        }
                        if (length != -2) break;
                        ++start;
                        continue block4;
                    }
                }
            }
            if (runEnd == -1) continue;
            if (runEnd != runStart) {
                GlyphRun run = glyphRunPool.obtain();
                run.color.set(color);
                fontData.getGlyphs(run, str, runStart, runEnd, lastGlyph);
                if (run.glyphs.size == 0) {
                    glyphRunPool.free(run);
                } else {
                    if (lastGlyph != null) {
                        x -= lastGlyph.fixedWidth ? (float)lastGlyph.xadvance * fontData.scaleX : (float)(lastGlyph.width + lastGlyph.xoffset) * fontData.scaleX - fontData.padRight;
                    }
                    lastGlyph = run.glyphs.peek();
                    run.x = x;
                    run.y = y;
                    if (newline || runEnd == end) {
                        this.adjustLastGlyph(fontData, run);
                    }
                    runs.add(run);
                    float[] xAdvances = run.xAdvances.items;
                    n = run.xAdvances.size;
                    if (!wrap) {
                        float runWidth = 0.0f;
                        int i = 0;
                        while (i < n) {
                            runWidth += xAdvances[i];
                            ++i;
                        }
                        x += runWidth;
                        run.width = runWidth;
                    } else {
                        x += xAdvances[0];
                        run.width = xAdvances[0];
                        if (n >= 1) {
                            x += xAdvances[1];
                            run.width += xAdvances[1];
                            int i = 2;
                            while (i < n) {
                                BitmapFont.Glyph glyph = run.glyphs.get(i - 1);
                                float glyphWidth = (float)(glyph.width + glyph.xoffset) * fontData.scaleX - fontData.padRight;
                                if (x + glyphWidth <= targetWidth) {
                                    run.width += xAdvances[i];
                                    width = Math.max(width, (x += xAdvances[i]) + glyphWidth);
                                } else {
                                    GlyphRun next;
                                    if (truncate != null) {
                                        this.truncate(fontData, run, targetWidth, truncate, i, glyphRunPool);
                                        x = run.x + run.width;
                                        break block4;
                                    }
                                    int wrapIndex = fontData.getWrapIndex(run.glyphs, i);
                                    if (run.x == 0.0f && wrapIndex == 0 || wrapIndex >= run.glyphs.size) {
                                        wrapIndex = i - 1;
                                    }
                                    if (wrapIndex == 0) {
                                        next = run;
                                        run.width = 0.0f;
                                        int glyphCount = run.glyphs.size;
                                        while (wrapIndex < glyphCount) {
                                            if (!fontData.isWhitespace((char)run.glyphs.get((int)wrapIndex).id)) break;
                                            ++wrapIndex;
                                        }
                                        if (wrapIndex > 0) {
                                            run.glyphs.removeRange(0, wrapIndex - 1);
                                            run.xAdvances.removeRange(1, wrapIndex);
                                        }
                                        run.xAdvances.set(0, (float)(-run.glyphs.first().xoffset) * fontData.scaleX - fontData.padLeft);
                                        if (runs.size > 1) {
                                            GlyphRun previous = runs.get(runs.size - 2);
                                            int lastIndex = previous.glyphs.size - 1;
                                            while (lastIndex > 0) {
                                                BitmapFont.Glyph g = previous.glyphs.get(lastIndex);
                                                if (!fontData.isWhitespace((char)g.id)) break;
                                                previous.width -= previous.xAdvances.get(lastIndex + 1);
                                                --lastIndex;
                                            }
                                            previous.glyphs.truncate(lastIndex + 1);
                                            previous.xAdvances.truncate(lastIndex + 2);
                                            this.adjustLastGlyph(fontData, previous);
                                            width = Math.max(width, previous.x + previous.width);
                                        }
                                    } else {
                                        next = this.wrap(fontData, run, glyphRunPool, wrapIndex, i);
                                        width = Math.max(width, run.x + run.width);
                                        if (next == null) {
                                            x = 0.0f;
                                            y += fontData.down;
                                            ++lines;
                                            lastGlyph = null;
                                            break;
                                        }
                                        runs.add(next);
                                    }
                                    n = next.xAdvances.size;
                                    xAdvances = next.xAdvances.items;
                                    x = xAdvances[0];
                                    if (n > 1) {
                                        x += xAdvances[1];
                                    }
                                    next.width += x;
                                    ++lines;
                                    next.x = 0.0f;
                                    next.y = y += fontData.down;
                                    i = 1;
                                    run = next;
                                    lastGlyph = null;
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
            if (newline) {
                width = Math.max(width, x);
                x = 0.0f;
                float down = fontData.down;
                if (runEnd == runStart) {
                    down *= fontData.blankLineScale;
                    ++blankLines;
                } else {
                    ++lines;
                }
                y += down;
                lastGlyph = null;
            }
            runStart = start;
            color = nextColor;
        }
        width = Math.max(width, x);
        int i = 1;
        int n2 = colorStack.size;
        while (i < n2) {
            colorPool.free(colorStack.get(i));
            ++i;
        }
        colorStack.clear();
        if ((halign & 8) == 0) {
            boolean center = (halign & 1) != 0;
            float lineWidth = 0.0f;
            float lineY = -2.1474836E9f;
            int lineStart = 0;
            n = runs.size;
            int i2 = 0;
            while (i2 < n) {
                GlyphRun run = runs.get(i2);
                if (run.y != lineY) {
                    lineY = run.y;
                    float shift = targetWidth - lineWidth;
                    if (center) {
                        shift /= 2.0f;
                    }
                    while (lineStart < i2) {
                        runs.get((int)lineStart++).x += shift;
                    }
                    lineWidth = 0.0f;
                }
                lineWidth = Math.max(lineWidth, run.x + run.width);
                ++i2;
            }
            float shift = targetWidth - lineWidth;
            if (center) {
                shift /= 2.0f;
            }
            while (lineStart < n) {
                runs.get((int)lineStart++).x += shift;
            }
        }
        this.width = width;
        this.height = fontData.flipped ? fontData.capHeight + (float)lines * fontData.down + (float)blankLines * fontData.down * fontData.blankLineScale : fontData.capHeight + (float)lines * -fontData.down + (float)blankLines * -fontData.down * fontData.blankLineScale;
    }

    private void truncate(BitmapFont.BitmapFontData fontData, GlyphRun run, float targetWidth, String truncate, int widthIndex, Pool<GlyphRun> glyphRunPool) {
        GlyphRun truncateRun = glyphRunPool.obtain();
        fontData.getGlyphs(truncateRun, truncate, 0, truncate.length(), null);
        float truncateWidth = 0.0f;
        if (truncateRun.xAdvances.size > 0) {
            this.adjustLastGlyph(fontData, truncateRun);
            int i = 1;
            int n = truncateRun.xAdvances.size;
            while (i < n) {
                truncateWidth += truncateRun.xAdvances.get(i);
                ++i;
            }
        }
        targetWidth -= truncateWidth;
        int count = 0;
        float width = run.x;
        while (count < run.xAdvances.size) {
            float xAdvance = run.xAdvances.get(count);
            if ((width += xAdvance) > targetWidth) {
                run.width = width - run.x - xAdvance;
                break;
            }
            ++count;
        }
        if (count > 1) {
            run.glyphs.truncate(count - 1);
            run.xAdvances.truncate(count);
            this.adjustLastGlyph(fontData, run);
            if (truncateRun.xAdvances.size > 0) {
                run.xAdvances.addAll(truncateRun.xAdvances, 1, truncateRun.xAdvances.size - 1);
            }
        } else {
            run.glyphs.clear();
            run.xAdvances.clear();
            run.xAdvances.addAll(truncateRun.xAdvances);
            if (truncateRun.xAdvances.size > 0) {
                run.width += truncateRun.xAdvances.get(0);
            }
        }
        run.glyphs.addAll(truncateRun.glyphs);
        run.width += truncateWidth;
        glyphRunPool.free(truncateRun);
    }

    private GlyphRun wrap(BitmapFont.BitmapFontData fontData, GlyphRun first, Pool<GlyphRun> glyphRunPool, int wrapIndex, int widthIndex) {
        Array<BitmapFont.Glyph> glyphs2 = first.glyphs;
        int glyphCount = first.glyphs.size;
        FloatArray xAdvances2 = first.xAdvances;
        int firstEnd = wrapIndex;
        while (firstEnd > 0) {
            if (!fontData.isWhitespace((char)glyphs2.get((int)(firstEnd - 1)).id)) break;
            --firstEnd;
        }
        int secondStart = wrapIndex;
        while (secondStart < glyphCount) {
            if (!fontData.isWhitespace((char)glyphs2.get((int)secondStart).id)) break;
            ++secondStart;
        }
        while (widthIndex < firstEnd) {
            first.width += xAdvances2.get(widthIndex++);
        }
        int n = firstEnd + 1;
        while (widthIndex > n) {
            first.width -= xAdvances2.get(--widthIndex);
        }
        GlyphRun second = null;
        if (secondStart < glyphCount) {
            second = glyphRunPool.obtain();
            second.color.set(first.color);
            Array<BitmapFont.Glyph> glyphs1 = second.glyphs;
            glyphs1.addAll(glyphs2, 0, firstEnd);
            glyphs2.removeRange(0, secondStart - 1);
            first.glyphs = glyphs1;
            second.glyphs = glyphs2;
            FloatArray xAdvances1 = second.xAdvances;
            xAdvances1.addAll(xAdvances2, 0, firstEnd + 1);
            xAdvances2.removeRange(1, secondStart);
            xAdvances2.set(0, (float)(-glyphs2.first().xoffset) * fontData.scaleX - fontData.padLeft);
            first.xAdvances = xAdvances1;
            second.xAdvances = xAdvances2;
        } else {
            glyphs2.truncate(firstEnd);
            xAdvances2.truncate(firstEnd + 1);
        }
        if (firstEnd == 0) {
            glyphRunPool.free(first);
            this.runs.pop();
        } else {
            this.adjustLastGlyph(fontData, first);
        }
        return second;
    }

    private void adjustLastGlyph(BitmapFont.BitmapFontData fontData, GlyphRun run) {
        BitmapFont.Glyph last = run.glyphs.peek();
        if (last.fixedWidth) {
            return;
        }
        float width = (float)(last.width + last.xoffset) * fontData.scaleX - fontData.padRight;
        run.width += width - run.xAdvances.peek();
        run.xAdvances.set(run.xAdvances.size - 1, width);
    }

    private int parseColorMarkup(CharSequence str, int start, int end, Pool<Color> colorPool) {
        if (start == end) {
            return -1;
        }
        switch (str.charAt(start)) {
            case '#': {
                int colorInt = 0;
                int i = start + 1;
                while (i < end) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9) break;
                        if (i - start <= 7) {
                            int ii = 0;
                            int nn = 9 - (i - start);
                            while (ii < nn) {
                                colorInt <<= 4;
                                ++ii;
                            }
                            colorInt |= 0xFF;
                        }
                        Color color = colorPool.obtain();
                        this.colorStack.add(color);
                        Color.rgba8888ToColor(color, colorInt);
                        return i - start;
                    }
                    if (ch >= '0' && ch <= '9') {
                        colorInt = colorInt * 16 + (ch - 48);
                    } else if (ch >= 'a' && ch <= 'f') {
                        colorInt = colorInt * 16 + (ch - 87);
                    } else {
                        if (ch < 'A' || ch > 'F') break;
                        colorInt = colorInt * 16 + (ch - 55);
                    }
                    ++i;
                }
                return -1;
            }
            case '[': {
                return -2;
            }
            case ']': {
                if (this.colorStack.size > 1) {
                    colorPool.free(this.colorStack.pop());
                }
                return 0;
            }
        }
        int colorStart = start;
        int i = start + 1;
        while (i < end) {
            char ch = str.charAt(i);
            if (ch == ']') {
                Color namedColor = Colors.get(str.subSequence(colorStart, i).toString());
                if (namedColor == null) {
                    return -1;
                }
                Color color = colorPool.obtain();
                this.colorStack.add(color);
                color.set(namedColor);
                return i - start;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void reset() {
        Pools.get(GlyphRun.class).freeAll(this.runs);
        this.runs.clear();
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.width);
        buffer.append('x');
        buffer.append(this.height);
        buffer.append('\n');
        int i = 0;
        int n = this.runs.size;
        while (i < n) {
            buffer.append(this.runs.get(i).toString());
            buffer.append('\n');
            ++i;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public static class GlyphRun
    implements Pool.Poolable {
        public Array<BitmapFont.Glyph> glyphs = new Array();
        public FloatArray xAdvances = new FloatArray();
        public float x;
        public float y;
        public float width;
        public final Color color = new Color();

        @Override
        public void reset() {
            this.glyphs.clear();
            this.xAdvances.clear();
            this.width = 0.0f;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.glyphs.size);
            Array<BitmapFont.Glyph> glyphs = this.glyphs;
            int i = 0;
            int n = glyphs.size;
            while (i < n) {
                BitmapFont.Glyph g = glyphs.get(i);
                buffer.append((char)g.id);
                ++i;
            }
            buffer.append(", #");
            buffer.append(this.color);
            buffer.append(", ");
            buffer.append(this.x);
            buffer.append(", ");
            buffer.append(this.y);
            buffer.append(", ");
            buffer.append(this.width);
            return buffer.toString();
        }
    }
}

