/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.util.Animator;
import com.esotericsoftware.gloomhavenhelper.util.Row;

public class Rows
extends WidgetGroup {
    private boolean sizeInvalid;
    private float prefHeight;
    public float padTop = 11.0f;
    public float padBottom = 13.0f;
    public float padLeft = 6.0f;
    public float padRight = 6.0f;
    public float minSpaceX = 7.0f;
    public float maxSpaceX = 80.0f;
    public float spaceX;
    public float spaceY = 11.0f;
    public float startX;
    public int columns;

    @Override
    public void invalidate() {
        if (!Animator.enabled || !Animator.childrenAnimating(this)) {
            super.invalidate();
            this.sizeInvalid = true;
        }
    }

    private void computeSize() {
        float maxHeight;
        this.sizeInvalid = false;
        float width = App.stage.getWidth() - this.padLeft - this.padRight;
        int maxColumns = Math.max(1, (int)Math.floor((width - this.minSpaceX) / 1101.0f));
        this.spaceX = MathUtils.clamp(width - (float)(1101 * this.columns), this.minSpaceX, this.maxSpaceX);
        SnapshotArray<Actor> children = this.getChildren();
        int n = children.size;
        float columnHeight = App.stage.getHeight() - 240.0f - this.padTop - this.padBottom;
        float nextColumnHeight = -1.0f;
        Row.animatedHeight = false;
        while (true) {
            float x = this.padLeft;
            float y = 0.0f;
            boolean first = true;
            this.columns = 1;
            maxHeight = 0.0f;
            int i = 0;
            while (i < n) {
                Row row = (Row)children.get(i);
                if (!App.config.hideMonsters || !(row instanceof MonsterRow)) {
                    float height = row.getPrefHeight();
                    if (!first) {
                        y += this.spaceY;
                        if (this.columns < maxColumns && y + height > columnHeight) {
                            ++this.columns;
                            nextColumnHeight = y + height;
                            y = 0.0f;
                            first = true;
                            x += this.spaceX + 1101.0f;
                        }
                    } else {
                        first = false;
                    }
                    maxHeight = Math.max(maxHeight, y += height);
                }
                ++i;
            }
            if (this.columns <= 1 || !(y > columnHeight)) break;
            columnHeight = nextColumnHeight;
        }
        Row.animatedHeight = true;
        this.prefHeight = maxHeight + this.padTop + this.padBottom;
        this.startX = Math.round((width - ((float)(1101 * this.columns) + this.spaceX * (float)(this.columns - 1))) / 2.0f + this.padLeft);
    }

    @Override
    public void layout() {
        float startY;
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float dragX = 0.0f;
        float dragY = 0.0f;
        if (App.dragRow != null) {
            dragX = App.dragRow.getX();
            dragY = App.dragRow.getY();
        }
        SnapshotArray<Actor> children = this.getChildren();
        float y = 0.0f;
        float x = this.startX;
        float layoutY = startY = this.prefHeight - this.padTop;
        float offsetY = this.getHeight() - this.prefHeight;
        boolean first = true;
        int i = 0;
        int n = children.size;
        while (i < n) {
            Row row = (Row)children.get(i);
            if (App.config.hideMonsters && row instanceof MonsterRow) {
                row.setBounds(0.0f, 0.0f, 1101.0f, 0.0f);
                row.finalX = 0.0f;
                row.finalY = 0.0f;
                row.validate();
            } else {
                float layoutHeight = row.getPrefHeight();
                MonsterRow.animatedHeight = false;
                float height = row.getPrefHeight();
                MonsterRow.animatedHeight = true;
                if (!first) {
                    layoutY -= this.spaceY;
                    if ((y += this.spaceY) + height > this.prefHeight) {
                        layoutY = startY;
                        y = 0.0f;
                        x += this.spaceX + 1101.0f;
                    }
                } else {
                    first = false;
                }
                y += height;
                row.setBounds(Math.round(x), Math.round(offsetY + (layoutY -= layoutHeight)), 1101.0f, Math.round(layoutHeight));
                row.finalX = row.getX();
                row.finalY = row.getY();
                row.validate();
            }
            ++i;
        }
        if (App.dragRow != null) {
            App.dragRow.setPosition(dragX, dragY);
        }
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        Animator.updateChildren(this);
        int index = 0;
        if (App.dragRow != null) {
            index = App.dragRow.getZIndex();
            if (this.columns > 1) {
                float x = App.dragRow.getX();
                float y = App.dragRow.getY();
                App.dragRow.setPosition(App.dragRow.finalX, App.dragRow.finalY);
                App.dragRow.draw(batch, parentAlpha * 0.25f);
                App.dragRow.setPosition(x, y);
            }
            App.dragRow.toFront();
        }
        super.drawChildren(batch, parentAlpha);
        if (App.dragRow != null && index != -1) {
            App.dragRow.setZIndex(index);
        }
    }
}

