/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.generator.database;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import com.sun.jdo.spi.persistence.generator.database.DBElementFactory;
import com.sun.jdo.spi.persistence.generator.database.JDBCInfo;
import com.sun.jdo.spi.persistence.generator.database.LogHelperDatabaseGenerator;
import com.sun.jdo.spi.persistence.generator.database.MappingPolicy;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;

public class DatabaseGenerator {
    private static final char DOT = '.';
    private final Model model;
    private final MappingPolicy mappingPolicy;
    private final List pcClasses;
    private final Map mappingClasses = new HashMap();
    private final SchemaElement schema;
    private final String classSuffix;
    private static final Logger logger = LogHelperDatabaseGenerator.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(DatabaseGenerator.class);

    private DatabaseGenerator(Model model, List pcClasses, MappingPolicy mappingPolicy, String schemaName, String classSuffix) throws DBException {
        this.model = model;
        this.pcClasses = pcClasses;
        this.mappingPolicy = mappingPolicy;
        this.schema = DBElementFactory.createSchema(schemaName);
        this.classSuffix = classSuffix;
    }

    public static Results generate(Model model, List pcClasses, MappingPolicy mappingPolicy, String schemaName, String classSuffix, boolean generateMappingClasses) throws DBException, IOException, ModelException {
        DatabaseGenerator generator = new DatabaseGenerator(model, pcClasses, mappingPolicy, schemaName, classSuffix);
        Results rc = generator.generate();
        mappingPolicy.resetCounter();
        return rc;
    }

    private Results generate() throws DBException, ModelException {
        for (NameTuple nameTuple : this.pcClasses) {
            String pcClassName = nameTuple.getPersistenceClassName();
            String desiredTableName = nameTuple.getDesiredTableName();
            PersistenceClassElement pcClass = this.model.getPersistenceClass(pcClassName);
            String tableName = this.mappingPolicy.getTableName(desiredTableName, this.getShortClassName(nameTuple.getHashClassName()));
            TableElement table = DBElementFactory.createAndAttachTable(this.schema, tableName);
            UniqueKeyElement pKey = DBElementFactory.createAndAttachPrimaryKey(table, this.mappingPolicy.getPrimaryKeyConstraintName(table.getName().getName()));
            MappingClassElement mappingClass = this.createMappingClass(pcClass, table);
            PersistenceFieldElement[] fields = pcClass.getFields();
            if (fields != null) {
                for (int j = 0; j < fields.length; ++j) {
                    PersistenceFieldElement field = fields[j];
                    String fieldName = field.getName();
                    if (field instanceof RelationshipElement) continue;
                    String columnName = this.mappingPolicy.getColumnName(desiredTableName, fieldName, tableName);
                    String fieldType = this.model.getFieldType(pcClassName, fieldName);
                    String fullFieldName = new StringBuffer(desiredTableName).append('.').append(fieldName).toString();
                    JDBCInfo columnType = DBElementFactory.getColumnType(fullFieldName, fieldType, this.mappingPolicy);
                    if (logger.isLoggable(300)) {
                        logger.fine("DBGenerator.generate: " + tableName + "." + columnName + ": " + columnType.toString());
                    }
                    ColumnElement column = DBElementFactory.createAndAttachColumn(columnName, table, columnType);
                    MappingFieldElement mappingField = this.createAndAttachMappingField(fieldName, mappingClass, column);
                    if (!field.isKey()) continue;
                    column.setNullable(false);
                    pKey.addColumn(column);
                    pKey.getAssociatedIndex().addColumn(column);
                    mappingClass.getTable(tableName).addKeyColumn(column);
                }
            }
            this.mappingClasses.put(pcClassName, mappingClass);
        }
        this.addRelationships();
        return new Results(this.schema, this.mappingClasses);
    }

    private TableElement getPrimaryTable(MappingClassElement mappingClass) throws DBException {
        ArrayList tables = mappingClass.getTables();
        MappingTableElement tbl = (MappingTableElement)tables.get(0);
        if (tbl != null) {
            DBIdentifier tblName = DBIdentifier.create((String)tbl.getTable());
            return this.schema.getTable(tblName);
        }
        return null;
    }

    private MappingClassElement createMappingClass(PersistenceClassElement pcClass, TableElement table) throws ModelException {
        MappingClassElementImpl mappingClass = new MappingClassElementImpl(pcClass);
        mappingClass.setDatabaseRoot(this.schema);
        mappingClass.addTable(table);
        return mappingClass;
    }

    private MappingFieldElement createAndAttachMappingField(String fieldName, MappingClassElement mappingClass, ColumnElement column) throws ModelException {
        MappingFieldElementImpl mappingField = new MappingFieldElementImpl(fieldName, mappingClass);
        mappingClass.addField(mappingField);
        mappingField.addColumn((DBMemberElement)column);
        if (column.isBlobType()) {
            mappingField.setFetchGroup(0);
        } else {
            mappingField.setFetchGroup(1);
        }
        return mappingField;
    }

    private void addMappingRelationship(String relationName, MappingClassElement declaringClass, ForeignKeyElement fkey) throws ModelException {
        MappingRelationshipElementImpl impl = new MappingRelationshipElementImpl(relationName, declaringClass);
        ColumnPairElement[] pairs = fkey.getColumnPairs();
        for (int i = 0; i < pairs.length; ++i) {
            ColumnPairElement pair = pairs[i];
            impl.addColumn((DBMemberElement)pair);
        }
        declaringClass.addField(impl);
    }

    private void addAssocMappingRelationship(String relationName, MappingClassElement declaringClass, ForeignKeyElement fkeyForeign) throws ModelException {
        MappingRelationshipElement impl = (MappingRelationshipElement)declaringClass.getField(relationName);
        if (null == impl) {
            impl = new MappingRelationshipElementImpl(relationName, declaringClass);
            declaringClass.addField(impl);
        }
        ColumnPairElement[] pairs = fkeyForeign.getColumnPairs();
        for (int i = 0; i < pairs.length; ++i) {
            ColumnPairElement pair = pairs[i];
            impl.addAssociatedColumn(pair);
        }
    }

    private void addInverseMappingRelationship(String relationName, MappingClassElement declaringClass, ForeignKeyElement fkey, boolean isJoin) throws ModelException, DBException {
        MappingRelationshipElement impl = (MappingRelationshipElement)declaringClass.getField(relationName);
        if (null == impl) {
            impl = new MappingRelationshipElementImpl(relationName, declaringClass);
            declaringClass.addField(impl);
        }
        TableElement declaringTbl = this.getPrimaryTable(declaringClass);
        ColumnPairElement[] pairs = fkey.getColumnPairs();
        for (int i = 0; i < pairs.length; ++i) {
            ColumnPairElement pair = pairs[i];
            ColumnPairElement inversePair = DBElementFactory.createColumnPair(pair.getReferencedColumn(), pair.getLocalColumn(), declaringTbl);
            if (isJoin) {
                impl.addLocalColumn(inversePair);
                continue;
            }
            impl.addColumn((DBMemberElement)inversePair);
        }
    }

    private ForeignKeyElement createRelationship(TableElement srcTable, TableElement relTable, String relName, String inverseRelName, MappingClassElement mappingClass, MappingClassElement relMappingClass, String uniqueId, boolean srcIsJoin) throws DBException, ModelException {
        ForeignKeyElement fKey = DBElementFactory.createAndAttachForeignKey(srcTable, relTable, relName, this.mappingPolicy, uniqueId);
        if (srcIsJoin) {
            this.addInverseMappingRelationship(relName, mappingClass, fKey, true);
            this.addAssocMappingRelationship(inverseRelName, relMappingClass, fKey);
        } else {
            this.addMappingRelationship(relName, mappingClass, fKey);
            this.addInverseMappingRelationship(inverseRelName, relMappingClass, fKey, false);
        }
        return fKey;
    }

    private void addRelationships() throws DBException, ModelException {
        if (logger.isLoggable(500)) {
            logger.fine("add relationship");
        }
        HashMap<RelationshipElement, ForeignKeyElement> relationFKey = new HashMap<RelationshipElement, ForeignKeyElement>();
        ArrayList<DeferredRelationship> deferredRelationships = new ArrayList<DeferredRelationship>();
        for (MappingClassElement mappingClass : this.mappingClasses.values()) {
            String pcClassName = mappingClass.getName();
            PersistenceClassElement pcClass = this.model.getPersistenceClass(pcClassName);
            this.validateModel(pcClass, "pcClass", pcClassName);
            TableElement sourceTable = this.getPrimaryTable(mappingClass);
            this.validateModel(sourceTable, "sourceTable", pcClassName);
            String uniqueId = this.getShortClassName(pcClassName);
            int want = 8;
            int end = uniqueId.length();
            int start = want > end ? 0 : end - want;
            uniqueId = uniqueId.substring(start, end);
            RelationshipElement[] rels = pcClass.getRelationships();
            if (rels == null) continue;
            for (int j = 0; j < rels.length; ++j) {
                ForeignKeyElement fKey;
                RelationshipElement relation = rels[j];
                String relationName = relation.getName();
                int upperBound = relation.getUpperBound();
                String inverseRelName = relation.getInverseRelationshipName();
                this.validateModel(inverseRelName, "inverseRelName", relationName);
                String relClassName = this.model.getRelatedClass(relation);
                this.validateModel(relClassName, "relClassName", relationName);
                MappingClassElement relMappingClass = (MappingClassElement)this.mappingClasses.get(relClassName);
                this.validateModel(relMappingClass, "relMappingClass", relClassName);
                PersistenceClassElement relClass = this.model.getPersistenceClass(relClassName);
                this.validateModel(relClass, "relClass", relClassName);
                RelationshipElement inverseRelation = relClass.getRelationship(inverseRelName);
                this.validateModel(inverseRelation, "inverseRelation", inverseRelName);
                TableElement relTable = this.getPrimaryTable(relMappingClass);
                this.validateModel(relTable, "relTable", relClassName);
                int relUpperBound = inverseRelation.getUpperBound();
                if (logger.isLoggable(500)) {
                    logger.fine("Before adding relationship:" + DatabaseGenerator.getTblInfo("sourceTable", sourceTable, relationName) + DatabaseGenerator.getTblInfo("relTable", relTable, inverseRelName));
                }
                if (upperBound > 1 && relUpperBound > 1) {
                    if (logger.isLoggable(500)) {
                        logger.fine("M-N relationship");
                    }
                    if ((fKey = this.getMappedForeignKey(relation, inverseRelation, relationFKey)) == null) {
                        TableElement joinTable = DBElementFactory.createAndAttachTable(this.schema, this.mappingPolicy.getJoinTableName(sourceTable.getName().getName(), relTable.getName().getName()));
                        fKey = this.createRelationship(joinTable, sourceTable, relationName, inverseRelName, mappingClass, relMappingClass, uniqueId, true);
                        relationFKey.put(relation, fKey);
                        ForeignKeyElement fKey2 = this.createRelationship(joinTable, relTable, inverseRelName, relationName, relMappingClass, mappingClass, uniqueId, true);
                        relationFKey.put(inverseRelation, fKey2);
                    }
                } else if (upperBound > 1 && relUpperBound == 1) {
                    if (logger.isLoggable(500)) {
                        logger.fine("M-1 relationship: skip");
                    }
                } else if (upperBound == 1 && relUpperBound > 1) {
                    if (logger.isLoggable(500)) {
                        logger.fine("1-M relationship");
                    }
                    if ((fKey = this.getMappedForeignKey(relation, inverseRelation, relationFKey)) == null) {
                        fKey = this.createRelationship(sourceTable, relTable, relationName, inverseRelName, mappingClass, relMappingClass, uniqueId, false);
                        relationFKey.put(relation, fKey);
                    }
                } else if (upperBound == 1 && relUpperBound == 1 && (fKey = this.getMappedForeignKey(relation, inverseRelation, relationFKey)) == null) {
                    if (relation.getDeleteAction() == 3) {
                        if (logger.isLoggable(500)) {
                            logger.fine("1-1 relationship: cascade(this)");
                        }
                        fKey = this.createRelationship(sourceTable, relTable, relationName, inverseRelName, mappingClass, relMappingClass, uniqueId, false);
                        relationFKey.put(relation, fKey);
                    } else if (inverseRelation.getDeleteAction() == 3) {
                        if (logger.isLoggable(500)) {
                            logger.fine("1-1 relationship: cascade(inverse)");
                        }
                        fKey = this.createRelationship(relTable, sourceTable, inverseRelName, relationName, relMappingClass, mappingClass, uniqueId, false);
                        relationFKey.put(inverseRelation, fKey);
                    } else {
                        if (logger.isLoggable(500)) {
                            logger.fine("1-1 relationship: defer");
                        }
                        deferredRelationships.add(new DeferredRelationship(relation, inverseRelation, sourceTable, relTable, relationName, inverseRelName, mappingClass, relMappingClass, uniqueId));
                    }
                }
                if (!logger.isLoggable(500)) continue;
                logger.fine("After adding relationship:" + DatabaseGenerator.getTblInfo("sourceTable", sourceTable, relationName) + DatabaseGenerator.getTblInfo("relTable", relTable, inverseRelName));
            }
        }
        if (deferredRelationships.size() > 0) {
            this.addDeferredRelationships(deferredRelationships, relationFKey);
        }
    }

    private void addDeferredRelationships(List deferredRelationships, Map relationFKey) throws DBException, ModelException {
        for (DeferredRelationship dr : deferredRelationships) {
            RelationshipElement inverseRelation;
            RelationshipElement relation = dr.getRelation();
            ForeignKeyElement fKey = this.getMappedForeignKey(relation, inverseRelation = dr.getInverseRelation(), relationFKey);
            if (fKey != null) continue;
            TableElement sourceTable = dr.getSourceTable();
            TableElement relTable = dr.getRelTable();
            String relationName = dr.getRelationName();
            String inverseRelName = dr.getInverseRelName();
            MappingClassElement mappingClass = dr.getMappingClass();
            MappingClassElement relMappingClass = dr.getRelMappingClass();
            String uniqueId = dr.getUniqueId();
            ForeignKeyElement[] keys = sourceTable.getForeignKeys();
            if (null != keys && keys.length > 0) {
                fKey = this.createRelationship(sourceTable, relTable, relationName, inverseRelName, mappingClass, relMappingClass, uniqueId, false);
                if (logger.isLoggable(500)) {
                    logger.fine("1-1 deferred relationship (this)" + DatabaseGenerator.getTblInfo("sourceTable", sourceTable, relationName) + DatabaseGenerator.getTblInfo("relTable", relTable, inverseRelName));
                }
            } else {
                fKey = this.createRelationship(relTable, sourceTable, inverseRelName, relationName, relMappingClass, mappingClass, uniqueId, false);
                if (logger.isLoggable(500)) {
                    logger.fine("1-1 deferred relationship (inverse)" + DatabaseGenerator.getTblInfo("sourceTable", sourceTable, relationName) + DatabaseGenerator.getTblInfo("relTable", relTable, inverseRelName));
                }
            }
            relationFKey.put(relation, fKey);
        }
    }

    private ForeignKeyElement getMappedForeignKey(RelationshipElement relation, RelationshipElement inverseRelation, Map relationFKey) {
        ForeignKeyElement fkey = (ForeignKeyElement)relationFKey.get(relation);
        if (fkey == null) {
            return (ForeignKeyElement)relationFKey.get(inverseRelation);
        }
        return fkey;
    }

    private String getShortClassName(String className) {
        int index;
        String shortName = JavaTypeHelper.getShortClassName(className);
        if (this.classSuffix != null && !shortName.equals(this.classSuffix) && (index = shortName.lastIndexOf(this.classSuffix)) != -1) {
            shortName = shortName.substring(0, index);
        }
        return shortName;
    }

    private void validateModel(Object o, String failedItem, String accessor) throws ModelException {
        if (null == o) {
            String msg = I18NHelper.getMessage(messages, "EXC_InvalidRelationshipMapping", failedItem, accessor);
            logger.log(1000, msg);
            throw new ModelException(msg);
        }
    }

    private static String getTblInfo(String tblName, TableElement tbl, String relName) {
        int numFK = tbl.getForeignKeys().length;
        ForeignKeyElement fk = null;
        if (numFK > 0) {
            fk = tbl.getForeignKeys()[0];
        }
        return " " + tblName + "=" + tbl.toString() + ", # keys=" + numFK + ", 1st key=" + fk + "; relationship Name=" + relName;
    }

    static class DeferredRelationship {
        private final RelationshipElement relation;
        private final RelationshipElement inverseRelation;
        private final TableElement sourceTable;
        private final TableElement relTable;
        private final String relationName;
        private final String inverseRelName;
        private final MappingClassElement mappingClass;
        private final MappingClassElement relMappingClass;
        private final String uniqueId;

        DeferredRelationship(RelationshipElement relation, RelationshipElement inverseRelation, TableElement sourceTable, TableElement relTable, String relationName, String inverseRelName, MappingClassElement mappingClass, MappingClassElement relMappingClass, String uniqueId) {
            this.relation = relation;
            this.inverseRelation = inverseRelation;
            this.sourceTable = sourceTable;
            this.relTable = relTable;
            this.relationName = relationName;
            this.inverseRelName = inverseRelName;
            this.mappingClass = mappingClass;
            this.relMappingClass = relMappingClass;
            this.uniqueId = uniqueId;
        }

        RelationshipElement getRelation() {
            return this.relation;
        }

        RelationshipElement getInverseRelation() {
            return this.inverseRelation;
        }

        TableElement getSourceTable() {
            return this.sourceTable;
        }

        TableElement getRelTable() {
            return this.relTable;
        }

        String getRelationName() {
            return this.relationName;
        }

        String getInverseRelName() {
            return this.inverseRelName;
        }

        MappingClassElement getMappingClass() {
            return this.mappingClass;
        }

        MappingClassElement getRelMappingClass() {
            return this.relMappingClass;
        }

        String getUniqueId() {
            return this.uniqueId;
        }
    }

    public static class NameTuple {
        private final String persistenceClassName;
        private final String desiredTableName;
        private final String hashClassName;

        public NameTuple(String persistenceClassName, String desiredTableName, String hashClassName) {
            this.persistenceClassName = persistenceClassName;
            this.desiredTableName = desiredTableName;
            this.hashClassName = hashClassName != null ? hashClassName : persistenceClassName;
        }

        public NameTuple(String persistenceClassName, String desiredTableName) {
            this(persistenceClassName, desiredTableName, null);
        }

        public String getPersistenceClassName() {
            return this.persistenceClassName;
        }

        public String getHashClassName() {
            return this.hashClassName;
        }

        public String getDesiredTableName() {
            return this.desiredTableName;
        }
    }

    public class Results {
        private final SchemaElement schema;
        private final Set mappingClasses;

        Results(SchemaElement schema, Map mappingClasses) {
            this.schema = schema;
            this.mappingClasses = new HashSet(mappingClasses.values());
        }

        public SchemaElement getSchema() {
            return this.schema;
        }

        public Set getMappingClasses() {
            return this.mappingClasses;
        }
    }
}

