/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_source;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_target;
import com.sun.enterprise.tools.upgrade.common.arguments.ArgumentHandler;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsParser {
    private static final Logger _logger = LogService.getLogger();
    private static final StringManager sm = StringManager.getManager(ArgsParser.class);
    private CommonInfoModel commonInfo = CommonInfoModel.getInstance();

    public ArrayList<ArgumentHandler> parse(String[] args) {
        ArrayList<ArgumentHandler> aList = new ArrayList<ArgumentHandler>();
        int srcIndx = 0;
        int trgIndx = 0;
        for (int i = 0; i < args.length; ++i) {
            String tmpArg = args[i];
            if (!tmpArg.startsWith("-")) continue;
            ArgumentHandler aHandler = this.getArgHandler(tmpArg = tmpArg.substring(tmpArg.lastIndexOf("-") + 1));
            if (aHandler.isRequiresParameter() && i + 1 < args.length) {
                aHandler.setRawParameters(args[++i]);
            }
            aList.add(aHandler);
            aList.addAll(aHandler.getChildren());
            if (aHandler instanceof ARG_target) {
                trgIndx = aList.indexOf(aHandler);
            }
            if (!(aHandler instanceof ARG_source)) continue;
            srcIndx = aList.indexOf(aHandler);
        }
        if (srcIndx > trgIndx) {
            ArgumentHandler tmpA = aList.remove(srcIndx);
            aList.add(trgIndx, tmpA);
        }
        return aList;
    }

    private ArgumentHandler getArgHandler(String cmd) {
        ArgumentHandler aHandler = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.enterprise.tools.upgrade.common.arguments.ARG_" + cmd);
        }
        catch (ClassNotFoundException cnf) {
            try {
                clazz = Class.forName("com.sun.enterprise.tools.upgrade.common.arguments.ARG_UnknownCmd");
            }
            catch (ClassNotFoundException cnf1) {
                _logger.log(Level.INFO, sm.getString("enterprise.tools.upgrade.cli.arg_unknow_class_not_found"));
            }
        }
        catch (Exception e1) {
            _logger.log(Level.INFO, sm.getString("enterprise.tools.upgrade.cli.invalid_option", e1), e1);
        }
        try {
            aHandler = (ArgumentHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            aHandler.setCmd(cmd);
        }
        catch (Exception ex) {
            _logger.log(Level.INFO, sm.getString("enterprise.tools.upgrade.cli.invalid_option", cmd), ex);
            System.exit(1);
        }
        return aHandler;
    }
}

