/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private ResourceBundle bundle;
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName) {
        String bundleName = packageName + ".LocalStrings";
        ClassLoader cl = this.getClass().getClassLoader();
        this.bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl);
    }

    public String getString(String key) {
        if (key == null) {
            String msg = "key is null";
            throw new NullPointerException(msg);
        }
        String str = null;
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            str = "Cannot find message associated with key '" + key + "'";
        }
        return str;
    }

    public String getString(String key, Object[] args) {
        String iString = null;
        String value = this.getString(key);
        try {
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            iString = MessageFormat.format(value, nonNullArgs);
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer();
            buf.append(value);
            for (int i = 0; i < args.length; ++i) {
                buf.append(" arg[" + i + "]=" + args[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args);
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }
}

