/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintConstant;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintParamIndex;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintSubquery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputParamValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.TableElement;

public abstract class Statement
implements Cloneable {
    private static final Integer ONE = new Integer(1);
    protected static final int OP_PREFIX_MASK = 1;
    protected static final int OP_INFIX_MASK = 2;
    protected static final int OP_POSTFIX_MASK = 4;
    protected static final int OP_PAREN_MASK = 8;
    protected static final int OP_ORDERBY_MASK = 16;
    protected static final int OP_WHERE_MASK = 32;
    protected static final int OP_IRREGULAR_MASK = 64;
    protected static final int OP_OTHER_MASK = 128;
    protected static final int OP_PARAM_MASK = 256;
    protected static final int OP_BINOP_MASK = 546;
    protected static final int OP_FUNC_MASK = 297;
    protected static final int OP_PCOUNT_MASK = 768;
    protected StringBuffer statementText;
    private String quoteCharStart;
    private String quoteCharEnd;
    protected ArrayList columns;
    Constraint constraint;
    protected InputDesc inputDesc = new InputDesc();
    int action;
    public ArrayList tableList;
    protected DBVendorType vendorType;
    protected ArrayList secondaryTableStatements;
    protected static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)Statement.class.getClassLoader());

    public Statement(DBVendorType vendorType) {
        this.columns = new ArrayList();
        this.constraint = new Constraint();
        this.tableList = new ArrayList();
        this.vendorType = vendorType;
        if (!vendorType.getQuoteSpecialOnly()) {
            this.quoteCharStart = vendorType.getQuoteCharStart();
            this.quoteCharEnd = vendorType.getQuoteCharEnd();
        }
    }

    public void addQueryTable(QueryTable table) {
        if (this.tableList.indexOf(table) == -1) {
            this.tableList.add(table);
        }
    }

    protected ColumnRef getColumnRef(ColumnElement columnElement) {
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            ColumnRef cref = (ColumnRef)this.columns.get(i);
            if (cref.getColumnElement() != columnElement) continue;
            return cref;
        }
        return null;
    }

    protected void addColumnRef(ColumnRef columnRef) {
        columnRef.setIndex(this.columns.size() + 1);
        this.columns.add(columnRef);
    }

    public void addConstraint(LocalFieldDesc lf, Object value) {
        int operation;
        if (value == null) {
            operation = 28;
        } else {
            this.constraint.addValue(value, lf);
            operation = lf.isPrimitiveMappedToNullableColumn() || this.vendorType.mapEmptyStringToNull() && lf.getType() == String.class ? 54 : 9;
        }
        this.constraint.addField(lf);
        this.constraint.addOperation(operation);
    }

    public DBVendorType getVendorType() {
        return this.vendorType;
    }

    public void appendTableText(StringBuffer text, QueryTable table) {
        this.appendQuotedText(text, table.getTableDesc().getName());
        text.append(" t");
        text.append(table.getTableIndex());
    }

    protected void appendQuotedText(StringBuffer buffer, String text) {
        buffer.append(this.quoteCharStart);
        buffer.append(text);
        buffer.append(this.quoteCharEnd);
    }

    public String getText() {
        if (this.statementText == null) {
            this.generateStatementText();
        }
        return this.statementText.toString();
    }

    protected abstract void generateStatementText();

    public StringBuffer processConstraints() {
        StringBuffer whereText = new StringBuffer();
        List stack = this.constraint.getConstraints();
        while (stack.size() > 0) {
            ConstraintNode node = (ConstraintNode)stack.get(stack.size() - 1);
            if (!(node instanceof ConstraintOperation)) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.generic.notinstanceof", (String)node.getClass().getName(), (String)"ConstraintOperation"));
            }
            this.processRootConstraint((ConstraintOperation)node, stack, whereText);
        }
        return whereText;
    }

    protected void processRootConstraint(ConstraintOperation opNode, List stack, StringBuffer whereText) {
        String constraint;
        int op = opNode.operation;
        int opInfo = this.operationFormat(op);
        if ((opInfo & 0x20) > 0) {
            constraint = this.getWhereText(stack);
            if (whereText.length() > 0 && constraint.length() > 0) {
                whereText.append(" and ");
            }
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.sql.generator.statement.unexpectedconstraint", (int)op));
        }
        whereText.append(constraint);
    }

    public abstract QueryPlan getQueryPlan();

    protected String getWhereText(List stack) {
        StringBuffer result = new StringBuffer();
        if (stack.size() == 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
        }
        ConstraintNode node = (ConstraintNode)stack.get(stack.size() - 1);
        stack.remove(stack.size() - 1);
        if (node instanceof ConstraintParamIndex) {
            this.processConstraintParamIndex((ConstraintParamIndex)node, result);
        } else if (node instanceof ConstraintValue) {
            this.processConstraintValue((ConstraintValue)node, result);
        } else if (node instanceof ConstraintField) {
            this.processConstraintField((ConstraintField)node, result);
        } else if (node instanceof ConstraintConstant) {
            result.append(((ConstraintConstant)node).value.toString());
        } else if (node instanceof ConstraintOperation) {
            this.processConstraintOperation((ConstraintOperation)node, stack, result);
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalnode", (String)node.getClass().getName()));
        }
        return result.toString();
    }

    protected void processConstraintParamIndex(ConstraintParamIndex node, StringBuffer result) {
        result.append(this.vendorType.getParameterMarker(node.getType()));
        Integer index = node.getIndex();
        this.inputDesc.values.add(new InputParamValue(index, Statement.getColumnElementForValueNode(node)));
    }

    protected void processConstraintValue(ConstraintValue node, StringBuffer result) {
        Object value;
        boolean generateValueInSQLStatement = false;
        String strToAppend = "?";
        if (this.vendorType.isInlineNumeric() && (value = node.getValue()) != null && value instanceof Number) {
            generateValueInSQLStatement = true;
            strToAppend = value.toString();
        }
        result.append(strToAppend);
        if (!generateValueInSQLStatement) {
            this.generateInputValueForConstraintValueNode(node);
        }
    }

    protected QueryPlan getOriginalPlan(ConstraintField fieldNode) {
        return fieldNode.originalPlan != null ? fieldNode.originalPlan : this.getQueryPlan();
    }

    private void processConstraintField(ConstraintField fieldNode, StringBuffer result) {
        LocalFieldDesc desc = null;
        QueryPlan thePlan = this.getOriginalPlan(fieldNode);
        if (fieldNode instanceof ConstraintFieldDesc) {
            desc = ((ConstraintFieldDesc)fieldNode).desc;
        } else if (fieldNode instanceof ConstraintFieldName) {
            desc = thePlan.config.getLocalFieldDesc(((ConstraintFieldName)fieldNode).name);
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.generic.notinstanceof", (String)fieldNode.getClass().getName(), (String)"ConstraintFieldDesc/ConstraintFieldName"));
        }
        this.generateColumnText(desc, thePlan, result);
    }

    protected void generateColumnText(LocalFieldDesc desc, QueryPlan thePlan, StringBuffer sb) {
        QueryTable table = null;
        ColumnElement column = null;
        Iterator iter = desc.getColumnElements();
        while (iter.hasNext() && table == null) {
            column = (ColumnElement)iter.next();
            if (this.action == 4) {
                table = thePlan.findQueryTable(column.getDeclaringTable());
                continue;
            }
            table = this.findQueryTable(column.getDeclaringTable());
        }
        if (table == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.configuration.fieldnotable", (String)desc.getName()));
        }
        if (this.action == 4) {
            sb.append("t").append(table.getTableIndex()).append(".");
        }
        this.appendQuotedText(sb, column.getName().getName());
    }

    protected QueryTable findQueryTable(TableElement tableElement) {
        QueryTable table = null;
        Iterator iter = this.tableList.iterator();
        while (iter.hasNext() && table == null) {
            QueryTable t = (QueryTable)iter.next();
            if (t.getTableDesc().getTableElement() != tableElement) continue;
            table = t;
        }
        return table;
    }

    private void processConstraintOperation(ConstraintOperation opNode, List stack, StringBuffer result) {
        int opCode = opNode.operation;
        int format = this.operationFormat(opCode);
        if ((format & 0x40) == 0) {
            this.processFunctionOrBinaryOperation(format, opCode, stack, result);
        } else {
            this.processIrregularOperation(opNode, opCode, stack, result);
        }
    }

    private void processFunctionOrBinaryOperation(int format, int opCode, List stack, StringBuffer result) {
        if ((format & 1) > 0) {
            result.append(this.prefixOperator(opCode));
        }
        if ((format & 0x300) > 0) {
            if ((format & 8) > 0) {
                result.append("(");
            }
            result.append(this.getWhereText(stack));
            for (int i = 0; i < (format & 0x300) / 256 - 1; ++i) {
                if ((format & 2) > 0) {
                    result.append(this.infixOperator(opCode, i - 1));
                } else {
                    result.append(", ");
                }
                result.append(this.getWhereText(stack));
            }
            if ((format & 8) > 0) {
                result.append(")");
            }
        }
        if ((format & 4) > 0) {
            result.append(this.postfixOperator(opCode));
        }
    }

    protected void processIrregularOperation(ConstraintOperation opNode, int opCode, List stack, StringBuffer result) {
        switch (opCode) {
            case 27: 
            case 28: {
                this.processNullOperation(opCode, stack, result);
                break;
            }
            case 6: {
                if (stack.size() < 3) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
                }
                if (!(stack.get(stack.size() - 1) instanceof ConstraintField)) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.needfieldnode"));
                }
                result.append(this.getWhereText(stack));
                result.append(" between ");
                result.append(this.getWhereText(stack));
                result.append(" and ");
                result.append(this.getWhereText(stack));
                break;
            }
            case 14: 
            case 55: {
                this.processInOperation(opCode, stack, result);
                break;
            }
            case 45: 
            case 46: {
                if (!(opNode instanceof ConstraintSubquery)) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.generic.notinstanceof", (String)opNode.getClass().getName(), (String)"ConstraintSubquery"));
                }
                ConstraintSubquery sqNode = (ConstraintSubquery)opNode;
                result.append(this.prefixOperator(opCode));
                result.append("(");
                Statement sqstmt = (Statement)sqNode.plan.statements.get(0);
                result.append(sqstmt.getText());
                result.append(")");
                break;
            }
            case 48: {
                if (stack.size() < 3) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
                }
                if (this.vendorType.supportsLikeEscape()) {
                    if (!(stack.get(stack.size() - 1) instanceof ConstraintField)) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.needfieldnode"));
                    }
                    result.append(this.getWhereText(stack));
                    result.append(" LIKE ");
                    result.append(this.getWhereText(stack));
                    result.append(this.vendorType.getLeftLikeEscape());
                    result.append(" ESCAPE ");
                    result.append(this.getWhereText(stack));
                    result.append(this.vendorType.getRightLikeEscape());
                    break;
                }
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.sql.generator.statement.likeescapenotsupported"));
            }
            case 49: {
                if (stack.size() < 3) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
                }
                result.append(this.vendorType.getSubstring());
                result.append("(");
                result.append(this.getWhereText(stack));
                result.append(this.vendorType.getSubstringFrom());
                result.append(this.getWhereText(stack));
                result.append(this.vendorType.getSubstringFor());
                result.append(this.getWhereText(stack));
                result.append(")");
                break;
            }
            case 50: {
                if (stack.size() < 2) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
                }
                result.append(this.vendorType.getPosition());
                result.append("(");
                boolean swap = this.vendorType.isPositionSearchSource();
                if (swap) {
                    ConstraintNode expr = (ConstraintNode)stack.remove(stack.size() - 1);
                    ConstraintNode pattern = (ConstraintNode)stack.remove(stack.size() - 1);
                    stack.add(expr);
                    stack.add(pattern);
                }
                result.append(this.getWhereText(stack));
                result.append(this.vendorType.getPositionSep());
                result.append(" ").append(this.getWhereText(stack));
                result.append(")");
                break;
            }
            case 51: {
                if (stack.size() < 3) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
                }
                boolean swapArgs = this.vendorType.isPositionSearchSource();
                boolean threeArgs = this.vendorType.isPositionThreeArgs();
                if (threeArgs) {
                    if (swapArgs) {
                        ConstraintNode expr = (ConstraintNode)stack.remove(stack.size() - 1);
                        ConstraintNode pattern = (ConstraintNode)stack.remove(stack.size() - 1);
                        stack.add(expr);
                        stack.add(pattern);
                    }
                    result.append(this.vendorType.getPosition());
                    result.append("(");
                    result.append(this.getWhereText(stack));
                    result.append(this.vendorType.getPositionSep());
                    result.append(" ").append(this.getWhereText(stack));
                    result.append(this.vendorType.getPositionSep());
                    result.append(" ").append(this.getWhereText(stack));
                    result.append(")");
                    break;
                }
                ConstraintValue valueNode = (ConstraintValue)stack.remove(stack.size() - 3);
                if (valueNode != null && ONE.equals(valueNode.getValue())) {
                    stack.add(new ConstraintOperation(50));
                    result.append(this.getWhereText(stack));
                    break;
                }
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.sql.generator.statement.positionthreeargsnotsupported"));
            }
            case 54: {
                this.processMaybeNullOperation(stack, result);
                break;
            }
            case 57: {
                if (stack.size() < 2) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
                }
                result.append(this.prefixOperator(opCode));
                result.append("(");
                result.append(this.getWhereText(stack));
                result.append(", ");
                result.append(this.getWhereText(stack));
                result.append(")");
                break;
            }
            case 44: {
                this.processConcatOperation(opCode, stack, result);
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)("" + opCode)));
            }
        }
    }

    private void processConcatOperation(int opCode, List stack, StringBuffer result) {
        if (stack.size() < 2) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
        }
        String concatCast = this.vendorType.getConcatCast();
        if (concatCast.length() != 0) {
            result.append(concatCast);
            result.append("( ");
        }
        result.append("( ");
        result.append(this.getWhereText(stack));
        result.append(this.infixOperator(opCode, 0));
        result.append(this.getWhereText(stack));
        result.append(" ) ");
        if (concatCast.length() != 0) {
            result.append(" ) ");
        }
    }

    private void processMaybeNullOperation(List stack, StringBuffer result) {
        ConstraintValue valueNode = null;
        ConstraintField fieldNode = null;
        if (stack.size() < 2) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
        }
        if (!(stack.get(stack.size() - 1) instanceof ConstraintField)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.needfieldnode"));
        }
        fieldNode = (ConstraintField)stack.get(stack.size() - 1);
        stack.remove(stack.size() - 1);
        if (!(stack.get(stack.size() - 1) instanceof ConstraintValue)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.needvalnode"));
        }
        valueNode = (ConstraintValue)stack.get(stack.size() - 1);
        stack.remove(stack.size() - 1);
        Object value = valueNode.getValue();
        if (value instanceof String) {
            String v = (String)value;
            if (v.length() == 0) {
                stack.add(fieldNode);
                stack.add(new ConstraintOperation(28));
            } else {
                stack.add(valueNode);
                stack.add(fieldNode);
                stack.add(new ConstraintOperation(9));
            }
        } else {
            stack.add(valueNode);
            stack.add(fieldNode);
            stack.add(new ConstraintOperation(9));
            boolean maybeNull = false;
            if (value instanceof Number && ((Number)value).doubleValue() == 0.0) {
                maybeNull = true;
            } else if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                maybeNull = true;
            } else if (value instanceof Character && ((Character)value).charValue() == '\u0000') {
                maybeNull = true;
            }
            if (maybeNull) {
                stack.add(fieldNode);
                stack.add(new ConstraintOperation(28));
                stack.add(new ConstraintOperation(29));
            }
        }
        if (stack.size() > 0) {
            result.append(this.getWhereText(stack));
        }
    }

    private void processNullOperation(int opCode, List stack, StringBuffer result) {
        String nullComparisionFunctionName = this.vendorType.getNullComparisonFunctionName();
        if (nullComparisionFunctionName.length() != 0) {
            Object nextNode = stack.get(stack.size() - 1);
            if (nextNode != null) {
                if (nextNode instanceof ConstraintFieldName) {
                    LocalFieldDesc desc;
                    ConstraintFieldName fieldNode = (ConstraintFieldName)nextNode;
                    QueryPlan originalPlan = this.getQueryPlan();
                    if (fieldNode.originalPlan != null) {
                        originalPlan = fieldNode.originalPlan;
                    }
                    if ((desc = (LocalFieldDesc)originalPlan.config.getField(fieldNode.name)).isMappedToLob()) {
                        stack.add(new ConstraintOperation(56));
                    }
                }
            } else {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
            }
        }
        result.append(this.getWhereText(stack));
        String str = opCode == 28 ? this.vendorType.getIsNull() : this.vendorType.getIsNotNull();
        result.append(str);
    }

    private void processInOperation(int opCode, List stack, StringBuffer result) {
        StringBuffer c = new StringBuffer();
        if (stack.size() < 2) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.stackempty"));
        }
        result.append("(");
        if (!(stack.get(stack.size() - 1) instanceof ConstraintField)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.needfieldnode"));
        }
        c.append(this.getWhereText(stack));
        while (stack.size() > 1 && stack.get(stack.size() - 1) instanceof ConstraintField) {
            c.replace(0, 0, ", ");
            c.replace(0, 0, this.getWhereText(stack));
        }
        result.append(c.toString());
        result.append(") ");
        if (opCode == 55) {
            result.append("not ");
        }
        result.append("in (");
        ConstraintNode currentNode = (ConstraintNode)stack.remove(stack.size() - 1);
        if (!(currentNode instanceof ConstraintSubquery)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.generic.notinstanceof", (String)currentNode.getClass().getName(), (String)"ConstraintSubquery"));
        }
        ConstraintSubquery sqnode = (ConstraintSubquery)currentNode;
        Statement sqstmt = (Statement)sqnode.plan.statements.get(0);
        result.append(sqstmt.getText());
        result.append(")");
        this.inputDesc.values.addAll(sqstmt.inputDesc.values);
    }

    private static ColumnElement getColumnElementForValueNode(ConstraintValue node) {
        ColumnElement columnElement = null;
        LocalFieldDesc field = node.getLocalField();
        if (field != null) {
            columnElement = field.getPrimaryColumn();
        }
        return columnElement;
    }

    protected void generateInputValueForConstraintValueNode(ConstraintValue node) {
        this.inputDesc.values.add(new InputValue(node.getValue(), Statement.getColumnElementForValueNode(node)));
    }

    protected String infixOperator(int operation, int position) {
        StringBuffer result = new StringBuffer();
        switch (operation) {
            case 2: {
                result.append(" + ");
                break;
            }
            case 3: {
                result.append(" and ");
                break;
            }
            case 8: {
                result.append(" / ");
                break;
            }
            case 9: {
                result.append(" = ");
                break;
            }
            case 12: {
                result.append(" >= ");
                break;
            }
            case 13: {
                result.append(" > ");
                break;
            }
            case 15: {
                result.append(" <= ");
                break;
            }
            case 21: {
                result.append(" < ");
                break;
            }
            case 25: {
                result.append(" != ");
                break;
            }
            case 29: {
                result.append(" or ");
                break;
            }
            case 19: {
                result.append(" like ");
                break;
            }
            case 24: {
                result.append(" * ");
                break;
            }
            case 36: {
                result.append(" - ");
                break;
            }
            case 57: {
                result.append(" % ");
                break;
            }
            case 6: {
                if (position == 1) {
                    result.append(" between ");
                    break;
                }
                result.append(" and ");
                break;
            }
            case 44: {
                result.append(this.vendorType.getStringConcat());
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)("" + operation)));
            }
        }
        return result.toString();
    }

    protected int operationFormat(int operation) {
        int format = 0;
        switch (operation) {
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                format = 546;
                break;
            }
            case 2: 
            case 8: 
            case 29: 
            case 36: {
                format = 554;
                break;
            }
            case 1: 
            case 17: 
            case 22: 
            case 26: 
            case 47: 
            case 56: {
                format = 297;
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 27: 
            case 28: 
            case 44: 
            case 48: 
            case 54: 
            case 55: {
                format = 96;
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                format = 64;
                break;
            }
            case 45: 
            case 46: {
                format = 97;
                break;
            }
            case 57: {
                format = this.vendorType.isModOperationUsingFunction() ? 64 : 554;
                break;
            }
            case 7: {
                format = 128;
                break;
            }
            case 30: 
            case 31: {
                format = 16;
                break;
            }
            case 34: 
            case 43: {
                if (this.vendorType.isAnsiTrim()) {
                    format = 293;
                    break;
                }
                format = 297;
                break;
            }
            case 16: {
                format = 98;
                format |= 4;
                break;
            }
            case 33: {
                format = 98;
                format |= 1;
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)("" + operation)));
            }
        }
        return format;
    }

    protected String postfixOperator(int operation) {
        StringBuffer result = new StringBuffer();
        switch (operation) {
            case 34: {
                result.append(this.vendorType.getRtrimPost());
                break;
            }
            case 43: {
                result.append(this.postfixOperator(34));
                break;
            }
            case 16: {
                result.append(this.vendorType.getLeftJoinPost());
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)("" + operation)));
            }
        }
        return result.toString();
    }

    protected String prefixOperator(int operation) {
        StringBuffer result = new StringBuffer();
        switch (operation) {
            case 1: {
                result.append(this.vendorType.getAbs());
                break;
            }
            case 17: {
                result.append(this.vendorType.getCharLength());
                break;
            }
            case 34: {
                result.append(this.vendorType.getRtrim());
                break;
            }
            case 43: {
                result.append(this.prefixOperator(34));
                break;
            }
            case 26: {
                result.append("not ");
                break;
            }
            case 47: {
                result.append(this.vendorType.getSqrt());
                break;
            }
            case 45: {
                result.append("not exists ");
                break;
            }
            case 46: {
                result.append("exists ");
                break;
            }
            case 56: {
                result.append(this.vendorType.getNullComparisonFunctionName());
                break;
            }
            case 57: {
                result.append(this.vendorType.getModFunctionName());
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)("" + operation)));
            }
        }
        return result.toString();
    }

    public void addSecondaryTableStatement(Statement s) {
        if (s == null) {
            return;
        }
        if (this.secondaryTableStatements == null) {
            this.secondaryTableStatements = new ArrayList();
        }
        this.secondaryTableStatements.add(s);
    }

    public ArrayList getSecondaryTableStatements() {
        return this.secondaryTableStatements;
    }

    public ArrayList getQueryTables() {
        return this.tableList;
    }

    public ArrayList getColumnRefs() {
        return this.columns;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void bindInputValues(DBStatement s) throws SQLException {
        int size = this.inputDesc.values.size();
        for (int i = 0; i < size; ++i) {
            InputValue inputVal = (InputValue)this.inputDesc.values.get(i);
            s.bindInputColumn(i + 1, inputVal.getValue(), inputVal.getColumnElement(), this.vendorType);
        }
    }

    private Object[] getInputValues() {
        int size = this.inputDesc.values.size();
        Object[] inputValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            InputValue inputValue = (InputValue)this.inputDesc.values.get(i);
            inputValues[i] = inputValue.getValue();
        }
        return inputValues;
    }

    public String getFormattedSQLText() {
        return Statement.formatSqlText(this.getText(), this.getInputValues());
    }

    protected static String formatSqlText(String sqlText, Object[] input) {
        StringBuffer str = new StringBuffer();
        str.append(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.sql.generator.statement.sqlStatement"));
        str.append("<").append(sqlText).append("> ");
        if (input != null && input.length > 0) {
            str.append(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.sql.generator.statement.withinputvalues"));
            for (int i = 0; i < input.length; ++i) {
                Object inputValue;
                if (i > 0) {
                    str.append(", ");
                }
                if ((inputValue = input[i]) == null) {
                    str.append("<null>");
                    continue;
                }
                str.append(inputValue.getClass().getName());
                str.append(":");
                str.append(inputValue.toString());
            }
        } else {
            str.append(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.sql.generator.statement.withnoinputvalues"));
        }
        return str.toString();
    }
}

