/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.builtin.EventBean;
import org.jboss.weld.bean.builtin.InstanceBean;
import org.jboss.weld.resolution.NewResolvableTransformer;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableTransformer;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeBeanResolver<T extends Bean<?>>
extends TypeSafeResolver<Resolvable, T> {
    public static final Set<ResolvableTransformer> TRANSFORMERS = new HashSet<ResolvableTransformer>();
    private final BeanManagerImpl manager;
    private final ConcurrentCache<Set<?>, Set<Bean<?>>> disambiguatedBeans;

    public TypeSafeBeanResolver(BeanManagerImpl manager, Iterable<T> beans) {
        super(beans);
        this.manager = manager;
        this.disambiguatedBeans = new ConcurrentCache();
    }

    @Override
    protected boolean matches(Resolvable resolvable, T bean) {
        return Reflections.matches(resolvable.getTypeClosure(), bean.getTypes()) && Beans.containsAllBindings(resolvable.getQualifiers(), bean.getQualifiers(), this.manager);
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }

    @Override
    protected Set<T> filterResult(Set<T> matched) {
        return Beans.retainEnabledPolicies(matched, this.manager.getEnabledPolicyClasses(), this.manager.getEnabledPolicyStereotypes());
    }

    @Override
    protected Iterable<ResolvableTransformer> getTransformers() {
        return TRANSFORMERS;
    }

    @Override
    protected Set<T> sortResult(Set<T> matched) {
        return matched;
    }

    public <X> Set<Bean<? extends X>> resolve(final Set<Bean<? extends X>> beans) {
        return (Set)this.disambiguatedBeans.putIfAbsent(beans, new Callable<Set<Bean<? extends X>>>(){

            @Override
            public Set<Bean<? extends X>> call() throws Exception {
                HashSet<Bean> disambiguatedBeans = beans;
                if (disambiguatedBeans.size() > 1) {
                    boolean policyPresent = Beans.isPolicyPresent(disambiguatedBeans);
                    disambiguatedBeans = new HashSet<Bean>();
                    for (Bean bean : beans) {
                        if (!(policyPresent ? bean.isAlternative() : !Beans.isSpecialized(bean, beans, TypeSafeBeanResolver.this.manager.getSpecializedBeans()))) continue;
                        disambiguatedBeans.add(bean);
                    }
                }
                return disambiguatedBeans;
            }
        });
    }

    public <X> Set<Bean<? extends X>> resolve(Collection<Bean<? extends X>> beans) {
        return this.resolve((Set<Bean<? extends X>>)new HashSet<Bean<? extends X>>(beans));
    }

    static {
        TRANSFORMERS.add(EventBean.TRANSFORMER);
        TRANSFORMERS.add(InstanceBean.INSTANCE_TRANSFORMER);
        TRANSFORMERS.add(InstanceBean.PROVIDER_TRANSFORMER);
        TRANSFORMERS.add(new NewResolvableTransformer());
    }
}

