/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.Interceptor;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private final Set<WeldClass<?>> classes = new HashSet();

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors) {
        super(manager, new BeanDeployerEnvironment(ejbDescriptors, manager));
    }

    public BeanDeployer addClass(Class<?> clazz) {
        ProcessAnnotatedTypeImpl<?> event;
        ClassTransformer classTransformer = Container.instance().deploymentServices().get(ClassTransformer.class);
        if (!(clazz.isAnnotation() || clazz.isEnum() || (event = ProcessAnnotatedTypeImpl.fire(this.getManager(), classTransformer.loadClass(clazz))).isVeto())) {
            if (event.getAnnotatedType() instanceof WeldClass) {
                this.classes.add((WeldClass)event.getAnnotatedType());
            } else {
                this.classes.add(classTransformer.loadClass(event.getAnnotatedType()));
            }
        }
        return this;
    }

    public BeanDeployer addClass(AnnotatedType<?> clazz) {
        ClassTransformer classTransformer = Container.instance().deploymentServices().get(ClassTransformer.class);
        this.classes.add(classTransformer.loadClass(clazz));
        return this;
    }

    public BeanDeployer addClasses(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
        return this;
    }

    public BeanDeployer createBeans() {
        for (WeldClass<?> weldClass : this.classes) {
            boolean managedBeanOrDecorator;
            boolean bl = managedBeanOrDecorator = !((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors().contains(weldClass.getJavaClass()) && this.isTypeManagedBeanOrDecoratorOrInterceptor(weldClass);
            if (managedBeanOrDecorator && weldClass.isAnnotationPresent(Decorator.class)) {
                this.validateDecorator(weldClass);
                this.createDecorator(weldClass);
                continue;
            }
            if (managedBeanOrDecorator && weldClass.isAnnotationPresent(Interceptor.class)) {
                this.validateInterceptor(weldClass);
                this.createInterceptor(weldClass);
                continue;
            }
            if (!managedBeanOrDecorator || weldClass.isAbstract()) continue;
            this.createManagedBean(weldClass);
        }
        for (InternalEjbDescriptor internalEjbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            this.createSessionBean(internalEjbDescriptor);
        }
        for (WeldClass weldClass : ((BeanDeployerEnvironment)this.getEnvironment()).getNewManagedBeanClasses()) {
            this.createNewManagedBean(weldClass);
        }
        for (InternalEjbDescriptor internalEjbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getNewSessionBeanDescriptors()) {
            this.createNewSessionBean(internalEjbDescriptor);
        }
        return this;
    }

    private void validateInterceptor(WeldClass<?> clazz) {
        if (clazz.isAnnotationPresent(Decorator.class)) {
            throw new DeploymentException("Class " + clazz.getName() + " has both @Interceptor and @Decorator annotations");
        }
    }

    private void validateDecorator(WeldClass<?> clazz) {
        if (clazz.isAnnotationPresent(Interceptor.class)) {
            throw new DeploymentException("Class " + clazz.getName() + " has both @Interceptor and @Decorator annotations");
        }
    }
}

