/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bean.proxy.EnterpriseBeanInstance;
import org.jboss.weld.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBean<T>
extends AbstractClassBean<T> {
    private InternalEjbDescriptor<T> ejbDescriptor;
    private Class<T> proxyClass;
    private SessionBean<?> specializedBean;

    public static <T> SessionBean<T> of(InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl manager) {
        WeldClass type = manager.getServices().get(ClassTransformer.class).loadClass(ejbDescriptor.getBeanClass());
        return new SessionBean(type, ejbDescriptor, SessionBean.createId(SessionBean.class.getSimpleName(), ejbDescriptor), manager);
    }

    protected static String createId(String beanType, InternalEjbDescriptor<?> ejbDescriptor) {
        return beanType + "-" + ejbDescriptor.getEjbName();
    }

    protected SessionBean(WeldClass<T> type, InternalEjbDescriptor<T> ejbDescriptor, String idSuffix, BeanManagerImpl manager) {
        super(type, idSuffix, manager);
        this.initType();
        this.ejbDescriptor = ejbDescriptor;
        this.initTypes();
        this.initBindings();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initProxyClass();
            this.checkEJBTypeAllowed();
            this.checkConflictingRoles();
            this.checkObserverMethods();
            this.checkScopeAllowed();
            this.registerInterceptors();
            this.setInjectionTarget(new InjectionTarget<T>(){

                @Override
                public void inject(final T instance, final CreationalContext<T> ctx) {
                    new InjectionContextImpl<T>(SessionBean.this.getManager(), this, instance){

                        @Override
                        public void proceed() {
                            Beans.injectFieldsAndInitializers(instance, ctx, SessionBean.this.getManager(), SessionBean.this.getInjectableFields(), SessionBean.this.getInitializerMethods());
                        }
                    }.run();
                }

                @Override
                public void postConstruct(T instance) {
                    SessionBean.this.defaultPostConstruct(instance);
                }

                @Override
                public void preDestroy(T instance) {
                    SessionBean.this.defaultPreDestroy(instance);
                }

                @Override
                public void dispose(T instance) {
                }

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return SessionBean.this.getAnnotatedInjectionPoints();
                }

                @Override
                public T produce(CreationalContext<T> ctx) {
                    try {
                        Object instance = SessionBean.this.proxyClass.newInstance();
                        ctx.push(instance);
                        return Proxies.attachMethodHandler(instance, new EnterpriseBeanProxyMethodHandler(SessionBean.this, ctx));
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("Could not instantiate enterprise proxy for " + this.toString(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Could not access bean correctly when creating enterprise proxy for " + this.toString(), e);
                    }
                    catch (Exception e) {
                        throw new CreationException("could not find the EJB in JNDI " + SessionBean.this.proxyClass, e);
                    }
                }
            });
        }
    }

    @Override
    protected void initTypes() {
        LinkedHashMap types = new LinkedHashMap();
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
            types.put(businessInterfaceDescriptor.getInterface(), businessInterfaceDescriptor.getInterface());
        }
        if (this.getAnnotatedItem().isAnnotationPresent(Typed.class)) {
            this.types = SessionBean.getTypedTypes(types, this.getAnnotatedItem().getJavaClass(), this.getAnnotatedItem().getAnnotation(Typed.class));
        } else {
            types.put(Object.class, (Type)((Object)Object.class));
            this.types = new HashSet(types.values());
        }
    }

    protected void initProxyClass() {
        this.proxyClass = Proxies.createProxyClass(Proxies.TypeInfo.of(this.getTypes()).add((Type)((Object)EnterpriseBeanInstance.class)).add((Type)((Object)Serializable.class)));
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(javax.interceptor.Interceptor.class)) {
            throw new DefinitionException("Enterprise beans cannot be interceptors");
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw new DefinitionException("Enterprise beans cannot be decorators");
        }
    }

    protected void checkScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.isDependent()) {
            throw new DefinitionException("Scope " + this.getScope() + " is not allowed on stateless enterprise beans for " + this.getType() + ". Only @Dependent is allowed on stateless enterprise beans");
        }
        if (this.ejbDescriptor.isSingleton() && !this.isDependent() && !this.getScope().equals(ApplicationScoped.class)) {
            throw new DefinitionException("Scope " + this.getScope() + " is not allowed on singleton enterprise beans for " + this.getType() + ". Only @Dependent or @ApplicationScoped is allowed on singleton enterprise beans");
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (!environment.getEjbDescriptors().contains(this.getAnnotatedItem().getWeldSuperclass().getJavaClass())) {
            throw new DefinitionException("Annotation defined specializing EJB must have EJB superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        if (environment.getClassBean(this.getAnnotatedItem().getWeldSuperclass()) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        AbstractClassBean<?> specializedBean = environment.getClassBean(this.getAnnotatedItem().getWeldSuperclass());
        if (!(specializedBean instanceof SessionBean)) {
            throw new IllegalStateException(this.toString() + " doesn't have a session bean as a superclass " + specializedBean);
        }
        this.specializedBean = (SessionBean)specializedBean;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.getInjectionTarget().produce(creationalContext);
        if (this.hasDecorators()) {
            instance = this.applyDecorators(instance, creationalContext, null);
        }
        return instance;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (instance == null) {
            throw new IllegalArgumentException("instance to destroy cannot be null");
        }
        if (!(instance instanceof EnterpriseBeanInstance)) {
            throw new IllegalArgumentException("Cannot destroy session bean instance not created by the container");
        }
        EnterpriseBeanInstance enterpriseBeanInstance = (EnterpriseBeanInstance)instance;
        enterpriseBeanInstance.destroy(Marker.INSTANCE, this, creationalContext);
        creationalContext.release();
    }

    private void checkEJBTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw new DefinitionException("Message Driven Beans can't be Managed Beans");
        }
    }

    @Override
    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        if (this.getName() == null) {
            buffer.append(" unnamed enterprise bean");
        } else {
            buffer.append(" enterprise bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "] ");
        buffer.append("API types " + this.getTypes() + ", binding types " + this.getQualifiers());
        return buffer.toString();
    }

    @Override
    public boolean isPassivationCapable() {
        return this.getEjbDescriptor().isStateful();
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isClientCanCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    protected void checkObserverMethods() {
        for (WeldMethod method : this.annotatedItem.getDeclaredWeldMethodsWithAnnotatedParameters(Observes.class)) {
            if (method.isStatic() || this.isMethodExistsOnTypes(method)) continue;
            throw new DefinitionException("Observer method must be static or business method: " + method + " on " + this.getAnnotatedItem());
        }
    }

    public boolean isMethodExistsOnTypes(WeldMethod<?, ?> method) {
        for (Type type : this.getTypes()) {
            if (!(type instanceof Class)) continue;
            for (Method m : ((Class)type).getMethods()) {
                if (!method.getName().equals(m.getName()) || !Arrays.equals(method.getParameterTypesAsArray(), m.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public SessionObjectReference createReference() {
        return this.manager.getServices().get(EjbServices.class).resolveEjb(this.getEjbDescriptor().delegate());
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return true;
    }

    protected void registerInterceptors() {
        InterceptionModel<Class<?>, SerializableContextual<Interceptor<?>, ?>> model = this.manager.getCdiInterceptorsRegistry().getInterceptionModel(this.ejbDescriptor.getBeanClass());
        if (model != null) {
            this.getManager().getServices().get(EjbServices.class).registerInterceptors(this.getEjbDescriptor().delegate(), new InterceptorBindingsAdapter(model));
        }
    }
}

