/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptorClassMetadata;
import org.jboss.interceptor.proxy.DirectClassInterceptionHandler;
import org.jboss.interceptor.registry.InterceptorClassMetadataRegistry;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorImpl<T>
extends ManagedBean<T>
implements Interceptor<T> {
    private final InterceptorClassMetadata interceptorClassMetadata;
    private final Set<Annotation> interceptorBindingTypes;

    protected InterceptorImpl(WeldClass<T> type, BeanManagerImpl manager) {
        super(type, Interceptor.class.getSimpleName() + "-" + type.getName(), manager);
        this.interceptorClassMetadata = InterceptorClassMetadataRegistry.getRegistry().getInterceptorClassMetadata(type.getJavaClass());
        this.interceptorBindingTypes = new HashSet<Annotation>();
        this.interceptorBindingTypes.addAll(InterceptorImpl.flattenInterceptorBindings(manager, this.getAnnotatedItem().getAnnotations()));
        for (Class<Annotation> annotation : this.getStereotypes()) {
            this.interceptorBindingTypes.addAll(InterceptorImpl.flattenInterceptorBindings(manager, manager.getStereotypeDefinition(annotation)));
        }
        if (this.interceptorBindingTypes.size() == 0) {
            throw new DeploymentException(BeanMessage.MISSING_BINDING_ON_INTERCEPTOR, type.getName());
        }
        if (Beans.findInterceptorBindingConflicts(manager, this.interceptorBindingTypes)) {
            throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType());
        }
    }

    public static <T> InterceptorImpl<T> of(WeldClass<T> type, BeanManagerImpl manager) {
        return new InterceptorImpl<T>(type, manager);
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindingTypes;
    }

    @Override
    public Object intercept(javax.enterprise.inject.spi.InterceptionType type, T instance, InvocationContext ctx) {
        try {
            return new DirectClassInterceptionHandler(instance, this.getType()).invoke(ctx.getTarget(), InterceptionType.valueOf(type.name()), ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean intercepts(javax.enterprise.inject.spi.InterceptionType type) {
        return this.interceptorClassMetadata.getInterceptorMethods(InterceptionType.valueOf(type.name())).size() > 0;
    }

    @Override
    protected void defaultPostConstruct(T instance) {
    }

    @Override
    protected void defaultPreDestroy(T instance) {
    }
}

