/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.coyote;

import com.sun.appserv.ProxyHandler;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.connector.coyote.PECoyoteResponse;
import com.sun.enterprise.web.connector.extension.GrizzlyConfig;
import com.sun.enterprise.web.connector.grizzly.DummyConnectorLauncher;
import com.sun.enterprise.web.pwc.connector.coyote.PwcCoyoteRequest;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.MapperListener;
import org.glassfish.security.common.CipherInfo;
import org.glassfish.web.admin.monitor.RequestProbeProvider;

public class PECoyoteConnector
extends org.apache.catalina.connector.Connector {
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    private static final String DUMMY_CONNECTOR_LAUNCHER = DummyConnectorLauncher.class.getName();
    protected static final Logger _logger = LogDomains.getLogger(PECoyoteConnector.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    protected boolean recycleObjects;
    protected int maxAcceptWorkerThreads;
    protected int maxReadWorkerThreads;
    protected int processorWorkerThreadsTimeout;
    protected int minProcessorWorkerThreadsIncrement;
    protected int minAcceptQueueLength;
    protected int minReadQueueLength;
    protected int minProcessorQueueLength;
    protected boolean useDirectByteBuffer;
    private boolean coyoteOn = false;
    private int keepAliveTimeoutInSeconds;
    private int keepAliveThreadCount;
    private boolean chunkingDisabled;
    private int queueSizeInBytes = 4096;
    protected int ssBackLog = 4096;
    public int selectorReadThreadsCount = 0;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected GrizzlyConfig grizzlyMonitor;
    private String rootFolder = "";
    private int secondsMaxAge = -1;
    private int maxCacheEntries = 1024;
    private long minEntrySize = 2048L;
    private long maxEntrySize = 537600L;
    private long maxLargeFileCacheSize = 0xA00000L;
    private long maxSmallFileCacheSize = 0x100000L;
    private boolean fileCacheEnabled = true;
    private boolean isLargeFileCacheEnabled = true;
    private String crlFile;
    private String trustAlgorithm;
    private String trustMaxCertLength;
    private WebContainer webContainer;
    private RequestProbeProvider requestProbeProvider;

    public PECoyoteConnector(WebContainer webContainer) {
        this.webContainer = webContainer;
        this.requestProbeProvider = webContainer.getRequestProbeProvider();
        this.setProtocolHandlerClassName(DUMMY_CONNECTOR_LAUNCHER);
    }

    public void setChunkingDisabled(boolean chunkingDisabled) {
        this.chunkingDisabled = chunkingDisabled;
    }

    public boolean isChunkingDisabled() {
        return this.chunkingDisabled;
    }

    public Request createRequest() {
        PwcCoyoteRequest request = new PwcCoyoteRequest();
        request.setConnector((Connector)this);
        return request;
    }

    public Response createResponse() {
        PECoyoteResponse response = new PECoyoteResponse(this.isChunkingDisabled());
        response.setConnector((Connector)this);
        return response;
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        this.setProperty("keepAliveTimeoutInSeconds", String.valueOf(timeout));
    }

    public int getKeepAliveThreadCount() {
        return this.keepAliveThreadCount;
    }

    public void setQueueSizeInBytes(int queueSizeInBytes) {
        this.queueSizeInBytes = queueSizeInBytes;
        this.setProperty("queueSizeInBytes", queueSizeInBytes);
    }

    public int getQueueSizeInBytes() {
        return this.queueSizeInBytes;
    }

    public void setSocketServerBacklog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
        this.setProperty("socketServerBacklog", ssBackLog);
    }

    public int getSocketServerBacklog() {
        return this.ssBackLog;
    }

    public void setRecycleObjects(boolean recycleObjects) {
        this.recycleObjects = recycleObjects;
        this.setProperty("recycleObjects", String.valueOf(recycleObjects));
    }

    public boolean getRecycleObjects() {
        return this.recycleObjects;
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.maxReadWorkerThreads = maxReadWorkerThreads;
        this.setProperty("maxReadWorkerThreads", String.valueOf(maxReadWorkerThreads));
    }

    public int getMaxReadWorkerThreads() {
        return this.maxReadWorkerThreads;
    }

    public void setMaxAcceptWorkerThreads(int maxAcceptWorkerThreads) {
        this.maxAcceptWorkerThreads = maxAcceptWorkerThreads;
        this.setProperty("maxAcceptWorkerThreads", String.valueOf(maxAcceptWorkerThreads));
    }

    public int getMaxAcceptWorkerThreads() {
        return this.maxAcceptWorkerThreads;
    }

    public void setMinAcceptQueueLength(int minAcceptQueueLength) {
        this.minAcceptQueueLength = minAcceptQueueLength;
        this.setProperty("minAcceptQueueLength", String.valueOf(minAcceptQueueLength));
    }

    public int getMinAcceptQueueLength() {
        return this.minAcceptQueueLength;
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.minReadQueueLength = minReadQueueLength;
        this.setProperty("minReadQueueLength", String.valueOf(minReadQueueLength));
    }

    public int getMinReadQueueLength() {
        return this.minReadQueueLength;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.minProcessorQueueLength = minProcessorQueueLength;
        this.setProperty("minProcessorQueueLength", String.valueOf(minProcessorQueueLength));
    }

    public int getMinProcessorQueueLength() {
        return this.minProcessorQueueLength;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.setProperty("useDirectByteBuffer", String.valueOf(useDirectByteBuffer));
    }

    public boolean getUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.processorWorkerThreadsTimeout = timeout;
        this.setProperty("processorWorkerThreadsTimeout", String.valueOf(timeout));
    }

    public int getProcessorWorkerThreadsTimeout() {
        return this.processorWorkerThreadsTimeout;
    }

    public int getMinProcessorWorkerThreadsIncrement() {
        return this.minProcessorWorkerThreadsIncrement;
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.setProperty("selectorReadThreadsCount", String.valueOf(selectorReadThreadsCount));
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
        this.setProperty("defaultResponseType", defaultResponseType);
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setForcedRequestType(String forcedResponseType) {
        this.forcedRequestType = forcedResponseType;
        this.setProperty("forcedRequestType", forcedResponseType);
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.initConfig();
            this.grizzlyMonitor.registerMonitoringLevelEvents();
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.destroy();
            this.grizzlyMonitor = null;
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
        this.setProperty("secondsMaxAge", String.valueOf(this.secondsMaxAge));
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
        this.setProperty("maxCacheEntries", String.valueOf(this.maxCacheEntries));
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
        this.setProperty("minEntrySize", String.valueOf(this.minEntrySize));
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
        this.setProperty("maxEntrySize", String.valueOf(this.maxEntrySize));
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
        this.setProperty("maxLargeFileCacheSize", String.valueOf(this.maxLargeFileCacheSize));
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
        this.setProperty("maxSmallFileCacheSize", String.valueOf(this.maxSmallFileCacheSize));
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.fileCacheEnabled;
    }

    public void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.fileCacheEnabled = fileCacheEnabled;
        this.setProperty("fileCacheEnabled", String.valueOf(fileCacheEnabled));
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
        this.setProperty("largeFileCacheEnabled", String.valueOf(this.isLargeFileCacheEnabled));
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setWebAppRootPath(String rootFolder) {
        this.rootFolder = rootFolder;
        this.setProperty("webAppRootPath", rootFolder);
    }

    public String getWebAppRootPath() {
        return this.rootFolder;
    }

    public void initialize() throws LifecycleException {
        super.initialize();
        this.grizzlyMonitor = new GrizzlyConfig(this.webContainer, this.domain, this.getPort());
    }

    public void setTruststore(String truststore) {
        this.setProperty("truststore", truststore);
    }

    public String getTruststore() {
        return (String)this.getProperty("truststore");
    }

    public void setTruststoreType(String type) {
        this.setProperty("truststoreType", type);
    }

    public String getTruststoreType() {
        return (String)this.getProperty("truststoreType");
    }

    public void setKeystoreType(String type) {
        this.setProperty("keystoreType", type);
    }

    public String getKeystoreType() {
        return (String)this.getProperty("keystoreType");
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
        this.setProperty("crlFile", crlFile);
    }

    public String getTrustAlgorithm() {
        return this.trustAlgorithm;
    }

    public void setTrustAlgorithm(String trustAlgorithm) {
        this.trustAlgorithm = trustAlgorithm;
        this.setProperty("truststoreAlgorithm", trustAlgorithm);
    }

    public String getTrustMaxCertLength() {
        return this.trustMaxCertLength;
    }

    public void setTrustMaxCertLength(String trustMaxCertLength) {
        this.trustMaxCertLength = trustMaxCertLength;
        this.setProperty("trustMaxCertLength", trustMaxCertLength);
    }

    public MapperListener getMapperListener() {
        return this.mapperListener;
    }

    public void configure(NetworkListener listener, boolean isSecure, HttpService httpService) {
        String redirectPort;
        Transport transport = listener.findTransport();
        try {
            this.setSocketServerBacklog(Integer.parseInt(transport.getMaxConnectionsCount()));
        }
        catch (NumberFormatException ex) {
            String msg = _rb.getString("pewebcontainer.invalidMaxPendingCount");
            msg = MessageFormat.format(msg, transport.getMaxConnectionsCount(), Integer.toString(this.getSocketServerBacklog()));
            _logger.log(Level.WARNING, msg, ex);
        }
        this.setDomain(this.webContainer.getServerContext().getDefaultDomainName());
        this.configureSSL(listener);
        this.configureThreadPool(listener.findThreadPool());
        Http http = listener.findHttpProtocol().getHttp();
        this.configureFileCache(http.getFileCache());
        this.setMaxHttpHeaderSize(Integer.parseInt(http.getSendBufferSizeBytes()));
        this.setDefaultHost(http.getDefaultVirtualServer());
        this.setDefaultResponseType(http.getDefaultResponseType());
        this.setForcedRequestType(http.getForcedResponseType());
        this.setEnableLookups(ConfigBeansUtilities.toBoolean((String)http.getDnsLookupEnabled()));
        this.setXpoweredBy(Boolean.valueOf(http.getXpoweredBy()));
        this.setWebAppRootPath(this.webContainer.getModulesRoot().getAbsolutePath());
        String serverName = http.getServerName();
        if (serverName != null && serverName.length() > 0) {
            if (serverName.startsWith("http://")) {
                serverName = serverName.substring("http://".length());
            } else if (serverName.startsWith("https://")) {
                serverName = serverName.substring("https://".length());
            }
            int index = serverName.indexOf(58);
            if (index != -1) {
                this.setProxyName(serverName.substring(0, index).trim());
                String serverPort = serverName.substring(index + 1).trim();
                if (serverPort.length() > 0) {
                    try {
                        this.setProxyPort(Integer.parseInt(serverPort));
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.SEVERE, "pewebcontainer.invalid_proxy_port", new Object[]{serverPort, listener.getName()});
                    }
                }
            } else {
                this.setProxyName(serverName);
            }
        }
        if ((redirectPort = http.getRedirectPort()) != null && redirectPort.length() != 0) {
            try {
                this.setRedirectPort(Integer.parseInt(redirectPort));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_redirect_port", new Object[]{redirectPort, listener.getName(), Integer.toString(this.getRedirectPort())});
            }
        } else {
            this.setRedirectPort(-1);
        }
        String acceptorThreads = transport.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                this.setSelectorReadThreadsCount(Integer.parseInt(acceptorThreads));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, listener.getName(), Integer.toString(this.getMaxProcessors())});
            }
        }
        if (isSecure) {
            this.configureKeysAndCerts();
        }
        this.webContainer.configureHttpServiceProperties(httpService, this);
        this.configureHttpListenerProperties(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureJKProperties() {
        File propertiesFile;
        String propertiesURL = System.getProperty("com.sun.enterprise.web.connector.enableJK.propertyFile");
        if (propertiesURL == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("com.sun.enterprise.web.connector.enableJK.propertyFile not defined");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Loading glassfish-jk.properties from " + propertiesURL);
        }
        if (!(propertiesFile = new File(propertiesURL)).exists()) {
            String msg = _rb.getString("pewebcontainer.missingJKProperties");
            msg = MessageFormat.format(msg, propertiesURL);
            _logger.log(Level.WARNING, msg);
            return;
        }
        Properties properties = null;
        InputStream is = null;
        try {
            FileInputStream fis = new FileInputStream(propertiesFile);
            is = new BufferedInputStream(fis);
            properties = new Properties();
            properties.load(is);
        }
        catch (Exception ex) {
            String msg = _rb.getString("pewebcontainer.configureJK");
            msg = MessageFormat.format(msg, this.getPort());
            _logger.log(Level.SEVERE, msg, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            String value = properties.getProperty(propName);
            if (value == null) continue;
            IntrospectionUtils.setProperty((Object)((Object)this), (String)propName, (String)value);
        }
    }

    public void configureFileCache(FileCache fileCache) {
        if (fileCache != null) {
            this.setLargeFileCacheEnabled(ConfigBeansUtilities.toBoolean((String)fileCache.getEnabled()));
            if (fileCache.getMaxAgeSeconds() != null) {
                this.setSecondsMaxAge(Integer.parseInt(fileCache.getMaxAgeSeconds()));
            }
            if (fileCache.getMaxFilesCount() != null) {
                this.setMaxCacheEntries(Integer.parseInt(fileCache.getMaxFilesCount()));
            }
            if (fileCache.getMaxCacheSizeBytes() != null) {
                this.setMaxLargeCacheSize(Integer.parseInt(fileCache.getMaxCacheSizeBytes()));
            }
        }
    }

    public void configureThreadPool(ThreadPool pool) {
        if (pool != null) {
            String msg;
            try {
                this.setMaxProcessors(Integer.parseInt(pool.getMaxThreadPoolSize()));
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("webcontainer.invalidThreadPoolAttribute");
                msg = MessageFormat.format(msg, "max-thread-pool-size");
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                this.setMinProcessors(Integer.parseInt(pool.getMinThreadPoolSize()));
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("webcontainer.invalidThreadPoolAttribute");
                msg = MessageFormat.format(msg, "min-thread-pool-size");
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                this.setQueueSizeInBytes(Integer.parseInt(pool.getMaxQueueSize()));
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("webcontainer.invalidThreadPoolAttribute");
                msg = MessageFormat.format(msg, "max-queue-size");
                _logger.log(Level.WARNING, msg, ex);
            }
        }
    }

    public boolean configureHttpListenerProperty(String propName, String propValue) throws NumberFormatException {
        if ("proxyHandler".equals(propName)) {
            this.setProxyHandler(propValue);
            return true;
        }
        return false;
    }

    public void configHttpProperties(Http http, Transport transport, Ssl ssl) {
        this.setAllowTrace(ConfigBeansUtilities.toBoolean((String)http.getTraceEnabled()));
        this.setMaxKeepAliveRequests(Integer.parseInt(http.getMaxConnections()));
        this.setKeepAliveTimeoutInSeconds(Integer.parseInt(http.getTimeoutSeconds()));
        this.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)http.getAuthPassThroughEnabled()));
        this.setMaxPostSize(Integer.parseInt(http.getMaxPostSizeBytes()));
        this.setProperty("compression", http.getCompression());
        this.setProperty("compressableMimeType", http.getCompressableMimeType());
        if (http.getNoCompressionUserAgents() != null) {
            this.setProperty("noCompressionUserAgents", http.getNoCompressionUserAgents());
        }
        this.setProperty("compressionMinSize", http.getCompressionMinSizeBytes());
        if (http.getRestrictedUserAgents() != null) {
            this.setProperty("restrictedUserAgents", http.getRestrictedUserAgents());
        }
        this.setProperty("cometSupport", ConfigBeansUtilities.toBoolean((String)http.getCometSupportEnabled()));
        this.setProperty("rcmSupport", ConfigBeansUtilities.toBoolean((String)http.getRcmSupportEnabled()));
        this.setConnectionUploadTimeout(Integer.parseInt(http.getConnectionUploadTimeoutMillis()));
        this.setDisableUploadTimeout(!ConfigBeansUtilities.toBoolean((String)http.getUploadTimeoutEnabled()));
        this.setURIEncoding(http.getUriEncoding());
        this.setChunkingDisabled(!ConfigBeansUtilities.toBoolean((String)http.getChunkingEnabled()));
        this.configSslOptions(ssl);
    }

    private void configSslOptions(Ssl ssl) {
        if (ssl != null) {
            if (ssl.getCrlFile() != null) {
                this.setCrlFile(ssl.getCrlFile());
            }
            if (ssl.getTrustAlgorithm() != null) {
                this.setTrustAlgorithm(ssl.getTrustAlgorithm());
            }
            if (ssl.getTrustMaxCertLength() != null) {
                this.setTrustMaxCertLength(ssl.getTrustMaxCertLength());
            }
        }
    }

    public void setProxyHandler(String className) {
        Object handler = null;
        try {
            Class handlerClass = this.webContainer.loadCommonClass(className);
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            String msg = _rb.getString("pewebcontainer.proxyHandlerClassLoadError");
            msg = MessageFormat.format(msg, className);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (handler != null) {
            if (!(handler instanceof ProxyHandler)) {
                _logger.log(Level.SEVERE, "pewebcontainer.proxyHandlerClassInvalid", className);
            } else {
                this.setProxyHandler(handler);
            }
        }
    }

    public void requestStartEvent(HttpServletRequest request, Host host, Context context) {
        if (this.requestProbeProvider != null) {
            String appName = null;
            if (context != null) {
                appName = ((WebModule)context).getMonitoringNodeName();
            }
            String hostName = null;
            if (host != null) {
                hostName = host.getName();
            }
            this.requestProbeProvider.requestStartEvent(appName, hostName, request.getServerName(), request.getServerPort(), request.getContextPath(), request.getServletPath());
        }
    }

    public void requestEndEvent(HttpServletRequest request, Host host, Context context, int statusCode) {
        if (this.requestProbeProvider != null) {
            String appName = null;
            if (context != null) {
                appName = ((WebModule)context).getMonitoringNodeName();
            }
            String hostName = null;
            if (host != null) {
                hostName = host.getName();
            }
            this.requestProbeProvider.requestEndEvent(appName, hostName, request.getServerName(), request.getServerPort(), request.getContextPath(), request.getServletPath(), statusCode);
        }
    }

    private void configureSSL(NetworkListener listener) {
        String ciphers;
        Ssl sslConfig = listener.findHttpProtocol().getSsl();
        if (sslConfig == null) {
            return;
        }
        if (Boolean.valueOf(sslConfig.getClientAuthEnabled()).booleanValue()) {
            this.setClientAuth(true);
        }
        StringBuilder sslProtocolsBuf = new StringBuilder();
        boolean needComma = false;
        if (Boolean.valueOf(sslConfig.getSsl2Enabled()).booleanValue()) {
            sslProtocolsBuf.append("SSLv2");
            needComma = true;
        }
        if (Boolean.valueOf(sslConfig.getSsl3Enabled()).booleanValue()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            } else {
                needComma = true;
            }
            sslProtocolsBuf.append("SSLv3");
        }
        if (Boolean.valueOf(sslConfig.getTlsEnabled()).booleanValue()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            }
            sslProtocolsBuf.append("TLSv1");
        }
        if (Boolean.valueOf(sslConfig.getSsl3Enabled()).booleanValue() || Boolean.valueOf(sslConfig.getTlsEnabled()).booleanValue()) {
            sslProtocolsBuf.append(", SSLv2Hello");
        }
        if (sslProtocolsBuf.length() == 0) {
            _logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", listener.getName());
        } else {
            this.setSslProtocols(sslProtocolsBuf.toString());
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            this.setKeyAlias(sslConfig.getCertNickname());
        }
        if ((ciphers = sslConfig.getSsl3TlsCiphers()) != null) {
            String jsseCiphers = this.getJSSECiphers(ciphers);
            if (jsseCiphers == null) {
                _logger.log(Level.WARNING, "pewebcontainer.all_ciphers_disabled", listener.getName());
            } else {
                this.setCiphers(jsseCiphers);
            }
        }
    }

    private void configureKeysAndCerts() {
        String prop = System.getProperty("javax.net.ssl.keyStore");
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
        if (prop != null) {
            this.setKeystoreFile(prop);
            this.setKeystoreType(keyStoreType);
        }
        if ((prop = System.getProperty("javax.net.ssl.trustStore")) != null) {
            this.setTruststore(prop);
            this.setTruststoreType("JKS");
        }
    }

    private void configureHttpListenerProperties(NetworkListener listener) {
        this.configHttpProperties(listener.findHttpProtocol().getHttp(), listener.findTransport(), listener.findHttpProtocol().getSsl());
    }

    private String getJSSECiphers(String ciphers) {
        String cipher = null;
        StringBuffer enabledCiphers = null;
        boolean first = true;
        int index = ciphers.indexOf(44);
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                cipher = ciphers.substring(fromIndex, index).trim();
                if (cipher.length() > 0 && !cipher.startsWith("-")) {
                    String jsseCipher;
                    if (cipher.startsWith("+")) {
                        cipher = cipher.substring(1);
                    }
                    if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                        _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
                    } else {
                        if (enabledCiphers == null) {
                            enabledCiphers = new StringBuffer();
                        }
                        if (!first) {
                            enabledCiphers.append(", ");
                        } else {
                            first = false;
                        }
                        enabledCiphers.append(jsseCipher);
                    }
                }
                fromIndex = index + 1;
                index = ciphers.indexOf(44, fromIndex);
            }
            cipher = ciphers.substring(fromIndex);
        } else {
            cipher = ciphers;
        }
        if (cipher != null && (cipher = cipher.trim()).length() > 0 && !cipher.startsWith("-")) {
            String jsseCipher;
            if (cipher.startsWith("+")) {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
            } else {
                if (enabledCiphers == null) {
                    enabledCiphers = new StringBuffer();
                }
                if (!first) {
                    enabledCiphers.append(", ");
                } else {
                    first = false;
                }
                enabledCiphers.append(jsseCipher);
            }
        }
        return enabledCiphers == null ? null : enabledCiphers.toString();
    }

    private String getJSSECipher(String cipher) {
        String jsseCipher = null;
        CipherInfo ci = CipherInfo.getCipherInfo((String)cipher);
        if (ci != null) {
            jsseCipher = ci.getCipherName();
        }
        return jsseCipher;
    }
}

