/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.appclient.client.acc.AppclientCommandArguments;
import org.glassfish.appclient.client.acc.UserError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLaunchInfo {
    private static final String CLIENT_AGENT_ARG_NAME = "client=";
    private static final String COMMAND_AGENT_ARG = "arg=";
    private static final String MODE_AGENT_ARG = "mode=";
    private static final String APPCPATH = "appcpath=";
    private ClientLaunchType clientLaunchType;
    private String clientName;
    private String mode = null;
    private String appcPath = null;
    private AppclientCommandArguments appclientCommandLaunchInfo = null;

    public static CommandLaunchInfo newInstance(String agentArgs) throws UserError {
        CommandLaunchInfo result = new CommandLaunchInfo(agentArgs);
        return result;
    }

    private CommandLaunchInfo(String agentArgs) throws UserError {
        this.clientLaunchType = this.saveArgInfo(agentArgs);
    }

    public String getClientName() {
        return this.clientName;
    }

    public ClientLaunchType getClientLaunchType() {
        return this.clientLaunchType;
    }

    public AppclientCommandArguments getAppclientCommandArguments() {
        return this.appclientCommandLaunchInfo;
    }

    public String getAppcPath() {
        return this.appcPath;
    }

    private ClientLaunchType saveArgInfo(String agentArgs) throws UserError {
        String[] args;
        if (agentArgs == null) {
            return ClientLaunchType.UNKNOWN;
        }
        ClientLaunchType result = null;
        ArrayList<String> appclientCommandArgs = new ArrayList<String>();
        for (String arg : args = agentArgs.split(",")) {
            if (arg.startsWith(CLIENT_AGENT_ARG_NAME)) {
                result = this.processClientArg(arg.substring(CLIENT_AGENT_ARG_NAME.length()));
                continue;
            }
            if (arg.startsWith(COMMAND_AGENT_ARG)) {
                this.processAppclientArg(appclientCommandArgs, arg.substring(COMMAND_AGENT_ARG.length()));
                continue;
            }
            if (arg.startsWith(MODE_AGENT_ARG)) {
                this.processMode(arg.substring(MODE_AGENT_ARG.length()));
                continue;
            }
            if (!arg.startsWith(APPCPATH)) continue;
            this.processAppcPath(arg.substring(APPCPATH.length()));
        }
        this.appclientCommandLaunchInfo = AppclientCommandArguments.newInstance(appclientCommandArgs);
        return result;
    }

    private void processMode(String mode) {
        this.mode = mode;
    }

    private ClientLaunchType processClientArg(String clientSpec) {
        int equalsSign = clientSpec.indexOf(61);
        String clientType = clientSpec.substring(0, equalsSign);
        this.clientName = clientSpec.substring(equalsSign + 1);
        if (this.clientName.startsWith("\"") && this.clientName.endsWith("\"")) {
            this.clientName = this.clientName.substring(1, this.clientName.length() - 1);
        }
        ClientLaunchType type = ClientLaunchType.byType(clientType);
        return type;
    }

    private void processAppclientArg(List<String> commandArgs, String arg) {
        commandArgs.add(arg);
    }

    private void processAppcPath(String appcPath) {
        this.appcPath = appcPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientLaunchType {
        JAR,
        DIR(true),
        CLASSFILE(true),
        CLASS,
        URL,
        UNKNOWN;

        private final boolean usesAppClientCommandForMainProgram;

        private ClientLaunchType() {
            this(false);
        }

        private ClientLaunchType(boolean usesAppClientCommandForMainProgram) {
            this.usesAppClientCommandForMainProgram = usesAppClientCommandForMainProgram;
        }

        boolean usesAppClientCommandForMainProgram() {
            return this.usesAppClientCommandForMainProgram;
        }

        static ClientLaunchType byType(String lowerCaseType) {
            for (ClientLaunchType t : ClientLaunchType.values()) {
                if (!t.name().equalsIgnoreCase(lowerCaseType)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

