/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

class PropertyDAOImpl
extends BaseDAOImpl
implements PropertyDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllNamesSQL;
    protected String selectAllSQL;

    PropertyDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQPROP41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("PROPNAME").append(", ").append("PROPVALUE").append(") VALUES ( ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("PROPVALUE").append(" = ?").append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("PROPVALUE").append(" FROM ").append(this.tableName).append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.selectAllNamesSQL = new StringBuffer(128).append("SELECT ").append("PROPNAME").append(" FROM ").append(this.tableName).toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("PROPNAME").append(", ").append("PROPVALUE").append(" FROM ").append(this.tableName).toString();
    }

    public final String getTableNamePrefix() {
        return "MQPROP41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(Connection connection, String string, Object object) throws BrokerException {
        PreparedStatement preparedStatement;
        block18: {
            boolean bl = false;
            String string2 = null;
            preparedStatement = null;
            try {
                block17: {
                    try {
                        if (connection == null) {
                            connection = DBManager.getDBManager().getConnection(true);
                            bl = true;
                        }
                        if (this.hasProperty(connection, string)) {
                            if (object != null) {
                                string2 = this.updateSQL;
                                preparedStatement = connection.prepareStatement(string2);
                                Util.setObject(preparedStatement, 1, object);
                                preparedStatement.setString(2, string);
                                preparedStatement.executeUpdate();
                                break block17;
                            } else {
                                string2 = this.deleteSQL;
                                preparedStatement = connection.prepareStatement(string2);
                                preparedStatement.setString(1, string);
                                preparedStatement.executeUpdate();
                            }
                            break block17;
                        }
                        if (object != null) {
                            string2 = this.insertSQL;
                            preparedStatement = connection.prepareStatement(string2);
                            preparedStatement.setString(1, string);
                            Util.setObject(preparedStatement, 2, object);
                            preparedStatement.executeUpdate();
                        }
                    }
                    catch (Exception exception) {
                        Exception exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        if (exception instanceof IOException) {
                            exception2 = DBManager.wrapIOException("[" + string2 + "]", (IOException)exception);
                            throw new BrokerException(this.br.getKString("B4112", string), exception2);
                        }
                        if (exception instanceof SQLException) {
                            exception2 = DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception);
                            throw new BrokerException(this.br.getKString("B4112", string), exception2);
                        }
                        exception2 = exception;
                        throw new BrokerException(this.br.getKString("B4112", string), exception2);
                    }
                }
                Object var10_7 = null;
                if (!bl) break block18;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Connection connection, String string) throws BrokerException {
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4232", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4232", string), exception2);
                }
                Object var8_5 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        String string = new StringBuffer(128).append("PROPNAME").append(" <> '").append("imq.bridge.jmsbridge.tables").append("'").toString();
        super.deleteAll(connection, string, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getProperty(Connection connection, String string) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Object object;
        block12: {
            object = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        try {
                            object = Util.readObject(resultSet, 1);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4126", string, (Throwable)iOException);
                        }
                    }
                    Object var10_9 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4231", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4231", string), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return object;
        }
        Util.close(resultSet, preparedStatement, null);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getPropertyNames(Connection connection) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<String> arrayList;
        block10: {
            arrayList = new ArrayList<String>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllNamesSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        arrayList.add(string);
                    }
                    Object var9_8 = null;
                    if (!bl) break block10;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectAllNamesSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4113"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4113"), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getProperties(Connection connection) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Properties properties;
        block13: {
            properties = new Properties();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString("PROPNAME");
                        try {
                            Object object = Util.readObject(resultSet, 2);
                            properties.put(string, object);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4126", string, (Throwable)iOException);
                        }
                    }
                    if (Store.getDEBUG()) {
                        this.logger.log(4, "LOADED " + properties.size() + " PROPERTIES FROM DATABASE");
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4113"), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4113"), exception2);
                }
                Object var9_11 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return properties;
        }
        Util.close(resultSet, preparedStatement, null);
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasProperty(Connection connection, String string) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        boolean bl;
        block10: {
            bl = false;
            boolean bl2 = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4231", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4231", string), exception2);
                }
                Object var10_7 = null;
                if (!bl2) break block10;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (bl2) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return bl;
        }
        Util.close(resultSet, preparedStatement, null);
        return bl;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Properties(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

