/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class PropertiesFile {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String PROP_FILE_SIZE_PROP = "imq.persist.file.property.file.size";
    static final long DEFAULT_PROP_FILE_SIZE = 1024L;
    static final String BASENAME = "property";
    private PHashMap propMap = null;
    private File backingFile = null;
    private LoadException loadException = null;

    PropertiesFile(File file, boolean bl) throws BrokerException {
        Throwable throwable;
        SizeString sizeString = this.config.getSizeProperty(PROP_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(file, BASENAME);
        try {
            this.propMap = new PHashMap(this.backingFile, sizeString.getBytes(), false, bl);
        }
        catch (IOException iOException) {
            this.logger.logStack(32, "B4113", iOException);
            throw new BrokerException(this.br.getString("B4113"), iOException);
        }
        try {
            this.propMap.load();
        }
        catch (IOException iOException) {
            this.logger.logStack(32, "B4113", iOException);
            throw new BrokerException(this.br.getString("B4113"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.logStack(32, "B4113", classNotFoundException);
            throw new BrokerException(this.br.getString("B4113"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4196", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(((PHashMapLoadException)throwable).getKey());
                loadException.setValue(((PHashMapLoadException)throwable).getValue());
                loadException.setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                loadException.setValueCause(((PHashMapLoadException)throwable).getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = this.propMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of persisted properties", throwable);
        }
        if (bl && Store.getDEBUG()) {
            this.logger.log(1, "PropertiesFile initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "PropertiesFile: loaded " + this.propMap.size() + " properties");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    PropertiesFile(FileStore fileStore, File file, File file2) throws BrokerException {
        Throwable throwable;
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4154", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4154", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4154", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                this.logger.log(16, "B4201", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(((PHashMapLoadException)throwable).getKey());
                loadException.setValue(((PHashMapLoadException)throwable).getValue());
                loadException.setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                loadException.setValueCause(((PHashMapLoadException)throwable).getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = pHashMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of persisted properties in old store", throwable);
        }
        try {
            this.propMap = new PHashMap(this.backingFile, file3.length(), false, false);
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4158", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4158", file3, this.backingFile), iOException);
        }
        try {
            this.propMap.load();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4154", file3, this.backingFile, iOException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.log(32, "B4154", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            this.logger.log(32, "B4154", file3, this.backingFile, pHashMapLoadException);
            throw new BrokerException(this.br.getString("B4154", file3, this.backingFile), pHashMapLoadException);
        }
        throwable = this.propMap.getWarning();
        if (throwable != null) {
            this.logger.log(16, "possible loss of persisted properties", throwable);
        }
        for (Map.Entry entry : pHashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.propMap.put(k, v);
        }
        pHashMap.close();
        if (fileStore.upgradeNoBackup() && !file3.delete()) {
            this.logger.log(32, "B1044", file3);
        }
    }

    void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        try {
            boolean bl2 = false;
            if (object == null) {
                Object object2 = this.propMap.remove(string);
                bl2 = object2 != null;
            } else {
                this.propMap.put(string, object);
                bl2 = true;
            }
            if (bl2 && bl) {
                this.sync();
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4112", string);
            throw new BrokerException(this.br.getString("B4112", string), runtimeException);
        }
    }

    Object getProperty(String string) throws BrokerException {
        return this.propMap.get(string);
    }

    String[] getPropertyNames() throws BrokerException {
        Set set = this.propMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    Properties getProperties() throws BrokerException {
        Properties properties = new Properties();
        for (Map.Entry entry : this.propMap.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    void clearAll(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesFile.clearAll() called");
        }
        this.propMap.clear();
        if (bl) {
            try {
                this.sync();
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, "Got exception while synchronizing data to disk", brokerException);
            }
        }
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesFile: closing, " + this.propMap.size() + " properties");
        }
        this.propMap.close();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Properties", String.valueOf(this.propMap.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nProperties");
        printStream.println("----------");
        printStream.println("backing file: " + this.backingFile);
        Set set = this.propMap.entrySet();
        for (Map.Entry entry : set) {
            printStream.println((String)entry.getKey() + "=" + entry.getValue().toString());
        }
    }

    private void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String string = "PropertiesFile sync()";
                this.logger.log(4, string);
            }
            this.propMap.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }
}

