/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.tcp;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpStreams;
import com.sun.messaging.jmq.net.MQServerSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.net.ServerSocketFactory;

public class TcpProtocol
implements Protocol {
    private static boolean DEBUG = false;
    private static ServerSocketFactory ssf = MQServerSocketFactory.getDefault();
    protected static final int defaultReadTimeout = 0;
    protected static final int defaultLingerTimeout = 0;
    protected static final int defaultPort = 8888;
    protected static final int defaultBacklog = 100;
    protected static final Integer zero = new Integer(0);
    protected static final Integer one = new Integer(1);
    protected ProtocolCallback cb = null;
    protected Object callback_data = null;
    protected boolean canChangeBlocking = true;
    protected int readTimeout = 0;
    protected int lingerTimeout = 0;
    protected int port = 8888;
    protected String hostname = null;
    protected int backlog = 100;
    protected boolean nodelay = true;
    protected boolean blocking = true;
    protected int inputBufferSize = 0;
    protected int outputBufferSize = 0;
    protected ServerSocket serversocket = null;
    ServerSocketChannel chl = null;
    Selector selector = null;
    SelectionKey key = null;
    private boolean useChannels = false;
    Object protocolLock = new Object();
    boolean resetSocket = false;
    boolean startSocket = false;

    public void registerProtocolCallback(ProtocolCallback protocolCallback, Object object) {
        this.cb = protocolCallback;
        this.callback_data = object;
    }

    protected void notifyProtocolCallback() {
        if (this.cb == null) {
            return;
        }
        this.cb.socketUpdated(this.callback_data, this.getLocalPort(), this.hostname);
    }

    public String getHostName() {
        return this.hostname;
    }

    public boolean canPause() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSocket createSocket(String string, int n, int n2, boolean bl, boolean bl2) throws IOException {
        ServerSocket serverSocket = null;
        Object object = this.protocolLock;
        synchronized (object) {
            this.useChannels = bl2;
            this.blocking = bl;
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
            if (this.useChannels) {
                if (!bl && this.selector == null) {
                    this.selector = Selector.open();
                }
                this.chl = ServerSocketChannel.open();
                serverSocket = this.chl.socket();
                serverSocket.setReuseAddress(true);
                InetSocketAddress inetSocketAddress = null;
                inetSocketAddress = string == null || string.equals("*") ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
                serverSocket.bind(inetSocketAddress, n2);
                this.serversocket = serverSocket;
                if (!bl) {
                    this.configureBlocking(bl);
                    this.key = this.chl.register(this.selector, 16);
                    this.selector.wakeup();
                }
            } else if (string == null || string.equals("*")) {
                serverSocket = ssf.createServerSocket(n, n2);
            } else {
                InetAddress inetAddress = InetAddress.getByName(string);
                serverSocket = ssf.createServerSocket(n, n2, inetAddress);
            }
        }
        if (DEBUG && serverSocket != null) {
            Globals.getLogger().log(4, "TcpProtocol.creatSocket: " + serverSocket + " " + MQServerSocketFactory.serverSocketToString(serverSocket) + ", backlog=" + n2 + "");
        }
        return serverSocket;
    }

    public void configureBlocking(boolean bl) throws UnsupportedOperationException, IOException {
        if (!this.useChannels) {
            return;
        }
        if (!this.canChangeBlocking && !bl) {
            throw new UnsupportedOperationException(Globals.getBrokerResources().getKString("B4117", "This protocol can not be non-blocking"));
        }
        AbstractSelectableChannel abstractSelectableChannel = this.getChannel();
        if (abstractSelectableChannel == null) {
            throw new UnsupportedOperationException(Globals.getBrokerResources().getKString("B4117", "Can not change blocking because there isnt a socket channel"));
        }
        this.blocking = bl;
        abstractSelectableChannel.configureBlocking(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSelectableChannel getChannel() throws IOException {
        Object object = this.protocolLock;
        synchronized (object) {
            if (this.serversocket == null) {
                return null;
            }
            return this.serversocket.getChannel();
        }
    }

    protected TcpStreams createConnection(Socket socket) throws IOException {
        return new TcpStreams(socket, this.blocking, this.inputBufferSize, this.outputBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtocolStreams accept() throws IOException {
        ServerSocket serverSocket = null;
        Object object = this.protocolLock;
        synchronized (object) {
            serverSocket = this.serversocket;
        }
        try {
            object = null;
            if (this.useChannels && !this.blocking) {
                SocketChannel socketChannel;
                SelectionKey selectionKey;
                int n = this.selector.select();
                if (this.resetSocket) {
                    try {
                        try {
                            this.close();
                            this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
                            this.notifyProtocolCallback();
                        }
                        catch (IOException iOException) {
                            selectionKey = null;
                            this.resetSocket = false;
                        }
                        selectionKey = null;
                        this.resetSocket = false;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        this.resetSocket = false;
                        throw throwable;
                    }
                }
                if (this.startSocket) {
                    try {
                        try {
                            this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
                            this.notifyProtocolCallback();
                        }
                        catch (IOException iOException) {
                            socketChannel = null;
                            this.startSocket = false;
                        }
                        socketChannel = null;
                        this.startSocket = false;
                    }
                    catch (Throwable throwable) {
                        Object var8_18 = null;
                        this.startSocket = false;
                        throw throwable;
                    }
                }
                if (n <= 0) return this.accept();
                Set<SelectionKey> set = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                if (iterator.hasNext()) {
                    selectionKey = iterator.next();
                    iterator.remove();
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                    socketChannel = serverSocketChannel.accept();
                    object = socketChannel.socket();
                }
            } else if (this.serversocket != null) {
                object = this.serversocket.accept();
            }
            if (object == null) {
                throw new IOException(Globals.getBrokerResources().getKString("B4117", "no socket"));
            }
            try {
                ((Socket)object).setTcpNoDelay(this.nodelay);
            }
            catch (SocketException socketException) {
                Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + ((Socket)object).toString() + "]setTcpNoDelay(" + this.nodelay + "): " + socketException.toString(), socketException);
            }
            if (this.readTimeout > 0) {
                try {
                    ((Socket)object).setSoTimeout(this.readTimeout * 1000);
                }
                catch (SocketException socketException) {
                    Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + ((Socket)object).toString() + "]setSoTimeout(" + this.readTimeout + "): " + socketException.toString(), socketException);
                }
            }
            if (this.lingerTimeout <= 0) return this.createConnection((Socket)object);
            try {
                ((Socket)object).setSoLinger(true, this.lingerTimeout * 1000);
                return this.createConnection((Socket)object);
            }
            catch (SocketException socketException) {
                Globals.getLogger().log(16, this.getClass().getSimpleName() + ".accept(): [" + ((Socket)object).toString() + "]setSoLinger(" + this.lingerTimeout + "): " + socketException.toString(), socketException);
            }
            return this.createConnection((Socket)object);
        }
        catch (IOException iOException) {
            if (serverSocket == this.serversocket) throw iOException;
            return this.accept();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException, IllegalStateException {
        Object object = this.protocolLock;
        synchronized (object) {
            if (this.selector != null && !this.startSocket) {
                this.startSocket = true;
                this.selector.wakeup();
                return;
            }
            if (this.serversocket != null || this.startSocket) {
                throw new IOException(Globals.getBrokerResources().getString("B4117", "can not open already opened protocol"));
            }
            this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
            this.notifyProtocolCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.protocolLock;
        synchronized (object) {
            return this.serversocket != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, IllegalStateException {
        Object object = this.protocolLock;
        synchronized (object) {
            try {
                if (this.serversocket == null) {
                    throw new IOException(Globals.getBrokerResources().getString("B4117", "can not close un-opened protocol"));
                }
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)this.getChannel();
                if (serverSocketChannel != null) {
                    SelectionKey selectionKey = serverSocketChannel.keyFor(this.selector);
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    serverSocketChannel.close();
                }
                this.serversocket.close();
                Object var5_4 = null;
                this.serversocket = null;
                this.key = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.serversocket = null;
                this.key = null;
                throw throwable;
            }
        }
    }

    public void checkParameters(Hashtable hashtable) throws IllegalArgumentException {
        this.checkIntValue("port", hashtable, zero, null);
        this.checkIntValue("backlog", hashtable, one, null);
    }

    public void setParameters(Hashtable hashtable) throws IOException {
        boolean bl;
        boolean bl2 = this.serversocket != null;
        int n = this.getIntValue("port", hashtable, this.port);
        this.readTimeout = this.getIntValue("readtimeout", hashtable, this.readTimeout);
        this.lingerTimeout = this.getIntValue("solinger", hashtable, this.lingerTimeout);
        int n2 = this.getIntValue("backlog", hashtable, this.backlog);
        this.blocking = this.getBooleanValue("blocking", hashtable, this.blocking);
        this.useChannels = this.getBooleanValue("useChannels", hashtable, this.useChannels);
        String string = (String)hashtable.get("hostname");
        if (string == null) {
            string = Globals.getHostname();
        }
        if (string == null || string.trim().length() == 0) {
            string = "*";
        }
        int n3 = this.port;
        int n4 = this.backlog;
        boolean bl3 = bl = string == null && this.hostname != null || string != null && this.hostname == null || string != null && this.hostname != null && !string.equals(this.hostname);
        if (n != this.port || n2 != this.backlog || bl) {
            if (n != -1) {
                this.port = n;
            }
            if (n2 != -1) {
                this.backlog = n2;
            }
            if (bl) {
                this.hostname = string;
            }
            if (!bl2) {
                return;
            }
            if (this.getChannel() != null) {
                this.resetSocket = true;
                this.selector.wakeup();
                return;
            }
            ServerSocket serverSocket = this.serversocket;
            try {
                this.serversocket = this.createSocket(this.hostname, this.port, this.backlog, this.blocking, this.useChannels);
                this.notifyProtocolCallback();
                serverSocket.close();
            }
            catch (IOException iOException) {
                this.serversocket = serverSocket;
                this.port = n3;
                this.backlog = n4;
                throw iOException;
            }
        }
    }

    private int checkIntValue(String string, Hashtable hashtable) throws IllegalArgumentException {
        if (hashtable == null) {
            return -1;
        }
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", "Can not convert " + string));
        }
    }

    private int checkIntValue(String string, Hashtable hashtable, Integer n, Integer n2) throws IllegalArgumentException {
        int n3 = this.checkIntValue(string, hashtable);
        if (n3 == -1) {
            return n3;
        }
        if (n != null && n3 < n) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", string + "(" + n3 + ")" + " value below minimum of " + n));
        }
        if (n2 != null && n3 > n2) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getString("B4117", string + "(" + n3 + ")" + " value above maximum of " + n2));
        }
        return n3;
    }

    private int getIntValue(String string, Hashtable hashtable, int n) {
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (Exception exception) {
            Globals.getLogger().log(8, "B3138", (Object)string, (Throwable)exception);
            return n;
        }
    }

    private boolean getBooleanValue(String string, Hashtable hashtable, boolean bl) {
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return bl;
        }
        try {
            boolean bl2 = Boolean.valueOf(string2);
            return bl2;
        }
        catch (Exception exception) {
            Globals.getLogger().log(8, "B3138", (Object)string, (Throwable)exception);
            return bl;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getLocalPort() {
        if (this.serversocket == null) {
            return 0;
        }
        return this.serversocket.getLocalPort();
    }

    public String toString() {
        boolean bl = this.chl != null;
        boolean bl2 = bl && this.blocking;
        return "tcp(host = " + (this.hostname == null ? "*" : this.hostname) + ", port=" + this.port + ", mode=" + (bl ? "shared" : "dedicated") + (bl2 ? " [blocked i/o]" : "") + ")";
    }

    public void setNoDelay(boolean bl) {
        this.nodelay = bl;
    }

    public void setTimeout(int n) {
        throw new UnsupportedOperationException("Setting timeouts no longer supported");
    }

    public void setInputBufferSize(int n) {
        this.inputBufferSize = n;
    }

    public void setOutputBufferSize(int n) {
        this.outputBufferSize = n;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public boolean getBlocking() {
        return this.blocking;
    }
}

