/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class MessageDataHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public MessageDataHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "MessageDataHandler");
        }
        if (gPacket.getType() == 1) {
            this.handleMessageData(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 2) {
            this.handleMessageDataReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "MessageDataHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleMessageData(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterMessageInfo clusterMessageInfo = ClusterMessageInfo.newInstance(gPacket, this.c);
        boolean bl = clusterMessageInfo.getSendMessageDeliveredAck();
        ArrayList<ConsumerUID> arrayList = new ArrayList<ConsumerUID>();
        if (DEBUG) {
            this.logger.log(2, "MessageBus: receiving message.");
        }
        try {
            Serializable serializable;
            clusterMessageInfo.initPayloadRead();
            Iterator iterator = clusterMessageInfo.readPayloadConsumerUIDs();
            while (iterator.hasNext()) {
                serializable = (ConsumerUID)iterator.next();
                arrayList.add((ConsumerUID)serializable);
            }
            Packet packet = clusterMessageInfo.readPayloadMessage();
            serializable = clusterMessageInfo.getHomeBrokerAddress();
            if (serializable == null) {
                serializable = brokerAddress;
            }
            messageBusCallback.processRemoteMessage(packet, arrayList, (BrokerAddress)serializable, bl);
        }
        catch (Exception exception) {
            this.logger.logStack(32, "Internal Exception, unable to process message " + gPacket, exception);
        }
        if (clusterMessageInfo.needReply()) {
            try {
                this.c.unicast(brokerAddress, clusterMessageInfo.getReplyGPacket(200));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void handleMessageDataReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received reset G_MESSAGE_DATA_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

