/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.IOException;

public class GoodbyeHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public GoodbyeHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (gPacket.getType() == 37) {
            this.handleGoodbye(brokerAddress, gPacket);
        } else if (gPacket.getType() == 38) {
            this.handleGoodbyeReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "B3100", "Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleGoodbye(BrokerAddress brokerAddress, GPacket gPacket) {
        try {
            ClusterGoodbyeInfo clusterGoodbyeInfo = ClusterGoodbyeInfo.newInstance(gPacket, this.c);
            this.p.goodbyeReceived(brokerAddress, clusterGoodbyeInfo);
            this.p.sendGoodbye(brokerAddress);
            this.cbDispatcher.processGoodbye(brokerAddress, clusterGoodbyeInfo);
            if (clusterGoodbyeInfo.needReply()) {
                GPacket gPacket2 = ClusterGoodbyeInfo.getReplyGPacket(200);
                try {
                    this.c.unicastAndClose(brokerAddress, gPacket2);
                    this.p.goodbyeReplySent(brokerAddress);
                }
                catch (IOException iOException) {
                    this.logger.logStack(4, Globals.getBrokerResources().getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(gPacket2.getType()), brokerAddress), iOException);
                }
            }
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B3100", "Unable to process packet: " + gPacket, (Throwable)exception);
            return;
        }
    }

    public void handleGoodbyeReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.cbDispatcher.processGoodbyeReply(brokerAddress);
        this.p.goodbyeReplyReceived(brokerAddress);
    }
}

