/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

class ConsumerIterator
implements Iterator {
    private int count = 0;
    private int count_read = 0;
    private DataInputStream dis = null;
    private BrokerAddress from = null;
    private GPacket gp = null;

    public ConsumerIterator(GPacket gPacket, byte[] byArray, int n, BrokerAddress brokerAddress) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.dis = new DataInputStream(byteArrayInputStream);
        this.count = n;
        this.count_read = 0;
        this.from = brokerAddress;
        this.gp = gPacket;
    }

    public boolean hasNext() {
        if (this.count_read < 0) {
            throw new IllegalStateException("ConsumerUID");
        }
        return this.count_read < this.count;
    }

    public Object next() throws RuntimeException {
        try {
            Consumer consumer = ClusterConsumerInfo.readConsumer(this.dis);
            Integer n = (Integer)this.gp.getProp(String.valueOf(consumer.getConsumerUID().longValue()) + ":" + "prefetch");
            if (n != null) {
                consumer.setRemotePrefetch(n);
            }
            if (this.from != null) {
                consumer.getConsumerUID().setBrokerAddress(this.from);
            }
            ++this.count_read;
            return consumer;
        }
        catch (IOException iOException) {
            this.count_read = -1;
            throw new RuntimeException(iOException);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

