/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Hashtable;

public class ReplaceMessageHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ReplaceMessageHandler.getDEBUG();

    public ReplaceMessageHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        Hashtable<String, String> hashtable2;
        String string;
        int n;
        block16: {
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": " + "Replace message: " + hashtable);
            }
            n = 200;
            string = null;
            String string2 = (String)hashtable.get("JMQDestination");
            Integer n2 = (Integer)hashtable.get("JMQDestType");
            String string3 = (String)hashtable.get("JMQMessageID");
            hashtable2 = null;
            String string4 = null;
            Object object2 = null;
            if (string2 == null || n2 == null) {
                string = "REPLACE_MESSAGE: Destination name and type not specified";
                this.logger.log(32, string);
                n = 500;
            }
            if (string3 == null) {
                string = "REPLACE_MESSAGE: Message ID not specified";
                this.logger.log(32, string);
                n = 500;
            }
            if ((object2 = this.getBodyObject(packet)) == null || !(object2 instanceof HashMap)) {
                string = "REPLACE_MESSAGE: New message body specified or is of incorrect type";
                this.logger.log(32, string);
                n = 500;
            }
            if (n == 200) {
                try {
                    object = Destination.getDestination(string2, DestType.isQueue(n2));
                    if (object != null) {
                        if (DEBUG) {
                            ((Destination)object).debug();
                        }
                        ((Destination)object).load();
                        SysMessageID sysMessageID = SysMessageID.get(string3);
                        PacketReference packetReference = ReplaceMessageHandler.getPacketReference(sysMessageID);
                        if (packetReference != null) {
                            Integer n3;
                            HashMap hashMap = (HashMap)object2;
                            int n4 = packetReference.getPacket().getPacketType();
                            if (n4 != (n3 = (Integer)hashMap.get("MessageBodyType"))) {
                                string = "REPLACE_MESSAGE: Existing message and new message types do not match.";
                                this.logger.log(32, string);
                                n = 500;
                            } else {
                                byte[] byArray = this.getBytesFromMessage(hashMap);
                                string4 = ((Destination)object).replaceMessageString(sysMessageID, null, byArray);
                                if (string4 == null) {
                                    string = "REPLACE_MESSAGE: New message ID not returned as expected.";
                                    this.logger.log(32, string);
                                    n = 500;
                                } else {
                                    hashtable2 = new Hashtable<String, String>();
                                    hashtable2.put("JMQMessageID", string4.toString());
                                }
                            }
                        } else {
                            string = "REPLACE_MESSAGE: Could not locate message " + string3 + " in destination " + string2;
                            n = 404;
                        }
                    } else {
                        string = this.rb.getString("B4017", string2);
                        n = 404;
                    }
                }
                catch (Exception exception) {
                    this.logger.log(32, "Internal Error ", exception);
                    n = 500;
                    string = exception.getMessage();
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError();
                }
            }
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        ReplaceMessageHandler.setProperties((Packet)object, 91, n, string, hashtable2);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }

    public byte[] getBytesFromMessage(HashMap hashMap) {
        String string = null;
        byte[] byArray = null;
        Object v = hashMap.get("MessageBody");
        Integer n = (Integer)hashMap.get("MessageBodyType");
        switch (n) {
            case 1: {
                try {
                    String string2 = (String)v;
                    byArray = string2.getBytes("UTF8");
                }
                catch (Exception exception) {
                    string = "Caught exception while creating text message body";
                    this.logger.log(32, string, exception);
                }
                break;
            }
            case 2: {
                byArray = (byte[])v;
                break;
            }
            case 3: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    HashMap hashMap2 = (HashMap)v;
                    objectOutputStream.writeObject(hashMap2);
                    objectOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    string = "Caught exception while creating map message body";
                    this.logger.log(32, string, exception);
                }
                break;
            }
            case 4: {
                byArray = (byte[])v;
                break;
            }
            case 5: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(v);
                    objectOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    string = "Caught exception while creating object message body";
                    this.logger.log(32, string, exception);
                }
                break;
            }
            default: {
                string = "Unsupported message type for REPLACE_MESSAGE handler: " + n;
                this.logger.log(32, string);
            }
        }
        return byArray;
    }

    public static PacketReference getPacketReference(SysMessageID sysMessageID) {
        return Destination.get(sysMessageID);
    }
}

