/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class GetLicenseHandler
extends PacketHandler {
    private ConnectionManager connectionList;
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    private static boolean DEBUG;
    private static boolean ALLOW_C_CLIENTS;
    private static boolean CAN_RECONNECT;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        if (DEBUG) {
            this.logger.log(1, "GetLicenseHandler: handle(" + iMQConnection + ", " + PacketType.getString(packet.getPacketType()) + ")");
        }
        String string = "";
        int n = 200;
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(77);
        packet2.setConsumerID(packet.getConsumerID());
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            hashtable.put("JMQLicense", licenseBase.getProperty("imq.license_type"));
            hashtable.put("JMQLicenseDesc", licenseBase.getProperty("description"));
            Properties properties = licenseBase.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                hashtable.put(string2, properties.get(string2));
            }
        }
        catch (BrokerException brokerException) {
            string = brokerException.toString();
            n = 500;
        }
        hashtable.put("JMQStatus", new Integer(n));
        if (n != 200) {
            hashtable.put("JMQReason", string);
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }

    static {
        LicenseBase licenseBase;
        DEBUG = false;
        ALLOW_C_CLIENTS = false;
        CAN_RECONNECT = false;
        try {
            licenseBase = Globals.getCurrentLicense(null);
        }
        catch (BrokerException brokerException) {
            // empty catch block
        }
        try {
            licenseBase = Globals.getCurrentLicense(null);
            CAN_RECONNECT = licenseBase.getBooleanProperty("imq.enable_failover", false);
        }
        catch (BrokerException brokerException) {
            CAN_RECONNECT = false;
        }
    }
}

