/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RemoteTransaction
extends BaseTransaction {
    TransactionAcknowledgement[] txnAcks;
    DestinationUID[] destIds;
    BrokerAddress txnHomeBroker;

    public RemoteTransaction() {
        super(2);
    }

    public RemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, DestinationUID[] destinationUIDArray, BrokerAddress brokerAddress) {
        this();
        this.transactionDetails.setTid(transactionUID);
        this.transactionDetails.setState(transactionState.getState());
        this.transactionDetails.setXid(transactionState.getXid());
        this.transactionState = transactionState;
        this.setTxnAcks(transactionAcknowledgementArray);
        this.setDestIds(destinationUIDArray);
        this.setTxnHomeBroker(brokerAddress);
    }

    public void readData(DataInputStream dataInputStream) throws IOException, BrokerException {
        this.transactionDetails.readContent(dataInputStream);
    }

    public void readObjects(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.transactionState = (TransactionState)objectInputStream.readObject();
        this.txnAcks = (TransactionAcknowledgement[])objectInputStream.readObject();
        this.destIds = (DestinationUID[])objectInputStream.readObject();
        this.txnHomeBroker = (BrokerAddress)objectInputStream.readObject();
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        this.transactionDetails.writeContent(dataOutputStream);
    }

    public void writeObjects(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.transactionState);
        objectOutputStream.writeObject(this.txnAcks);
        objectOutputStream.writeObject(this.destIds);
        objectOutputStream.writeObject(this.txnHomeBroker);
    }

    String getPrefix() {
        return "RemoteTransaction: " + Thread.currentThread().getName() + " " + this.getTid();
    }

    public TransactionAcknowledgement[] getTxnAcks() {
        return this.txnAcks;
    }

    public void setTxnAcks(TransactionAcknowledgement[] transactionAcknowledgementArray) {
        this.txnAcks = transactionAcknowledgementArray;
    }

    public BrokerAddress getTxnHomeBroker() {
        return this.txnHomeBroker;
    }

    public void setTxnHomeBroker(BrokerAddress brokerAddress) {
        this.txnHomeBroker = brokerAddress;
    }

    public DestinationUID[] getDestIds() {
        return this.destIds;
    }

    public void setDestIds(DestinationUID[] destinationUIDArray) {
        this.destIds = destinationUIDArray;
    }
}

