/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.audit;

import com.sun.audit.AuditEvent_network_modify;
import com.sun.audit.AuditSession;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;
import java.util.HashMap;

public class BSMAuditSession
extends MQAuditSession {
    private static final String LIBRARY = "imqutil";
    private static boolean useNative = false;
    private static final int ADT_NO_ATTRIB = -1;
    private AuditSession auditSession = null;
    private int[] unknownids = new int[]{-1, -1};
    private int[] brokerids = this.unknownids;
    HashMap idTable = new HashMap();

    private static native int[] nativeGetUidGid(String var0);

    private static native int[] nativeBrokerUidGid();

    BSMAuditSession() {
        if (MQAuditService.bsmAudit) {
            try {
                this.auditSession = new AuditSession(null);
                this.auditOn = this.auditSession.auditOn();
            }
            catch (Throwable throwable) {
                this.logger.log(16, "Failed to get BSM AuditSession; BSM auditing will not be available", throwable);
            }
            this.logger.log(4, "created auditSession= " + this.auditSession);
            if (this.auditOn && useNative) {
                try {
                    int[] nArray = BSMAuditSession.nativeBrokerUidGid();
                    if (nArray != null && nArray.length == 2) {
                        this.brokerids = nArray;
                    }
                    this.logger.log(4, "Broker uid=" + this.brokerids[0] + ";gid=" + this.brokerids[1]);
                }
                catch (Throwable throwable) {
                    this.logger.log(4, "Failed to get uid/gid of user running the broker", throwable);
                }
            }
        }
        this.logger.log(4, this + ":auditOn=" + this.auditOn);
    }

    public void authentication(String string, String string2, boolean bl) {
        if (!this.auditOn) {
            return;
        }
        try {
            int n = bl ? 0 : -1;
            this.setUser(string, string2, true);
            AuditEvent_network_modify auditEvent_network_modify = new AuditEvent_network_modify(this.auditSession);
            auditEvent_network_modify.domain("MQ action=authentication;MQ user=" + string + ";" + "host=" + string2);
            auditEvent_network_modify.object_name("MQ instance=" + this.instance);
            auditEvent_network_modify.putEvent(n, 0);
            this.logger.log(4, "BSM putEvent for authentication");
        }
        catch (Throwable throwable) {
            this.logger.log(16, "BSM putEvent failed for authentication", throwable);
        }
    }

    public void brokerOperation(String string, String string2, String string3) {
        if (!this.auditOn) {
            return;
        }
        try {
            if (string == null) {
                this.setUser(this.brokerids, this.brokerHost);
            } else {
                this.setUser(string, string2, false);
            }
            AuditEvent_network_modify auditEvent_network_modify = new AuditEvent_network_modify(this.auditSession);
            auditEvent_network_modify.domain("MQ action=" + string3 + ";" + "MQ user=" + string + ";" + "host=" + (string2 == null ? this.brokerHost : string2));
            auditEvent_network_modify.object_name("MQ instance=" + this.instance);
            auditEvent_network_modify.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + string3);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "BSM putEvent failed for " + string3, throwable);
        }
    }

    public void connectionAuth(String string, String string2, String string3, String string4, boolean bl) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(string, string2, false);
            AuditEvent_network_modify auditEvent_network_modify = new AuditEvent_network_modify(this.auditSession);
            auditEvent_network_modify.domain("MQ action=authorization;MQ user=" + string + ";" + "host=" + string2);
            auditEvent_network_modify.object_name("MQ instance=" + this.instance);
            auditEvent_network_modify.auth_used("type=" + string3 + ";" + "name=" + string4);
            int n = bl ? 0 : -1;
            auditEvent_network_modify.putEvent(n, 0);
            this.logger.log(4, "BSM putEvent for connection authorization");
        }
        catch (Throwable throwable) {
            this.logger.log(16, "BSM putEvent failed for connection authorization", throwable);
        }
    }

    public void destinationAuth(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(string, string2, false);
            AuditEvent_network_modify auditEvent_network_modify = new AuditEvent_network_modify(this.auditSession);
            auditEvent_network_modify.domain("MQ action=authorization;MQ user=" + string + ";" + "host=" + string2);
            auditEvent_network_modify.object_name("MQ instance=" + this.instance);
            auditEvent_network_modify.auth_used("type=" + string3 + ";" + "name=" + string4 + ";" + "operation=" + string5);
            int n = bl ? 0 : -1;
            auditEvent_network_modify.putEvent(n, 0);
            this.logger.log(4, "BSM putEvent for destination authorization");
        }
        catch (Throwable throwable) {
            this.logger.log(16, "BSM putEvent failed for destination authorization", throwable);
        }
    }

    public void storeOperation(String string, String string2, String string3) {
        if (!this.auditOn) {
            return;
        }
        try {
            if (string == null) {
                this.setUser(this.brokerids, this.brokerHost);
            } else {
                this.setUser(string, string2, false);
            }
            AuditEvent_network_modify auditEvent_network_modify = new AuditEvent_network_modify(this.auditSession);
            auditEvent_network_modify.domain("MQ action=" + string3 + ";" + "MQ user=" + string + ";" + "host=" + (string2 == null ? this.brokerHost : string2));
            auditEvent_network_modify.object_name("MQ instance=" + this.instance);
            auditEvent_network_modify.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + string3);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "BSM putEvent failed for " + string3, throwable);
        }
    }

    public void destinationOperation(String string, String string2, String string3, String string4, String string5) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(string, string2, false);
            AuditEvent_network_modify auditEvent_network_modify = new AuditEvent_network_modify(this.auditSession);
            auditEvent_network_modify.domain("MQ action=" + string3 + ";" + "MQ user=" + string + ";" + "host=" + string2);
            auditEvent_network_modify.object_name("MQ instance=" + this.instance);
            auditEvent_network_modify.changed_values("type=" + string4 + ";" + "name=" + string5);
            auditEvent_network_modify.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + string3);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "BSM putEvent failed for " + string3, throwable);
        }
    }

    public void durableSubscriberOperation(String string, String string2, String string3, String string4, String string5) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(string, string2, false);
            AuditEvent_network_modify auditEvent_network_modify = new AuditEvent_network_modify(this.auditSession);
            auditEvent_network_modify.domain("MQ action=" + string3 + ";" + "MQ user=" + string + ";" + "host=" + string2);
            auditEvent_network_modify.object_name("MQ instance=" + this.instance);
            auditEvent_network_modify.changed_values("name=" + string4 + ";" + "clientID=" + string5);
            auditEvent_network_modify.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + string3);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "BSM putEvent failed for " + string3, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUser(String string, String string2, boolean bl) {
        int[] nArray = this.unknownids;
        if (useNative) {
            HashMap hashMap = this.idTable;
            synchronized (hashMap) {
                nArray = (int[])this.idTable.get(string);
                try {
                    if (bl || nArray == null) {
                        int[] nArray2;
                        nArray = string != null && string.length() > 0 ? ((nArray2 = BSMAuditSession.nativeGetUidGid(string)) != null && nArray2.length == 2 ? nArray2 : this.unknownids) : this.unknownids;
                        this.idTable.put(string, nArray);
                    }
                }
                catch (Throwable throwable) {
                    this.logger.log(4, "Failed to get uid/gid", throwable);
                }
            }
        }
        this.setUser(nArray, string2);
    }

    private void setUser(int[] nArray, String string) {
        if (this.auditSession == null) {
            return;
        }
        if (string == null) {
            string = this.brokerHost;
        } else if ("127.0.0.1".equals(string)) {
            string = "localhost";
        }
        try {
            if (nArray[0] == -1) {
                nArray[0] = 0;
            }
            if (nArray[1] == -1) {
                nArray[1] = 0;
            }
            this.auditSession.setUser(nArray[0], nArray[1], nArray[0], nArray[1], string, 0);
        }
        catch (Throwable throwable) {
            this.logger.log(16, "Failed to set user in BSM AuditSession", throwable);
        }
    }

    static {
        if (MQAuditService.bsmAudit) {
            try {
                System.loadLibrary(LIBRARY);
                useNative = true;
            }
            catch (Throwable throwable) {
                useNative = false;
                throwable.printStackTrace();
            }
        }
    }
}

