/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.bridge.BridgeBaseContext;
import com.sun.messaging.bridge.BridgeServiceManager;
import com.sun.messaging.bridge.BridgeUtil;
import com.sun.messaging.bridge.admin.handlers.AdminMessageHandler;
import com.sun.messaging.bridge.resources.BridgeManagerResources;
import com.sun.messaging.bridge.service.Bridge;
import com.sun.messaging.bridge.service.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.BridgeException;
import com.sun.messaging.bridge.service.DupKeyException;
import com.sun.messaging.bridge.service.FaultInjection;
import com.sun.messaging.bridge.service.JMSBridgeStore;
import com.sun.messaging.jmq.jmsclient.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.RejectedExecutionException;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TemporaryQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeServiceManagerImpl
extends BridgeServiceManager
implements ExceptionListener,
MessageListener {
    private static boolean DEBUG = false;
    private static BridgeManagerResources _bmr = BridgeServiceManagerImpl.getBridgeManagerResources();
    private static Map<Locale, BridgeManagerResources> _bmrs = Collections.synchronizedMap(new HashMap());
    private Map<String, Bridge> _bridges = Collections.synchronizedMap(new LinkedHashMap());
    private BridgeBaseContext _bc = null;
    private ConnectionFactory _cf = null;
    private Connection _connection = null;
    private Session _session = null;
    private String _user = null;
    private String _passwd = null;
    private TemporaryQueue _adminQueue = null;
    private State _state = State.UNINITIALIZED;
    private AdminMessageHandler _adminHandler = null;

    @Override
    public synchronized void init(BridgeBaseContext bridgeBaseContext) throws Exception {
        Object object;
        Object object2;
        Debug.setUseLogger((boolean)true);
        FaultInjection.setBridgeBaseContext(bridgeBaseContext);
        this._bc = bridgeBaseContext;
        Properties properties = this._bc.getBridgeConfig();
        String string = properties.getProperty("PROP_PREFIX") + ".activelist";
        List<String> list = BridgeUtil.getListProperty(string, properties);
        int n = list.size();
        String string22 = null;
        for (String string22 : list) {
            try {
                this.loadBridge(string22);
            }
            catch (BridgeException bridgeException) {
                if (bridgeException.getStatus() == 304) continue;
                this._bc.logError(_bmr.getKString("BB3000", string22, bridgeException.getMessage()), null);
                throw bridgeException;
            }
        }
        if (this._bc.isHAEnabled()) {
            CharSequence charSequence;
            object2 = (JMSBridgeStore)this._bc.getJDBCStore();
            if (object2 == null) {
                throw new BridgeException("null JDBC store");
            }
            object = object2.getJMSBridges(null);
            string22 = null;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                string22 = iterator.next();
                charSequence = properties.getProperty(properties.getProperty("PROP_PREFIX") + "." + string22 + ".type");
                if (charSequence == null) {
                    throw new BridgeException(_bmr.getString("BB4000", string22));
                }
                if (!((String)charSequence).trim().toUpperCase().equals("JMS") || object.contains(string22)) continue;
                try {
                    object2.addJMSBridge(string22, true, null);
                }
                catch (DupKeyException dupKeyException) {
                    this._bc.logInfo(_bmr.getKString("BB1000", string22), null);
                    iterator.remove();
                }
            }
            object = object2.getJMSBridges(null);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string22 = iterator.next();
                if (list.contains(string22)) continue;
                list.add(string22);
                try {
                    this.loadBridge(string22);
                }
                catch (BridgeException bridgeException) {
                    this._bc.logError(_bmr.getKString("BB3000", string22, bridgeException.getMessage()), null);
                    throw bridgeException;
                }
            }
            if (list.size() != n) {
                charSequence = new StringBuffer();
                int n2 = 0;
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (n2 > 0) {
                        ((StringBuffer)charSequence).append(",");
                    }
                    ((StringBuffer)charSequence).append(iterator.next());
                    ++n2;
                }
                Properties properties2 = new Properties();
                properties2.setProperty(string, ((StringBuffer)charSequence).toString());
                this._bc.updateBridgeConfig(properties2);
            }
        }
        this._cf = new ConnectionFactory();
        this._cf.setProperty("imqBrokerHostName", this._bc.getBrokerHostName());
        this._cf.setProperty("imqBrokerHostPort", String.valueOf(this._bc.getBrokerHostPort()));
        this._cf.setConnectionType("ADMIN");
        this._cf.setProperty("imqReconnectEnabled", "false");
        object2 = properties.getProperty("PROP_PREFIX") + ".admin.user";
        object = properties.getProperty("PROP_PREFIX") + ".admin.password";
        this._user = properties.getProperty((String)object2);
        this._passwd = properties.getProperty((String)object);
        if (this._user == null || this._user.trim().length() == 0) {
            throw new JMSException(_bmr.getString("BB4001", object2));
        }
        this._user = this._user.trim();
        if (this._passwd == null || this._passwd.trim().length() == 0) {
            throw new JMSException(_bmr.getString("BB4002", object));
        }
        this._passwd = this._passwd.trim();
        this._adminHandler = new AdminMessageHandler(this);
        this._state = State.STOPPED;
    }

    @Override
    public synchronized boolean isRunning() {
        return this._state == State.STARTED;
    }

    @Override
    public synchronized String getAdminDestinationName() throws Exception {
        if (this._state != State.STARTED) {
            throw new BridgeException(_bmr.getString("BB4003"));
        }
        return this._adminQueue.getQueueName();
    }

    @Override
    public String getAdminDestinationClassName() throws Exception {
        if (this._state != State.STARTED) {
            throw new BridgeException(_bmr.getString("BB4003"));
        }
        return this._adminQueue.getClass().getName();
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized void start() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void loadBridge(String string) throws Exception {
        this._bc.logInfo("Loading bridge " + string, null);
        Bridge bridge = this._bridges.get(string);
        if (bridge != null) {
            this._bc.logInfo("Bridge " + string + " is already loaded.", null);
            throw new BridgeException(_bmr.getString("BB1001", string), 304);
        }
        Properties properties = this._bc.getBridgeConfig();
        properties = this._bc.getBridgeConfig();
        String string2 = properties.getProperty(properties.getProperty("PROP_PREFIX") + "." + string + ".type");
        if (string2 == null) {
            String string3 = _bmr.getKString("BB3001", string);
            this._bc.logError(string3, null);
            throw new BridgeException(string3);
        }
        string2 = string2.toLowerCase();
        String string4 = properties.getProperty(properties.getProperty("PROP_PREFIX") + "." + string2 + ".class");
        if (string4 == null) {
            String string5 = _bmr.getKString("BB3002", string);
            this._bc.logError(string5, null);
            throw new BridgeException(string5);
        }
        bridge = (Bridge)Class.forName(string4).newInstance();
        if (!bridge.isMultipliable() && !bridge.getType().toLowerCase().equals(string.toLowerCase())) {
            String string6 = _bmr.getKString("BB3003", string, bridge.getType());
            this._bc.logError(string6, null);
            throw new BridgeException(string6);
        }
        if (DEBUG) {
            this._bc.logInfo("Loaded brigde " + string + " by classloader " + bridge.getClass().getClassLoader() + "(parent:" + this.getClass().getClassLoader() + ")", null);
        }
        bridge.setName(string);
        this._bridges.put(string, bridge);
        this._bc.logInfo("Loaded bridge " + string, null);
    }

    public synchronized boolean startBridge(String string, String[] stringArray, String string2) throws Exception {
        if (string2 != null && !string2.equals("JMS") && !string2.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", string2));
        }
        Bridge bridge = null;
        if (string != null) {
            bridge = this._bridges.get(string);
            if (bridge == null) {
                throw new BridgeException(_bmr.getKString("BB4006", string));
            }
            if (string2 != null && !string2.equals(bridge.getType())) {
                Object[] objectArray = new String[]{string, bridge.getType(), string2};
                throw new BridgeException(_bmr.getKString("BB4007", objectArray));
            }
            return this.startBridge(bridge, stringArray);
        }
        boolean bl = false;
        for (Map.Entry<String, Bridge> entry : this._bridges.entrySet()) {
            bridge = entry.getValue();
            if (string2 != null && !bridge.getType().equals(string2) || this.startBridge(bridge, stringArray)) continue;
            bl = true;
        }
        return !bl;
    }

    private boolean startBridge(Bridge bridge, String[] stringArray) throws Exception {
        if (stringArray == null) {
            this._bc.logInfo(_bmr.getString("BB1002", bridge.getName()), null);
        }
        if (bridge.getState() == Bridge.State.STARTED && stringArray == null) {
            this._bc.logInfo(_bmr.getString("BB1003", bridge.getName()), null);
            return true;
        }
        BridgeContext bridgeContext = new BridgeContext(this._bc, bridge.getName());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(_bmr.getString("BB1004", bridge.getName()));
        String string = null;
        Enumeration<?> enumeration = bridgeContext.getConfig().propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append("\t" + string + "=" + bridgeContext.getConfig().getProperty(string) + "\n");
        }
        if (stringArray == null) {
            this._bc.logInfo(stringBuffer.toString(), null);
        }
        try {
            boolean bl = bridge.start(bridgeContext, stringArray);
            if (stringArray == null) {
                this._bc.logInfo(_bmr.getString("BB1005", bridge.getName()), null);
            }
            return bl;
        }
        catch (Exception exception) {
            this._bc.logError(_bmr.getKString("BB3004", bridge.getName(), exception.getMessage()), null);
            throw exception;
        }
    }

    public synchronized void stopBridge(String string, String[] stringArray, String string2) throws Exception {
        if (string2 != null && !string2.equals("JMS") && !string2.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", string2));
        }
        Bridge bridge = null;
        if (string != null) {
            bridge = this._bridges.get(string);
            if (bridge == null) {
                throw new BridgeException(_bmr.getKString("BB4006", string));
            }
            if (string2 != null && !string2.equals(bridge.getType())) {
                Object[] objectArray = new String[]{string, bridge.getType(), string2};
                throw new BridgeException(_bmr.getKString("BB4007", objectArray));
            }
            this.stopBridge(bridge, stringArray);
            return;
        }
        for (Map.Entry<String, Bridge> entry : this._bridges.entrySet()) {
            bridge = entry.getValue();
            if (string2 != null && !bridge.getType().equals(string2)) continue;
            this.stopBridge(bridge, stringArray);
        }
    }

    public synchronized void pauseBridge(String string, String[] stringArray, String string2) throws Exception {
        if (string2 != null && !string2.equals("JMS") && !string2.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", string2));
        }
        if (string == null && string2 == null) {
            throw new UnsupportedOperationException(_bmr.getKString("BB4008"));
        }
        Bridge bridge = null;
        if (string != null) {
            bridge = this._bridges.get(string);
            if (bridge == null) {
                throw new BridgeException(_bmr.getKString("BB4006", string));
            }
            if (string2 != null && !string2.equals(bridge.getType())) {
                Object[] objectArray = new String[]{string, bridge.getType(), string2};
                throw new BridgeException(_bmr.getKString("BB4007", objectArray));
            }
            this.pauseBridge(bridge, stringArray);
            return;
        }
        for (Map.Entry<String, Bridge> entry : this._bridges.entrySet()) {
            bridge = entry.getValue();
            if (string2 != null && !bridge.getType().equals(string2)) continue;
            this.pauseBridge(bridge, stringArray);
        }
    }

    public synchronized void resumeBridge(String string, String[] stringArray, String string2) throws Exception {
        if (string2 != null && !string2.equals("JMS") && !string2.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", string2));
        }
        if (string == null && string2 == null) {
            throw new UnsupportedOperationException(_bmr.getKString("BB4009"));
        }
        Bridge bridge = null;
        if (string != null) {
            bridge = this._bridges.get(string);
            if (bridge == null) {
                throw new BridgeException(_bmr.getKString("BB4006", string));
            }
            if (string2 != null && !string2.equals(bridge.getType())) {
                Object[] objectArray = new String[]{string, bridge.getType(), string2};
                throw new BridgeException(_bmr.getKString("BB4007", objectArray));
            }
            this.resumeBridge(bridge, stringArray);
            return;
        }
        for (Map.Entry<String, Bridge> entry : this._bridges.entrySet()) {
            bridge = entry.getValue();
            if (string2 != null && !bridge.getType().equals(string2)) continue;
            this.resumeBridge(bridge, stringArray);
        }
    }

    public synchronized void pauseBridge(Bridge bridge, String[] stringArray) throws Exception {
        this._bc.logInfo(_bmr.getString("BB1008", bridge.getName()), null);
        if (bridge.getState() == Bridge.State.PAUSED && stringArray == null) {
            this._bc.logInfo(_bmr.getString("BB1006", bridge.getName()), null);
            return;
        }
        bridge.pause(new BridgeContext(this._bc, bridge.getName()), stringArray);
        this._bc.logInfo(_bmr.getString("BB1007", bridge.getName()), null);
    }

    public synchronized void resumeBridge(Bridge bridge, String[] stringArray) throws Exception {
        this._bc.logInfo(_bmr.getString("BB1010", bridge.getName()), null);
        if (bridge.getState() == Bridge.State.STARTED && stringArray == null) {
            this._bc.logInfo(_bmr.getString("BB1011", bridge.getName()), null);
            return;
        }
        bridge.resume(new BridgeContext(this._bc, bridge.getName()), stringArray);
        this._bc.logInfo(_bmr.getString("BB1009", bridge.getName()), null);
    }

    public synchronized void unloadBridge(String string) throws Exception {
        this._bc.logInfo("Unloading bridge " + string, null);
        Bridge bridge = this._bridges.get(string);
        if (bridge == null) {
            this._bc.logInfo("Bridge " + string + " is not loaded.", null);
            throw new BridgeException("Bridge " + string + " is not loaded.", 304);
        }
        this.stopBridge(string, null, null);
        this._bridges.remove(string);
        bridge.setName(null);
        Properties properties = this._bc.getBridgeConfig();
        List<String> list = BridgeUtil.getListProperty(properties.getProperty("PROP_PREFIX") + ".activelist", properties);
        String string22 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string22 : list) {
            if (string22.equals(string)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string22);
        }
        Properties properties2 = new Properties();
        properties2.setProperty(properties.getProperty("PROP_PREFIX") + ".activelist", stringBuffer.toString());
        this._bc.updateBridgeConfig(properties2);
        this._bc.logInfo("Unloaded bridge " + string, null);
    }

    private void stopBridge(Bridge bridge, String[] stringArray) throws Exception {
        if (bridge.getState() == Bridge.State.STOPPED && stringArray == null) {
            this._bc.logDebug(_bmr.getString("BB1012", bridge.getName()), null);
            return;
        }
        this._bc.logInfo(_bmr.getString("BB1013", bridge.getName()), null);
        bridge.stop(new BridgeContext(this._bc, bridge.getName()), stringArray);
        this._bc.logInfo(_bmr.getString("BB1014", bridge.getName()), null);
    }

    public synchronized ArrayList<BridgeCmdSharedReplyData> listBridge(String string, String[] stringArray, String string2, BridgeManagerResources bridgeManagerResources) throws Exception {
        if (string2 != null && !string2.equals("JMS") && !string2.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getString("BB4005", string2));
        }
        if (string == null) {
            this._bc.logDebug("Listing all bridges (type=" + string2 + ")", null);
            BridgeCmdSharedReplyData bridgeCmdSharedReplyData = new BridgeCmdSharedReplyData(3, 4, "-");
            Object[] objectArray = new String[]{bridgeManagerResources.getString("BS1000"), bridgeManagerResources.getString("BS1001"), bridgeManagerResources.getString("BS1002")};
            bridgeCmdSharedReplyData.addTitle((String[])objectArray);
            Bridge bridge = null;
            for (Map.Entry<String, Bridge> entry : this._bridges.entrySet()) {
                bridge = entry.getValue();
                if (string2 != null && !bridge.getType().equals(string2)) continue;
                objectArray[0] = bridge.getName();
                objectArray[1] = bridge.getType();
                objectArray[2] = bridge.getState().toString((ResourceBundle)bridgeManagerResources);
                bridgeCmdSharedReplyData.add(objectArray);
            }
            this._bc.logDebug("Listed all bridges (type=" + string2 + ")", null);
            ArrayList arrayList = new ArrayList();
            arrayList.add(bridgeCmdSharedReplyData);
            return arrayList;
        }
        if (stringArray == null) {
            this._bc.logInfo(_bmr.getString("BB1015", string), null);
        } else {
            this._bc.logInfo(_bmr.getString("BB1016", string, BridgeContext.toString(stringArray)), null);
        }
        Bridge bridge = this._bridges.get(string);
        if (bridge == null) {
            String string3 = _bmr.getKString("BB4006", string);
            this._bc.logError(string3, null);
            throw new BridgeException(string3);
        }
        BridgeContext bridgeContext = new BridgeContext(this._bc, bridge.getName());
        return bridge.list(bridgeContext, stringArray, bridgeManagerResources);
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this._bc == null) {
            throw new BridgeException(_bmr.getString("BB4004"));
        }
        this._state = State.STOPPING;
        try {
            this.stopBridge(null, null, null);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RejectedExecutionException) {
                this._bc.logDebug(_bmr.getKString("BB2000", throwable.getMessage()), null);
            }
            this._bc.logWarn(_bmr.getKString("BB2000", throwable.getMessage()), throwable);
        }
        if (this._connection != null) {
            try {
                this._connection.close();
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    this._bc.logWarn(_bmr.getKString("BB2001", throwable.getMessage()), throwable);
                }
                this._bc.logWarn(_bmr.getKString("BB2001", throwable.getMessage()), null);
            }
        }
        this._state = State.STOPPED;
    }

    public Bridge getBridge(String string) throws Exception {
        Bridge bridge = this._bridges.get(string);
        if (bridge == null) {
            throw new BridgeException(_bmr.getKString("BB4006", string));
        }
        return bridge;
    }

    @Override
    public BridgeBaseContext getBridgeBaseContext() {
        return this._bc;
    }

    public void onException(JMSException jMSException) {
        if (this._bc.isEmbeded()) {
            this._bc.logError(_bmr.getKString("BB3005", jMSException.getMessage()), jMSException);
        } else {
            this._bc.logError("Not supported: bridge servie manager is not embeded!", null);
        }
    }

    public void onMessage(Message message) {
        String string;
        if (this._state != State.STARTED) {
            string = _bmr.getKString("BB4003");
            this._bc.logInfo(string, null);
            this._adminHandler.sendReply(this._session, message, null, 503, string, _bmr);
        }
        if (!(message instanceof ObjectMessage)) {
            string = "Unexpected bridge admin message type: " + message.getClass().getName();
            this._bc.logError(string, null);
            this._adminHandler.sendReply(this._session, message, null, 400, string, _bmr);
            return;
        }
        this._adminHandler.handle(this._session, (ObjectMessage)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BridgeManagerResources getBridgeManagerResources() {
        if (_bmr != null) return _bmr;
        Class<BridgeServiceManagerImpl> clazz = BridgeServiceManagerImpl.class;
        synchronized (BridgeServiceManagerImpl.class) {
            if (_bmr != null) return _bmr;
            _bmr = BridgeManagerResources.getResources(Locale.getDefault());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _bmr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridgeManagerResources getBridgeManagerResources(Locale locale) {
        if (locale == null) {
            return BridgeServiceManagerImpl.getBridgeManagerResources();
        }
        BridgeManagerResources bridgeManagerResources = _bmrs.get(locale);
        if (bridgeManagerResources != null) {
            return bridgeManagerResources;
        }
        Map<Locale, BridgeManagerResources> map = _bmrs;
        synchronized (map) {
            bridgeManagerResources = _bmrs.get(locale);
            if (bridgeManagerResources == null) {
                bridgeManagerResources = BridgeManagerResources.getResources(locale);
                _bmrs.put(locale, bridgeManagerResources);
            }
            return bridgeManagerResources;
        }
    }

    public boolean getDEBUG() {
        return DEBUG;
    }

    public static void main(String[] stringArray) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNINITIALIZED,
        STOPPING,
        STOPPED,
        STARTING,
        STARTED;

    }
}

