/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public abstract class IMQService
implements Service {
    private static boolean DEBUG = false;
    protected ConnectionManager connectionList = Globals.getConnectionManager();
    private boolean serviceRunning = false;
    private boolean shuttingDown = false;
    private int state = 0;
    private int type = 0;
    protected Logger logger = Globals.getLogger();
    protected String name = null;
    private AuthCacheData authCacheData = new AuthCacheData();
    protected static final long DESTROY_WAIT_DEFAULT = 30000L;
    private long serviceDestroyWait = 30000L;
    HashMap serviceprops = null;
    private HashSet serviceress = new HashSet();

    public IMQService(String string, int n) {
        this.name = string;
        this.type = n;
    }

    protected void addServiceProp(String string, String string2) {
        if (this.serviceprops == null) {
            this.serviceprops = new HashMap();
        }
        this.serviceprops.put(string, string2);
    }

    public void resetCounters() {
        List list = this.connectionList.getConnectionList(this);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((IMQConnection)iterator.next()).resetCounters();
        }
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("name", this.name);
        hashtable.put("state", ServiceState.getString((int)this.state));
        hashtable.put("shuttingDown", String.valueOf(this.isShuttingDown()));
        if (this.serviceprops != null) {
            hashtable.put("props", new Hashtable(this.serviceprops));
        }
        hashtable.put("connections", this.connectionList.getDebugState(this));
        return hashtable;
    }

    public Hashtable getPoolDebugState() {
        return new Hashtable();
    }

    public int size() {
        List list = this.connectionList.getConnectionList(this);
        return list.size();
    }

    public List getConsumers() {
        ArrayList arrayList = new ArrayList();
        List list = this.connectionList.getConnectionList(this);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((IMQConnection)iterator.next()).getConsumers();
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public List getProducers() {
        ArrayList arrayList = new ArrayList();
        List list = this.connectionList.getConnectionList(this);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((IMQConnection)iterator.next()).getProducers();
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public Protocol getProtocol() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getServiceType() {
        return this.type;
    }

    public synchronized int getMinThreadpool() {
        return 0;
    }

    public synchronized int getMaxThreadpool() {
        return 0;
    }

    public synchronized int getActiveThreadpool() {
        return 0;
    }

    public void setPriority(int n) {
    }

    public synchronized void setMinMaxThreadpool(int n, int n2) {
    }

    public void setDestroyWaitTime(long l) {
        this.serviceDestroyWait = l;
    }

    public long getDestroyWaitTime() {
        return this.serviceDestroyWait;
    }

    public void setServiceRunning(boolean bl) {
        this.serviceRunning = bl;
    }

    public boolean isServiceRunning() {
        return this.serviceRunning;
    }

    public void setShuttingDown(boolean bl) {
        this.shuttingDown = bl;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.state != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.state = 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewConnections() throws IOException {
        if (this.state != 8 && this.state != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        IMQService iMQService = this;
        synchronized (iMQService) {
            this.setState(3);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyService() {
        if (this.getState() < 6) {
            this.stopService(true);
        }
        IMQService iMQService = this;
        synchronized (iMQService) {
            this.setState(7);
            this.notify();
        }
    }

    public void updateService(int n, int n2, int n3) throws IOException, PropertyUpdateException, BrokerException {
    }

    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    public void removeConnection(ConnectionUID connectionUID, int n, String string) {
        this.connectionList.removeConnection(connectionUID, true, n, string);
    }

    public HashMap getServiceProperties() {
        return this.serviceprops;
    }

    public boolean isDirect() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceRestriction(ServiceRestriction serviceRestriction) {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            this.serviceress.add(serviceRestriction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceRestriction(ServiceRestriction serviceRestriction) {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            this.serviceress.remove(serviceRestriction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRestriction[] getServiceRestrictions() {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            return this.serviceress.toArray(new ServiceRestriction[0]);
        }
    }
}

