/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;

public class HAMonitorService
implements ClusterListener {
    private static boolean DEBUG_HA;
    private static boolean DEBUG;
    private Logger logger = Globals.getLogger();
    private int MAX_MONITOR_DEFAULT = 3;
    private int MAX_MONITOR = Globals.getConfig().getIntProperty("imq.cluster.monitor.threshold", this.MAX_MONITOR_DEFAULT);
    private int MONITOR_TIMEOUT_DEFAULT = 30;
    private int MONITOR_TIMEOUT = Globals.getConfig().getIntProperty("imq.cluster.monitor.interval", this.MONITOR_TIMEOUT_DEFAULT) * 1000;
    private int MAX_HEARTBEAT = Globals.getConfig().getIntProperty("imq.cluster.heartbeat.threshold", 30);
    private int reaperTimeout = Globals.getConfig().getIntProperty("imq.cluster.reaptime", 300) * 1000;
    ClusterManager clusterconfig = null;
    String mybrokerid = null;
    private HAMonitorTask haMonitor = null;
    Map indoubtBrokers = Collections.synchronizedMap(new LinkedHashMap());
    volatile int heartbeatMissedCnt = 0;
    FaultInjection fi = null;
    Runnable takeoverRunnable = null;
    Object takeoverRunnableLock = new Object();
    boolean monitorBusy = false;
    private Vector takingoverTargets = new Vector();

    public HAMonitorService(String string, MQAddress mQAddress) throws IllegalStateException, BrokerException, IllegalAccessException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        DEBUG = DEBUG || this.logger.getLevel() <= 4;
        this.fi = FaultInjection.getInjection();
        this.clusterconfig = Globals.getClusterManager();
        this.clusterconfig.addEventListener(this);
        this.mybrokerid = this.clusterconfig.getLocalBroker().getBrokerName();
        this.logger.log(8, "B1206", (Object)this.mybrokerid, (Object)mQAddress);
        if (!string.equals(this.clusterconfig.getClusterId())) {
            this.logger.log(32, "B3201", (Object)string, (Object)this.clusterconfig.getClusterId());
            throw new IllegalStateException("Bad Cluster ID " + string);
        }
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        MQAddress mQAddress2 = hAClusteredBroker.getBrokerURL();
        if (!mQAddress2.equals((Object)mQAddress)) {
            this.logger.log(8, "B1207", (Object)this.mybrokerid, (Object)mQAddress);
            try {
                object4 = String.valueOf(101) + "\n";
                string2 = new PortMapperTable();
                object3 = new Socket(mQAddress2.getHostName(), mQAddress2.getPort());
                object2 = ((Socket)object3).getInputStream();
                object = ((Socket)object3).getOutputStream();
                try {
                    ((OutputStream)object).write(((String)object4).getBytes());
                    ((OutputStream)object).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string2.read((InputStream)object2);
                ((InputStream)object2).close();
                ((OutputStream)object).close();
                ((Socket)object3).close();
                PortMapperEntry portMapperEntry = string2.get("portmapper");
                String string3 = portMapperEntry.getProperty("brokerid");
                if (this.mybrokerid.equals(string3)) {
                    this.logger.log(32, "B3202", (Object)this.mybrokerid);
                    Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3202", this.mybrokerid), BrokerEvent.Type.FATAL_ERROR);
                }
            }
            catch (IOException iOException) {
                this.logger.log(4, "Unable to reach old remote broker associated with " + this.mybrokerid);
            }
            hAClusteredBroker.setBrokerURL(mQAddress);
        }
        hAClusteredBroker.updateHeartbeat(true);
        object4 = hAClusteredBroker.getState();
        string2 = hAClusteredBroker.getTakeoverBroker();
        if ((object4 == BrokerState.FAILOVER_STARTED || object4 == BrokerState.FAILOVER_PENDING) && string2 != null && string2.trim().length() != 0) {
            this.logger.log(16, "B2134", (Object)this.mybrokerid, (Object)string2);
            do {
                this.logger.log(8, "B1208");
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new BrokerException("Waiting for taking over of this broker to complete is interrupted: " + interruptedException.getMessage());
                }
                hAClusteredBroker.updateHeartbeat(true);
            } while ((object4 = hAClusteredBroker.getState()) == BrokerState.FAILOVER_STARTED || object4 == BrokerState.FAILOVER_PENDING);
        }
        if (object4 == BrokerState.FAILOVER_FAILED || object4 == BrokerState.FAILOVER_COMPLETE) {
            if (DEBUG) {
                this.logger.log(8, "Broker updates store sessionUID, state=" + object4);
            }
            try {
                hAClusteredBroker.setStoreSessionUID(hAClusteredBroker.getBrokerSessionUID());
            }
            catch (Exception exception) {
                this.logger.logStack(8, "Failed to update broker store sessionUID", (Throwable)exception);
                throw new BrokerException("Failed to update broker store sessionUID to " + hAClusteredBroker.getBrokerSessionUID() + ": " + exception.getMessage());
            }
        } else if (DEBUG) {
            this.logger.log(8, "Broker keeps old store sessionUID, state=" + object4);
        }
        Globals.setStoreSession(hAClusteredBroker.getStoreSessionUID());
        this.logger.log(8, "B1193", (Object)String.valueOf(hAClusteredBroker.getStoreSessionUID().longValue()), (Object)String.valueOf(hAClusteredBroker.getBrokerSessionUID().longValue()));
        hAClusteredBroker.resetTakeoverBroker();
        object3 = this.clusterconfig.getConfigBrokers();
        while (object3.hasNext()) {
            object2 = (HAClusteredBroker)object3.next();
            object = object2.getTakeoverBroker();
            if (object == null || !((String)object).equals(this.mybrokerid) || object2.getState() != BrokerState.FAILOVER_STARTED) continue;
            this.logger.log(8, "B1209", (Object)object2.getBrokerName());
            object2.setState(BrokerState.FAILOVER_COMPLETE);
        }
        hAClusteredBroker.setState(BrokerState.OPERATING);
        if (this.MONITOR_TIMEOUT * this.MAX_MONITOR < 90000 && DBManager.getDBManager().isHADB()) {
            this.MAX_MONITOR = this.MAX_MONITOR_DEFAULT;
            this.MONITOR_TIMEOUT = this.MONITOR_TIMEOUT_DEFAULT * 1000;
            this.logger.log(16, "The HA Monitor Service takes over a failed broker when the total monitor time (the product of imq.cluster.monitor.interval and imq.cluster.monitor.threshhold) exceeds a set value. Due to HADB limitations, that value must be at least 90 seconds. Otherwise, the broker might not reliably take over messages from a failed broker. The total current interval is lower than 90 seconds; therefore, we are resetting the default value of imq.cluster.monitor.interval to 30, and the imq.cluster.monitor.threshhold value to 3.");
        }
        this.haMonitor = new HAMonitorTask();
        try {
            new HATimerThread("HAMonitor", this.haMonitor, this.MONITOR_TIMEOUT, this.MONITOR_TIMEOUT);
        }
        catch (Exception exception) {
            this.logger.log(16, "B3100", (Object)"Unable to start monitor Timeout", (Throwable)exception);
        }
    }

    public int getMonitorInterval() {
        return this.MONITOR_TIMEOUT / 1000;
    }

    public UID getStoreSession() {
        return ((HAClusteredBroker)this.clusterconfig.getLocalBroker()).getStoreSessionUID();
    }

    public String toString() {
        return "HAMonitorService[" + this.clusterconfig.getLocalBroker() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        Object object;
        Object object2;
        Object object3;
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        if (DEBUG) {
            this.logger.log(8, "HAMonitor is updating heartbeat timestamp of [" + this.mybrokerid + "]" + this.MONITOR_TIMEOUT);
        }
        try {
            if (this.fi.FAULT_INJECTION) {
                this.fi.checkFaultAndThrowBrokerException("hb.sharedb", null);
            }
            hAClusteredBroker.updateHeartbeat();
            this.heartbeatMissedCnt = 0;
        }
        catch (BrokerException brokerException) {
            ++this.heartbeatMissedCnt;
            if (this.heartbeatMissedCnt < this.MAX_HEARTBEAT) {
                this.logger.logStack(16, Globals.getBrokerResources().getKString("B2192", brokerException.getMessage()), (Throwable)brokerException);
            }
            object3 = Globals.getBrokerResources().getKString("B3230", this.MAX_HEARTBEAT);
            this.logger.logStack(32, (String)object3, (Throwable)brokerException);
            Broker.getBroker().exit(BrokerStateHandler.getRestartCode(), (String)object3, BrokerEvent.Type.RESTART, brokerException, true, false, false);
        }
        try {
            object2 = hAClusteredBroker.getState();
            if (object2 == BrokerState.QUIESCE_STARTED || object2 == BrokerState.QUIESCE_COMPLETED || object2 == BrokerState.FAILOVER_PENDING || object2 == BrokerState.FAILOVER_FAILED || object2 == BrokerState.SHUTDOWN_STARTED || object2 == BrokerState.SHUTDOWN_FAILOVER || object2 == BrokerState.SHUTDOWN_COMPLETE) {
                return;
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "B4117", (Object)brokerException.getMessage(), (Throwable)brokerException);
        }
        if (this.indoubtBrokers.size() > 0) {
            this.logger.log(8, "B1210", (Object)String.valueOf(this.indoubtBrokers.size()));
        }
        object2 = null;
        object3 = new HashSet(this.indoubtBrokers.keySet());
        Object object4 = this.takeoverRunnableLock;
        synchronized (object4) {
            this.monitorBusy = true;
        }
        try {
            object4 = object3.iterator();
            while (object4.hasNext()) {
                Object e = object4.next();
                indoubtData indoubtData2 = (indoubtData)this.indoubtBrokers.get(e);
                try {
                    HAClusteredBroker hAClusteredBroker2 = (HAClusteredBroker)this.clusterconfig.getBroker(indoubtData2.brokerid);
                    BrokerState brokerState = hAClusteredBroker2.getState();
                    long l = hAClusteredBroker2.getHeartbeat();
                    if (brokerState == BrokerState.SHUTDOWN_COMPLETE) {
                        this.logger.log(8, "B1211", (Object)indoubtData2.brokerid);
                        hAClusteredBroker2.setBrokerIsUp(false, null);
                        this.indoubtBrokers.remove(e);
                        object4.remove();
                        continue;
                    }
                    if (brokerState == BrokerState.FAILOVER_STARTED || brokerState == BrokerState.FAILOVER_COMPLETE) {
                        this.logger.log(8, "B1212", (Object)indoubtData2.brokerid);
                        hAClusteredBroker2.setBrokerIsUp(false, null);
                        this.indoubtBrokers.remove(e);
                        object4.remove();
                        continue;
                    }
                    if (l > indoubtData2.lastts && brokerState != BrokerState.FAILOVER_PENDING) {
                        this.logger.log(8, "B1213", (Object)hAClusteredBroker2.getBrokerName());
                        hAClusteredBroker2.setBrokerInDoubt(false, null);
                        this.indoubtBrokers.remove(e);
                        object4.remove();
                        continue;
                    }
                    ++indoubtData2.monitorCnt;
                    if (indoubtData2.monitorCnt >= this.MAX_MONITOR || brokerState == BrokerState.SHUTDOWN_FAILOVER) {
                        this.logger.log(8, "B1214", (Object)hAClusteredBroker2.getBrokerName());
                        if (this.takeoverRunnable != null) {
                            this.logger.log(8, "B1296", (Object)hAClusteredBroker2.getBrokerName());
                            continue;
                        }
                        if (object2 == null) {
                            object2 = new ArrayList();
                        }
                        ((ArrayList)object2).add(hAClusteredBroker2);
                        hAClusteredBroker2.setBrokerIsUp(false, null);
                        object4.remove();
                        this.indoubtBrokers.remove(e);
                        continue;
                    }
                    this.logger.log(8, "B1215", (Object)hAClusteredBroker2.getBrokerName());
                }
                catch (Exception exception) {
                    this.logger.logStack(8, "B3100", (Object)("Unable to monitor broker " + indoubtData2.brokerid), (Throwable)exception);
                }
            }
            if (object2 != null) break block32;
            Object var12_14 = null;
            object = this.takeoverRunnableLock;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            Object object5 = this.takeoverRunnableLock;
            synchronized (object5) {
                this.monitorBusy = false;
                this.takeoverRunnableLock.notify();
            }
            throw throwable;
        }
        synchronized (object) {
            this.monitorBusy = false;
            this.takeoverRunnableLock.notify();
        }
        {
            block32: {
                return;
            }
            if (this.takeoverRunnable == null) break block33;
            this.logger.log(32, "B3100", (Object)Globals.getBrokerResources().getString("B1296", object2));
        }
        Object var12_15 = null;
        Object object6 = this.takeoverRunnableLock;
        synchronized (object6) {
            this.monitorBusy = false;
            this.takeoverRunnableLock.notify();
        }
        {
            block33: {
                return;
            }
            this.takeoverRunnable = new TakeoverThread((ArrayList)object2, false, false);
        }
        Object var12_16 = null;
        Object object7 = this.takeoverRunnableLock;
        synchronized (object7) {
            this.monitorBusy = false;
            this.takeoverRunnableLock.notify();
        }
        object4 = new Thread(this.takeoverRunnable, "Takeover");
        ((Thread)object4).start();
    }

    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTakeover() {
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            return this.takeoverRunnable != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverBroker(HAClusteredBroker hAClusteredBroker, boolean bl) throws BrokerException {
        ArrayList<HAClusteredBroker> arrayList = new ArrayList<HAClusteredBroker>();
        arrayList.add(hAClusteredBroker);
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            while (this.monitorBusy || this.takeoverRunnable != null) {
                try {
                    this.takeoverRunnableLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.takeoverRunnable = new TakeoverThread(arrayList, bl, true);
        }
        try {
            ((TakeoverThread)this.takeoverRunnable).doTakeover();
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException(exception.getMessage(), exception, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTakingoverDestination(Destination destination) {
        if (this.takingoverTargets.size() == 0) {
            return false;
        }
        TakingoverTracker takingoverTracker2 = null;
        Iterator iterator = null;
        Vector vector = this.takingoverTargets;
        synchronized (vector) {
            for (TakingoverTracker takingoverTracker2 : this.takingoverTargets) {
                if (!takingoverTracker2.containDestination(destination)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTakingoverMessage(Packet packet) {
        TakingoverTracker takingoverTracker2 = null;
        Iterator iterator = null;
        Vector vector = this.takingoverTargets;
        synchronized (vector) {
            for (TakingoverTracker takingoverTracker2 : this.takingoverTargets) {
                if (!takingoverTracker2.containMessage(packet)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchBroker(String string) throws BrokerException {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            if (this.indoubtBrokers.get(string) != null) {
                return;
            }
            indoubtData indoubtData2 = new indoubtData();
            indoubtData2.brokerid = string;
            indoubtData2.lastts = ((HAClusteredBroker)this.clusterconfig.getBroker(string)).getHeartbeat();
            indoubtData2.monitorCnt = 0;
            this.indoubtBrokers.put(string, indoubtData2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWatchingBroker(String string) {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            this.indoubtBrokers.remove(string);
        }
    }

    public void clusterPropertyChanged(String string, String string2) {
    }

    public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
    }

    public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
        this.logger.log(4, "brokerStatusChanged " + string + ":" + "\n\t" + BrokerStatus.toString(n) + "\n\t" + BrokerStatus.toString(n2) + "\n\t" + object);
        if (BrokerStatus.getBrokerInDoubt(n2) && BrokerStatus.getBrokerIsUp(n2)) {
            ClusteredBroker clusteredBroker = this.clusterconfig.getBroker(string);
            if (clusteredBroker.isLocalBroker()) {
                return;
            }
            try {
                BrokerState brokerState = clusteredBroker.getState();
                if (brokerState == BrokerState.SHUTDOWN_COMPLETE || brokerState == BrokerState.FAILOVER_COMPLETE) {
                    this.logger.log(8, "B1213", (Object)clusteredBroker.getBrokerName());
                    clusteredBroker.setBrokerIsUp(false, null);
                    return;
                }
                this.logger.log(8, "B1288", (Object)string);
                this.watchBroker(string);
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3100", (Object)("Unable to monitor broker " + string), (Throwable)exception);
            }
        } else if (BrokerStatus.getBrokerInDoubt(n) && BrokerStatus.getBrokerIsUp(n2)) {
            this.stopWatchingBroker(string);
        }
    }

    public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
        ClusteredBroker clusteredBroker = this.clusterconfig.getBroker(string);
        if (clusteredBroker.isLocalBroker() && (brokerState2 == BrokerState.SHUTDOWN_COMPLETE || brokerState2 == BrokerState.SHUTDOWN_FAILOVER)) {
            this.haMonitor.cancel();
            this.clusterconfig.removeEventListener(this);
        }
    }

    public void brokerVersionChanged(String string, int n, int n2) {
    }

    public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
    }

    static {
        DEBUG = DEBUG_HA = Globals.getConfig().getBooleanProperty("imq.ha.debug");
    }

    class TakeoverThread
    implements Runnable {
        ArrayList downBkrs = null;
        boolean force = false;
        boolean throwex = false;

        public TakeoverThread(ArrayList arrayList, boolean bl, boolean bl2) {
            this.downBkrs = arrayList;
            this.force = bl;
            this.throwex = bl2;
        }

        public void run() {
            try {
                this.doTakeover();
            }
            catch (Exception exception) {
                Logger logger = HAMonitorService.this.logger;
                HAMonitorService.this.logger;
                logger.log(16, "Unexpected exception " + exception.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doTakeover() throws Exception {
            Object object;
            try {
                ClusterBroadcast clusterBroadcast = Globals.getClusterBroadcast();
                while (clusterBroadcast == null) {
                    HAMonitorService.this.logger.log(8, "B1264");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    clusterBroadcast = Globals.getClusterBroadcast();
                }
                Iterator iterator = this.downBkrs.iterator();
                while (iterator.hasNext()) {
                    Object var22_31;
                    HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)iterator.next();
                    HAMonitorService.this.logger.log(8, "B1216", (Object)hAClusteredBroker.getBrokerName());
                    TakingoverTracker takingoverTracker = null;
                    boolean bl = false;
                    try {
                        Object object2;
                        Object object3;
                        Object object4;
                        try {
                            Object[] objectArray;
                            Object object5;
                            TransactionState transactionState;
                            Externalizable externalizable;
                            clusterBroadcast.preTakeover(hAClusteredBroker.getBrokerName(), hAClusteredBroker.getStoreSessionUID(), ((BrokerMQAddress)hAClusteredBroker.getBrokerURL()).getHost().getHostAddress(), hAClusteredBroker.getBrokerSessionUID());
                            takingoverTracker = new TakingoverTracker(hAClusteredBroker, Thread.currentThread());
                            HAMonitorService.this.takingoverTargets.add(takingoverTracker);
                            TakeoverStoreInfo takeoverStoreInfo = hAClusteredBroker.takeover(this.force, takingoverTracker);
                            takingoverTracker.setStage_BEFORE_PROCESSING();
                            HAMonitorService.this.logger.log(8, "B1217", (Object)hAClusteredBroker.getBrokerName());
                            object4 = takeoverStoreInfo.getMessageMap();
                            object3 = takeoverStoreInfo.getTransactionList();
                            object2 = takeoverStoreInfo.getRemoteTransactionList();
                            HAMonitorService.this.logger.log(8, "B1218", (Object)hAClusteredBroker.getBrokerName(), (Object)String.valueOf(object3 == null ? 0 : object3.size()));
                            HAMonitorService.this.logger.log(8, "B1297", (Object)hAClusteredBroker.getBrokerName(), (Object)String.valueOf(object2 == null ? 0 : object2.size()));
                            Destination.remoteCheckTakeoverMsgs((Map)object4, hAClusteredBroker.getBrokerName());
                            ArrayList<Externalizable> arrayList = new ArrayList<Externalizable>();
                            Iterator iterator2 = object3.iterator();
                            while (iterator2.hasNext()) {
                                boolean bl2 = false;
                                externalizable = (TransactionUID)iterator2.next();
                                transactionState = Globals.getStore().getTransactionState((TransactionUID)externalizable);
                                if (transactionState == null) {
                                    iterator2.remove();
                                    continue;
                                }
                                object5 = transactionState.getType();
                                int n = transactionState.getState();
                                if (n == 7) {
                                    HAMonitorService.this.logger.log(8, "XXX - DEBUG Rolling back  transaction " + externalizable);
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                if (n == 6) {
                                    HAMonitorService.this.logger.log(8, "XXX - DEBUG Committing  transaction " + externalizable);
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                if (object5 == AutoRollbackType.ALL) {
                                    Object[] objectArray2 = new String[3];
                                    objectArray2[0] = hAClusteredBroker.getBrokerName();
                                    objectArray2[1] = String.valueOf(externalizable.longValue());
                                    objectArray2[2] = TransactionState.toString(transactionState.getState());
                                    objectArray = objectArray2;
                                    HAMonitorService.this.logger.log(8, "B1220", objectArray);
                                    transactionState.setState(7);
                                    try {
                                        Globals.getStore().updateTransactionState((TransactionUID)externalizable, transactionState, Destination.PERSIST_SYNC);
                                    }
                                    catch (IOException iOException) {
                                        throw new BrokerException(null, iOException);
                                    }
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                if (transactionState.getType() == AutoRollbackType.NOT_PREPARED && transactionState.getState() < 5) {
                                    String[] stringArray = new String[3];
                                    stringArray[0] = hAClusteredBroker.getBrokerName();
                                    stringArray[1] = String.valueOf(externalizable.longValue());
                                    stringArray[2] = TransactionState.toString(transactionState.getState());
                                    objectArray = stringArray;
                                    HAMonitorService.this.logger.log(8, "B1219", objectArray);
                                    transactionState.setState(7);
                                    try {
                                        Globals.getStore().updateTransactionState((TransactionUID)externalizable, transactionState, Destination.PERSIST_SYNC);
                                    }
                                    catch (IOException iOException) {
                                        throw new BrokerException(null, iOException);
                                    }
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                String[] stringArray = new String[3];
                                stringArray[0] = hAClusteredBroker.getBrokerName();
                                stringArray[1] = String.valueOf(externalizable.longValue());
                                stringArray[2] = TransactionState.toString(transactionState.getState());
                                objectArray = stringArray;
                                HAMonitorService.this.logger.log(8, "B1298", objectArray);
                            }
                            TransactionUID transactionUID = null;
                            externalizable = null;
                            transactionState = null;
                            object5 = Globals.getTransactionList();
                            iterator2 = object2.iterator();
                            while (iterator2.hasNext()) {
                                transactionUID = (TransactionUID)iterator2.next();
                                try {
                                    externalizable = Globals.getStore().getTransactionState(transactionUID);
                                }
                                catch (Exception exception) {
                                    Logger logger = HAMonitorService.this.logger;
                                    HAMonitorService.this.logger;
                                    logger.log(16, "Unable to get transaction state " + transactionUID + " for takenover broker " + hAClusteredBroker.getBrokerName());
                                    continue;
                                }
                                if (externalizable == null) continue;
                                try {
                                    if (((TransactionState)externalizable).getState() >= 5 || ((TransactionList)object5).retrieveState(transactionUID) == null || !((TransactionList)object5).isClusterTransactionBroker(transactionUID, hAClusteredBroker) || (transactionState = ((TransactionList)object5).retrieveState(transactionUID)) == null) continue;
                                    transactionState = new TransactionState(transactionState);
                                    ((TransactionList)object5).updateState(transactionUID, transactionState.nextState(48, null), transactionState.getState(), true);
                                    Logger logger = HAMonitorService.this.logger;
                                    HAMonitorService.this.logger;
                                    logger.log(8, "Remote transaction " + transactionUID + "(" + TransactionState.toString(((TransactionState)externalizable).getState()) + ") from takenover broker " + hAClusteredBroker + " will be rolledback");
                                }
                                catch (Exception exception) {
                                    Logger logger = HAMonitorService.this.logger;
                                    HAMonitorService.this.logger;
                                    logger.log(16, "Unable to set ROLLBACK state to transaction " + transactionUID + ":" + exception.getMessage() + " for takenover broker " + hAClusteredBroker.getBrokerName());
                                }
                            }
                            TakeoverReaper takeoverReaper = new TakeoverReaper(hAClusteredBroker.getBrokerName(), arrayList);
                            objectArray = Globals.getTransactionList().loadTakeoverTxns((List)object3, (List)object2, (Map)object4);
                            HAMonitorService.this.logger.log(8, "B1221", (Object)hAClusteredBroker.getBrokerName(), (Object)String.valueOf(object4 == null ? 0 : object4.size()));
                            Destination.loadTakeoverMsgs((Map)object4, (List)object3, (Map)objectArray);
                            takingoverTracker.setStage_AFTER_PROCESSING();
                            HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                            Globals.getTransactionList().unlockTakeoverTxns((List)object3);
                            boolean bl3 = takeoverReaper.processTxns();
                            MQTimer mQTimer = Globals.getTimer();
                            try {
                                if (!bl3) {
                                    mQTimer.schedule((TimerTask)takeoverReaper, (long)HAMonitorService.this.reaperTimeout, (long)HAMonitorService.this.reaperTimeout);
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                HAMonitorService.this.logger.logStack(16, "B3100", (Object)"Unable to start takeover-transaction reaper", (Throwable)illegalStateException);
                            }
                            hAClusteredBroker.setBrokerIsUp(false, null);
                            hAClusteredBroker.setState(BrokerState.FAILOVER_COMPLETE);
                            bl = true;
                            Logger logger = HAMonitorService.this.logger;
                            HAMonitorService.this.logger;
                            logger.log(8, "B1223", (Object)hAClusteredBroker.getBrokerName());
                            iterator.remove();
                        }
                        catch (Exception exception) {
                            if (exception instanceof TakeoverLockException) {
                                object4 = null;
                                object3 = null;
                                object2 = ((TakeoverLockException)exception).getBrokerInfo();
                                if (object2 == null) {
                                    try {
                                        object4 = hAClusteredBroker.getState();
                                        object3 = hAClusteredBroker.getTakeoverBroker();
                                    }
                                    catch (BrokerException brokerException) {}
                                } else {
                                    object4 = BrokerState.getState(((HABrokerInfo)object2).getState());
                                    object3 = ((HABrokerInfo)object2).getTakeoverBrokerID();
                                }
                                if (object4 == BrokerState.FAILOVER_STARTED || object4 == BrokerState.FAILOVER_PENDING || object4 == BrokerState.FAILOVER_COMPLETE) {
                                    if (object3 != null) {
                                        HAMonitorService.this.logger.log(8, "B3231", (Object)hAClusteredBroker.getBrokerName(), (Object)("Broker is being taken over by " + (String)object3));
                                    } else {
                                        HAMonitorService.this.logger.log(32, "B1191");
                                    }
                                } else {
                                    HAMonitorService.this.logger.log(32, "B3231", (Object)hAClusteredBroker.getBrokerName(), (Object)("Takeover lock error (state=" + object4 + ", takeoverBroker=" + (String)object3 + ")"), (Throwable)exception);
                                }
                                try {
                                    hAClusteredBroker.setState(BrokerState.FAILOVER_FAILED);
                                }
                                catch (Exception exception2) {
                                    HAMonitorService.this.logger.logStack(32, "B3044", (Throwable)exception2);
                                }
                            } else if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() == 409) {
                                HAMonitorService.this.logger.log(8, exception.getMessage());
                            } else {
                                HAMonitorService.this.logger.logStack(32, "B3231", (Object)hAClusteredBroker.getBrokerName(), (Object)exception.getMessage(), (Throwable)exception);
                            }
                            hAClusteredBroker.setBrokerIsUp(false, null);
                            if (this.throwex) {
                                throw exception;
                            }
                            var22_31 = null;
                            clusterBroadcast.postTakeover(hAClusteredBroker.getBrokerName(), hAClusteredBroker.getStoreSessionUID(), !bl);
                            if (takingoverTracker == null || takingoverTracker.getStage() >= 4) continue;
                            HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                            continue;
                        }
                        var22_31 = null;
                        clusterBroadcast.postTakeover(hAClusteredBroker.getBrokerName(), hAClusteredBroker.getStoreSessionUID(), !bl);
                        if (takingoverTracker == null || takingoverTracker.getStage() >= 4) continue;
                        HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                    }
                    catch (Throwable throwable) {
                        var22_31 = null;
                        clusterBroadcast.postTakeover(hAClusteredBroker.getBrokerName(), hAClusteredBroker.getStoreSessionUID(), !bl);
                        if (takingoverTracker == null) throw throwable;
                        if (takingoverTracker.getStage() >= 4) throw throwable;
                        HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                        throw throwable;
                    }
                }
                Object var24_33 = null;
                object = HAMonitorService.this.takeoverRunnableLock;
            }
            catch (Throwable throwable) {
                Object var24_34 = null;
                Object object6 = HAMonitorService.this.takeoverRunnableLock;
                synchronized (object6) {
                    HAMonitorService.this.takeoverRunnable = null;
                    HAMonitorService.this.takeoverRunnableLock.notify();
                    throw throwable;
                }
            }
            synchronized (object) {
                HAMonitorService.this.takeoverRunnable = null;
                HAMonitorService.this.takeoverRunnableLock.notify();
                return;
            }
        }
    }

    class TakeoverReaper
    extends TimerTask {
        List txns = null;
        String id = null;
        long time = 0L;

        public TakeoverReaper(String string, List list) {
            this.txns = list;
            this.id = string;
            Logger logger = HAMonitorService.this.logger;
            HAMonitorService.this.logger;
            logger.log(4, "monitoring " + list.size() + " transactions");
        }

        public void run() {
            boolean bl = this.processTxns();
            if (bl) {
                this.cancel();
            }
        }

        public boolean processTxns() {
            try {
                Iterator iterator = this.txns.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    TransactionState transactionState;
                    TransactionUID transactionUID;
                    block9: {
                        transactionUID = (TransactionUID)iterator.next();
                        transactionState = null;
                        try {
                            transactionState = Globals.getStore().getTransactionState(transactionUID);
                            if (transactionState != null && transactionState.getState() == 6) {
                                Globals.getTransactionList().reapTakeoverCommittedTransaction(transactionUID);
                                iterator.remove();
                            }
                            break block9;
                        }
                        catch (BrokerException brokerException) {
                            Globals.getTransactionList().removeTransactionAck(transactionUID);
                            Globals.getTransactionList().removeTransactionID(transactionUID);
                            iterator.remove();
                        }
                        continue;
                    }
                    int n = transactionState.getState();
                    int n2 = 0;
                    int n3 = 0;
                    try {
                        object = Globals.getStore().getTransactionUsageInfo(transactionUID);
                        n2 = object[0];
                        n3 = object[1];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != 7 && n != 5 && n != 6 || n2 == 0 && n3 == 0) {
                        HAMonitorService.this.logger.log(DEBUG ? 8 : 4, "Removing finished transaction " + transactionUID);
                        object = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
                        ((TransactionHandler)object).doRollback(transactionUID, null, null, transactionState, null, null, RollbackReason.TAKEOVER_CLEANUP);
                        iterator.remove();
                        continue;
                    }
                    if (n != 7) continue;
                }
            }
            catch (Exception exception) {
                HAMonitorService.this.logger.logStack(16, "B3100", (Object)"removing reaped destinations", (Throwable)exception);
            }
            return this.txns.size() == 0;
        }
    }

    class HATimerThread
    implements Runnable {
        long nexttime = 0L;
        long repeatItr = 0L;
        Thread thr = null;
        Runnable child = null;

        public HATimerThread(String string, Runnable runnable, int n, int n2) {
            this.nexttime = (long)n + System.currentTimeMillis();
            this.repeatItr = n2;
            this.child = runnable;
            this.thr = new Thread((Runnable)this, string);
            this.thr.setPriority(10);
            this.thr.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                HATimerThread hATimerThread = this;
                synchronized (hATimerThread) {
                    if (l < this.nexttime) {
                        try {
                            this.wait(this.nexttime - l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.child.run();
                }
                if (this.repeatItr == 0L) break;
                this.nexttime += this.repeatItr;
            }
        }
    }

    class HAMonitorTask
    implements Runnable {
        boolean valid = true;

        public void cancel() {
            this.valid = false;
        }

        public void run() {
            if (!this.valid) {
                return;
            }
            HAMonitorService.this.monitor();
        }
    }

    class indoubtData {
        String brokerid;
        long lastts = 0L;
        int monitorCnt = 0;

        indoubtData() {
        }
    }
}

