/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.LocalTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransaction1PCommitEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransaction2PCompleteEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransaction2PPrepareEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.HashSet;

public class LocalTransactionManager
extends BaseTransactionManager {
    LocalTransactionManager(TransactionLogManager transactionLogManager) {
        super(transactionLogManager);
    }

    void processStoredTxnOnStartup(BaseTransaction baseTransaction) {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " processStoredTxnOnStartup " + baseTransaction;
            logger.log(4, (String)object);
        }
        object = baseTransaction.getTid();
        int n = baseTransaction.getState();
        if (n == 6 || n == 7) {
            this.addToCompleteStored(baseTransaction);
        } else if (n == 5) {
            this.addToIncompleteStored(baseTransaction);
        }
    }

    void replayTransactionEvent(TransactionEvent transactionEvent, HashSet hashSet) throws BrokerException, IOException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " replayTransactionEvent");
        }
        LocalTransactionEvent localTransactionEvent = (LocalTransactionEvent)transactionEvent;
        LocalTransaction localTransaction = localTransactionEvent.localTransaction;
        int n = localTransaction.getState();
        TransactionUID transactionUID = localTransaction.getTid();
        if (localTransactionEvent.getSubType() == 0) {
            this.transactionLogManager.transactionLogReplayer.replayTransactionWork(localTransaction.getTransactionWork(), transactionUID, hashSet);
        } else if (localTransactionEvent.getSubType() == 1) {
            if (this.incompleteStored.containsKey(transactionUID)) {
                if (Store.getDEBUG()) {
                    String string = this.getPrefix() + " found matching txn in prepared store on replay " + localTransaction;
                    Globals.getLogger().log(4, string);
                }
            } else {
                this.addToIncompleteUnstored(localTransaction);
            }
        } else if (localTransactionEvent.getSubType() == 2) {
            BaseTransaction baseTransaction = null;
            if (this.incompleteUnstored.containsKey(transactionUID)) {
                baseTransaction = this.removeFromIncompleteUnstored(transactionUID);
            } else if (this.incompleteStored.containsKey(transactionUID)) {
                baseTransaction = this.removeFromIncompleteStored(transactionUID);
                this.updateStoredState(transactionUID, n);
                this.addToCompleteStored(baseTransaction);
            } else if (this.completeStored.containsKey(transactionUID)) {
                baseTransaction = (BaseTransaction)this.completeStored.get(transactionUID);
            }
            if (baseTransaction != null) {
                if (n == 6) {
                    this.transactionLogManager.transactionLogReplayer.replayTransactionWork(baseTransaction.getTransactionWork(), transactionUID, hashSet);
                }
            } else {
                logger.log(32, "Could not find prepared work for completing two-phase transaction " + localTransaction.getTid());
            }
        }
    }

    TransactionEvent generateEvent(BaseTransaction baseTransaction, boolean bl) throws IOException, BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " generateEvent " + baseTransaction;
            logger.log(4, (String)object);
        }
        object = null;
        if (bl) {
            object = new LocalTransaction2PCompleteEvent();
        } else if (baseTransaction.getState() == 6) {
            object = new LocalTransaction1PCommitEvent();
        } else if (baseTransaction.getState() == 5) {
            object = new LocalTransaction2PPrepareEvent();
        }
        ((LocalTransactionEvent)object).localTransaction = (LocalTransaction)baseTransaction;
        return object;
    }

    void processTxn(BaseTransaction baseTransaction) throws IOException, BrokerException {
        int n;
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " processTxn " + baseTransaction;
            logger.log(4, string);
        }
        if ((n = baseTransaction.getState()) == 6) {
            this.playingToMessageStore.add(baseTransaction.getTid());
            this.messageListLogged(baseTransaction);
        } else if (n == 5) {
            this.addToIncompleteUnstored(baseTransaction);
        }
    }

    BaseTransaction processTxnCompletion(TransactionUID transactionUID, int n) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " processTxnCompletion " + transactionUID;
            logger.log(4, string);
        }
        boolean bl = true;
        return this.processTxnCompletion(transactionUID, n, bl);
    }

    String getPrefix() {
        return "LocalTransactionManager: " + Thread.currentThread().getName();
    }
}

