/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MessageManagerConfig
extends MQMBeanReadWrite {
    private static MBeanParameterInfo[] deleteMessageSignature;
    private static MBeanParameterInfo[] replaceMessageSignature;
    private static MBeanOperationInfo[] ops;

    public void deleteMessage(String string, String string2, String string3) throws MBeanException {
        try {
            if (string2 == null || string == null) {
                throw new BrokerException("Destination name and type not specified");
            }
            Destination destination = Destination.getDestination(string2, string.equals("q"));
            if (destination == null) {
                throw new BrokerException(rb.getString("B4017", string2));
            }
            if (string3 == null) {
                throw new BrokerException("Message ID not specified");
            }
            SysMessageID sysMessageID = SysMessageID.get((String)string3);
            PacketReference packetReference = Destination.get(sysMessageID);
            if (packetReference == null) {
                throw new BrokerException("Could not locate message " + string3 + " in destination " + string2);
            }
            destination.removeMessage(sysMessageID, RemoveReason.REMOVED_OTHER);
            this.logger.log(8, "Deleted from destination " + string2 + " message with ID: " + string3);
        }
        catch (Exception exception) {
            this.handleOperationException("deleteMessage", exception);
        }
    }

    public String replaceMessage(String string, String string2, String string3, HashMap hashMap) throws MBeanException {
        String string4 = null;
        try {
            if (string2 == null || string == null) {
                throw new BrokerException("Destination name and type not specified");
            }
            Destination destination = Destination.getDestination(string2, string.equals("q"));
            if (destination == null) {
                throw new BrokerException(rb.getString("B4017", string2));
            }
            if (string3 == null) {
                throw new BrokerException("Message ID not specified");
            }
            if (hashMap == null) {
                throw new BrokerException("New message body not specified");
            }
            destination.load();
            SysMessageID sysMessageID = SysMessageID.get((String)string3);
            PacketReference packetReference = Destination.get(sysMessageID);
            if (packetReference != null) {
                Integer n;
                int n2 = packetReference.getPacket().getPacketType();
                if (n2 != (n = (Integer)hashMap.get("MessageBodyType"))) {
                    throw new BrokerException("Existing message and new message types do not match.");
                }
                byte[] byArray = this.getBytesFromMessage(hashMap);
                string4 = destination.replaceMessageString(sysMessageID, null, byArray);
                if (string4 == null) {
                    throw new BrokerException("New message ID not returned as expected.");
                }
            } else {
                throw new BrokerException("Could not locate message " + string3 + " in destination " + string2);
            }
            this.logger.log(8, "Replaced from destination " + string2 + " old message with ID: " + sysMessageID + " with new message with ID: " + string4);
        }
        catch (Exception exception) {
            this.handleOperationException("replaceMessage", exception);
        }
        return string4;
    }

    public String getMBeanName() {
        return "MessageManagerConfig";
    }

    public String getMBeanDescription() {
        return "Configuration MBean for Message Manager";
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return null;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    private byte[] getBytesFromMessage(HashMap hashMap) {
        String string = null;
        byte[] byArray = null;
        Object v = hashMap.get("MessageBody");
        Integer n = (Integer)hashMap.get("MessageBodyType");
        switch (n) {
            case 1: {
                try {
                    String string2 = (String)v;
                    byArray = string2.getBytes("UTF8");
                }
                catch (Exception exception) {
                    string = "Caught exception while creating text message body";
                    this.logger.log(32, string, (Throwable)exception);
                }
                break;
            }
            case 2: {
                byArray = (byte[])v;
                break;
            }
            case 3: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    HashMap hashMap2 = (HashMap)v;
                    objectOutputStream.writeObject(hashMap2);
                    objectOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    string = "Caught exception while creating map message body";
                    this.logger.log(32, string, (Throwable)exception);
                }
                break;
            }
            case 4: {
                byArray = (byte[])v;
                break;
            }
            case 5: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(v);
                    objectOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    string = "Caught exception while creating object message body";
                    this.logger.log(32, string, (Throwable)exception);
                }
                break;
            }
            default: {
                string = "Unsupported message type for REPLACE_MESSAGE handler: " + n;
                this.logger.log(32, string);
            }
        }
        return byArray;
    }

    static {
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[3];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray[2] = new MBeanParameterInfo("messageID", String.class.getName(), "Message ID");
        deleteMessageSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[4];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray2[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray2[2] = new MBeanParameterInfo("messageID", String.class.getName(), "Message ID");
        mBeanParameterInfoArray2[3] = new MBeanParameterInfo("messageBody", HashMap.class.getName(), "Message Body");
        replaceMessageSignature = mBeanParameterInfoArray2;
        ops = new MBeanOperationInfo[]{new MBeanOperationInfo("deleteMessage", "Delete a message in a destination", deleteMessageSignature, Void.TYPE.getName(), 1), new MBeanOperationInfo("replaceMessage", "Replace a message in a destination", replaceMessageSignature, String.class.getName(), 1)};
    }
}

