/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TxnConverter;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

class ClusterTxnConverter
extends TxnConverter {
    ClusterTxnConverter(TransactionList transactionList, Store store) {
        super(transactionList, store);
    }

    String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.ClusterTxnConverter.";
    }

    void convert(TransactionInformation transactionInformation) throws BrokerException {
        Object object;
        int n;
        if (ToTxnLogConverter.DEBUG) {
            logger.log(4, this.getPrefix() + " convertClusterToTxnLogFormat " + transactionInformation);
        }
        if ((n = transactionInformation.getState().getState()) != 5) {
            object = this.getPrefix() + " convertClusterToTxnLogFormat: unknown state  " + n + " for " + transactionInformation;
            logger.log(32, (String)object);
        }
        object = new TransactionWork();
        this.getSentMessages(transactionInformation, (TransactionWork)object);
        this.getConsumedMessages(transactionInformation, (TransactionWork)object);
        TransactionUID transactionUID = transactionInformation.getTID();
        TransactionState transactionState = new TransactionState(transactionInformation.getState());
        TransactionBroker[] transactionBrokerArray = transactionInformation.getClusterTransactionBrokers();
        ClusterTransaction clusterTransaction = new ClusterTransaction(transactionUID, transactionState, (TransactionWork)object, transactionBrokerArray);
        this.store.logTxn(clusterTransaction);
        this.deleteSentMessagesFromStore((TransactionWork)object);
    }
}

