/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.BrokerAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerLogListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceListCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleUtils;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class BrokerCObj
extends BrokerAdminCObj {
    private BrokerServiceListCObj bSvcListCObj;
    private BrokerDestListCObj bDestListCObj;
    private BrokerLogListCObj bLogListCObj;
    private transient BrokerAdmin ba;
    private Properties bkrProps;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public BrokerCObj(BrokerAdmin brokerAdmin) {
        this.ba = brokerAdmin;
        this.bSvcListCObj = new BrokerServiceListCObj(this);
        this.bDestListCObj = new BrokerDestListCObj(this);
        this.insert(this.bSvcListCObj, 0);
        this.insert(this.bDestListCObj, 1);
    }

    public BrokerAdmin getBrokerAdmin() {
        return this.ba;
    }

    public Properties getBrokerProps() {
        return this.bkrProps;
    }

    public BrokerDestListCObj getBrokerDestListCObj() {
        return this.bDestListCObj;
    }

    public BrokerServiceListCObj getBrokerServiceListCObj() {
        return this.bSvcListCObj;
    }

    public void setBrokerProps(Properties properties) {
        this.bkrProps = properties;
    }

    public String getExplorerLabel() {
        if (this.ba != null) {
            return this.ba.getKey();
        }
        return acr.getString(acr.getString("A1094"));
    }

    public String getExplorerToolTip() {
        return null;
    }

    public ImageIcon getExplorerIcon() {
        if (this.ba.isConnected()) {
            return AGraphics.adminImages[9];
        }
        return AGraphics.adminImages[19];
    }

    public String getActionLabel(int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 1024: {
                    return acr.getString("A1026");
                }
                case 2048: {
                    return acr.getString("A1029");
                }
                case 256: {
                    return acr.getString("A1031");
                }
                case 512: {
                    return acr.getString("A1034");
                }
                case 64: {
                    return acr.getString("A1036");
                }
                case 128: {
                    return acr.getString("A1037");
                }
                case 65536: {
                    return acr.getString("A1505");
                }
                case 2: {
                    return acr.getString("A1018");
                }
                case 32: {
                    return acr.getString("A1005");
                }
            }
        } else {
            switch (n) {
                case 1024: {
                    return acr.getString("A1141");
                }
                case 2048: {
                    return acr.getString("A1144");
                }
                case 256: {
                    return acr.getString("A1146");
                }
                case 512: {
                    return acr.getString("A1149");
                }
                case 64: {
                    return acr.getString("A1151");
                }
                case 128: {
                    return acr.getString("A1152");
                }
                case 65536: {
                    return acr.getString("A1159");
                }
                case 2: {
                    return acr.getString("A1133");
                }
                case 32: {
                    return acr.getString("A1122");
                }
            }
        }
        return null;
    }

    public ImageIcon getActionIcon(int n) {
        switch (n) {
            case 1024: {
                return AGraphics.adminImages[32];
            }
            case 2048: {
                return AGraphics.adminImages[34];
            }
        }
        return null;
    }

    public int getExplorerPopupMenuItemMask() {
        return 69602;
    }

    public int getActiveActions() {
        int n = 0;
        if (this.ba.isConnected()) {
            if (this.isPausable(this.ba)) {
                n |= 0x100;
            }
            if (this.isResumable(this.ba)) {
                n |= 0x200;
            }
            n |= 0x148E2;
        } else {
            n = 1058;
        }
        return n;
    }

    public String getInspectorPanelClassName() {
        return ConsoleUtils.getPackageName(this) + ".BrokerInspector";
    }

    public String getInspectorPanelId() {
        return "Broker";
    }

    public String getInspectorPanelHeader() {
        return this.getInspectorPanelId();
    }

    private boolean isPausable(BrokerAdmin brokerAdmin) {
        boolean bl = false;
        Enumeration<TreeNode> enumeration = this.bSvcListCObj.children();
        while (enumeration.hasMoreElements()) {
            ServiceInfo serviceInfo;
            ConsoleObj consoleObj = (ConsoleObj)enumeration.nextElement();
            if (!(consoleObj instanceof BrokerServiceCObj) || (serviceInfo = ((BrokerServiceCObj)consoleObj).getServiceInfo()) == null || serviceInfo.type == 1 || serviceInfo.state != 3) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isResumable(BrokerAdmin brokerAdmin) {
        boolean bl = false;
        Enumeration<TreeNode> enumeration = this.bSvcListCObj.children();
        while (enumeration.hasMoreElements()) {
            ServiceInfo serviceInfo;
            ConsoleObj consoleObj = (ConsoleObj)enumeration.nextElement();
            if (!(consoleObj instanceof BrokerServiceCObj) || (serviceInfo = ((BrokerServiceCObj)consoleObj).getServiceInfo()) == null || serviceInfo.type == 1 || serviceInfo.state != 4) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

