/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class JMQByteBufferOutputStream
extends OutputStream {
    protected ByteBuffer buf = null;
    private boolean isClosed = false;

    private void ensureOpen() {
    }

    public JMQByteBufferOutputStream(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
    }

    public synchronized void write(int n) throws BufferOverflowException {
        this.ensureOpen();
        this.buf.put((byte)n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws BufferOverflowException {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.buf.put(byArray, n, n2);
    }

    public synchronized void reset() {
        this.ensureOpen();
        this.buf.clear();
    }

    public synchronized ByteBuffer getByteBuffer() {
        return this.buf;
    }

    public int size() {
        return this.buf.capacity();
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.buf = null;
    }
}

