/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy;

import com.sun.xml.ws.addressing.policy.AddressingFeatureConfigurator;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.encoding.policy.FastInfosetFeatureConfigurator;
import com.sun.xml.ws.encoding.policy.MtomFeatureConfigurator;
import com.sun.xml.ws.encoding.policy.SelectOptimalEncodingFeatureConfigurator;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicyMerger;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.subject.PolicyMapKeyConverter;
import com.sun.xml.ws.policy.subject.WsdlBindingSubject;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyUtil {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyUtil.class);
    private static final PolicyMerger MERGER = PolicyMerger.getMerger();
    private static final Collection<PolicyFeatureConfigurator> CONFIGURATORS = new LinkedList<PolicyFeatureConfigurator>();

    public static <T> void addServiceProviders(Collection<T> providers, Class<T> service) {
        Iterator<T> foundProviders = ServiceFinder.find(service).iterator();
        while (foundProviders.hasNext()) {
            providers.add(foundProviders.next());
        }
    }

    public static void configureModel(WSDLModel model, PolicyMap policyMap) throws PolicyException {
        LOGGER.entering(new Object[]{model, policyMap});
        for (WSDLService wSDLService : model.getServices().values()) {
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                Collection<WebServiceFeature> features = PolicyUtil.getPortScopedFeatures(policyMap, wSDLService.getName(), wSDLPort.getName());
                for (WebServiceFeature feature : features) {
                    wSDLPort.addFeature(feature);
                    wSDLPort.getBinding().addFeature(feature);
                }
            }
        }
        LOGGER.exiting();
    }

    public static Collection<WebServiceFeature> getPortScopedFeatures(PolicyMap policyMap, QName serviceName, QName portName) {
        LOGGER.entering(new Object[]{policyMap, serviceName, portName});
        ArrayList<WebServiceFeature> features = new ArrayList<WebServiceFeature>();
        try {
            PolicyMapKey key = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
            for (PolicyFeatureConfigurator configurator : CONFIGURATORS) {
                Collection<WebServiceFeature> additionalFeatures = configurator.getFeatures(key, policyMap);
                if (additionalFeatures == null) continue;
                features.addAll(additionalFeatures);
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        LOGGER.exiting(features);
        return features;
    }

    static void insertPolicies(PolicyMap policyMap, Collection<PolicySubject> policySubjects, QName serviceName, QName portName) throws PolicyException {
        LOGGER.entering(new Object[]{policyMap, policySubjects, serviceName, portName});
        HashMap subjectToPolicies = new HashMap();
        for (PolicySubject subject : policySubjects) {
            Object actualSubject = subject.getSubject();
            if (!(actualSubject instanceof WsdlBindingSubject)) continue;
            WsdlBindingSubject wsdlSubject = (WsdlBindingSubject)actualSubject;
            LinkedList<Policy> subjectPolicies = new LinkedList<Policy>();
            subjectPolicies.add(subject.getEffectivePolicy(MERGER));
            Collection existingPolicies = subjectToPolicies.put(wsdlSubject, subjectPolicies);
            if (existingPolicies == null) continue;
            subjectPolicies.addAll(existingPolicies);
        }
        PolicyMapKeyConverter converter = new PolicyMapKeyConverter(serviceName, portName);
        for (WsdlBindingSubject wsdlSubject : subjectToPolicies.keySet()) {
            PolicySubject newSubject = new PolicySubject((Object)wsdlSubject, (Collection)subjectToPolicies.get(wsdlSubject));
            PolicyMapKey mapKey = converter.getPolicyMapKey(wsdlSubject);
            if (wsdlSubject.isBindingSubject()) {
                policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, mapKey, newSubject);
                continue;
            }
            if (wsdlSubject.isBindingOperationSubject()) {
                policyMap.putSubject(PolicyMap.ScopeType.OPERATION, mapKey, newSubject);
                continue;
            }
            if (!wsdlSubject.isBindingMessageSubject()) continue;
            switch (wsdlSubject.getMessageType()) {
                case INPUT: {
                    policyMap.putSubject(PolicyMap.ScopeType.INPUT_MESSAGE, mapKey, newSubject);
                    break;
                }
                case OUTPUT: {
                    policyMap.putSubject(PolicyMap.ScopeType.OUTPUT_MESSAGE, mapKey, newSubject);
                    break;
                }
                case FAULT: {
                    policyMap.putSubject(PolicyMap.ScopeType.FAULT_MESSAGE, mapKey, newSubject);
                }
            }
        }
        LOGGER.exiting();
    }

    static {
        CONFIGURATORS.add(new AddressingFeatureConfigurator());
        CONFIGURATORS.add(new MtomFeatureConfigurator());
        CONFIGURATORS.add(new FastInfosetFeatureConfigurator());
        CONFIGURATORS.add(new SelectOptimalEncodingFeatureConfigurator());
        PolicyUtil.addServiceProviders(CONFIGURATORS, PolicyFeatureConfigurator.class);
    }
}

