/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.plugin;

import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.tools.plugin.ToolPlugin;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ToolPluginFactory {
    private Map pluginMap;
    private static Logger logger;
    private static Localizer localizer;
    private static LocalizableMessageFactory messageFactory;
    public static final String NS_NAME = "http://java.sun.com/xml/ns/jax-rpc/ri/tool-plugin";
    private static final QName QNAME_TOOL_PLUGINS;
    private static final QName QNAME_TOOL_PLUGIN;
    private static final QName QNAME_EXTENSION_POINT;
    private static final QName QNAME_EXTENSION;
    private static final String ATTR_EXTEND_ID = "extendId";
    private static final String ATTR_EXTEND_TYPE = "type";
    private static final String ATTR_PLUGIN_ID = "pluginId";
    private static final String ATTR_CLASS_NAME = "class";
    private static ToolPluginFactory factory;

    private ToolPluginFactory() {
        messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.toolplugin");
        logger = Logger.getLogger("javax.enterprise.resource.webservices.rpc.toolplugin");
        localizer = new Localizer();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String toolPluginFile = "META-INF/jaxrpc/ToolPlugin.xml";
        try {
            Enumeration<URL> urls = loader.getResources("META-INF/jaxrpc/ToolPlugin.xml");
            if (urls == null || !urls.hasMoreElements()) {
                if (logger.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("No resources found for ");
                    sb.append("META-INF/jaxrpc/ToolPlugin.xml");
                    sb.append(" with current thread's classloader. ");
                    sb.append("Trying getClass().getClassLoader() instead.");
                    logger.fine(sb.toString());
                }
                urls = this.getClass().getClassLoader().getResources("META-INF/jaxrpc/ToolPlugin.xml");
            }
            while (urls != null && urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Attempting to load '%s'", url));
                }
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                XMLReader reader = XMLReaderFactory.newInstance().createXMLReader(in);
                reader.next();
                QName tag = reader.getName();
                if (tag.equals(QNAME_TOOL_PLUGINS)) {
                    this.parseToolPlugins(reader);
                }
                reader.nextElementContent();
                XMLReaderUtil.verifyReaderState(reader, 5);
                ((InputStream)in).close();
            }
            this.linkExtensionsWithExtensionPoints();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void linkExtensionsWithExtensionPoints() {
        if (this.pluginMap != null) {
            for (Map.Entry entry : this.pluginMap.entrySet()) {
                ToolPluginAll toolPluginAll = (ToolPluginAll)entry.getValue();
                List list = toolPluginAll.toolPluginTag.extensionsList;
                if (list == null) continue;
                for (ExtensionTag extensionTag : list) {
                    if (toolPluginAll.toolPluginTag.pluginId.equals(extensionTag.pluginId)) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.warning(localizer.localize(messageFactory.getMessage("no.self.extension", extensionTag.pluginId)));
                        continue;
                    }
                    this.setExtensionImplRef(extensionTag.pluginId, extensionTag.extendId, toolPluginAll);
                }
            }
        }
    }

    private void setExtensionImplRef(String pluginId, String extendId, ToolPluginAll impl) {
        ToolPluginAll base = (ToolPluginAll)this.pluginMap.get(pluginId);
        if (base != null) {
            ToolPluginTag toolPluginTag = base.toolPluginTag;
            if (toolPluginTag.extensionPointMap != null) {
                ExtensionPointTag tag = (ExtensionPointTag)toolPluginTag.extensionPointMap.get(extendId);
                if (tag != null) {
                    if (tag.implementors == null) {
                        tag.implementors = new ArrayList();
                    }
                    tag.implementors.add(impl);
                } else if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(localizer.localize(messageFactory.getMessage("unknown.extensionPoint", extendId)));
                }
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.warning(localizer.localize(messageFactory.getMessage("unknown.extensionPoint", extendId)));
            }
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning(localizer.localize(messageFactory.getMessage("unknown.plugin", pluginId)));
        }
    }

    private ExtensionTag parseExtension(XMLReader reader) {
        Attributes attrs = reader.getAttributes();
        String pluginId = attrs.getValue(ATTR_PLUGIN_ID);
        String extendId = attrs.getValue(ATTR_EXTEND_ID);
        if ((pluginId == null || extendId == null) && logger.isLoggable(Level.WARNING)) {
            logger.warning(localizer.localize(messageFactory.getMessage("no.pluginId.or.extendId")));
        }
        reader.nextElementContent();
        XMLReaderUtil.verifyReaderState(reader, 2);
        ExtensionTag extensionTag = new ExtensionTag(pluginId, extendId);
        return extensionTag;
    }

    private ExtensionPointTag parseExtendPoint(XMLReader reader) {
        Attributes attrs = reader.getAttributes();
        String extendId = attrs.getValue(ATTR_EXTEND_ID);
        String extendType = attrs.getValue(ATTR_EXTEND_TYPE);
        if ((extendId == null || extendType == null) && logger.isLoggable(Level.WARNING)) {
            logger.warning(localizer.localize(messageFactory.getMessage("no.extendId.or.extendType")));
        }
        reader.nextElementContent();
        XMLReaderUtil.verifyReaderState(reader, 2);
        ExtensionPointTag ExtensionPointTag2 = new ExtensionPointTag(extendId, extendType);
        return ExtensionPointTag2;
    }

    private void parseToolPlugins(XMLReader reader) {
        while (reader.nextElementContent() == 1) {
            QName tag = reader.getName();
            if (tag.equals(QNAME_TOOL_PLUGIN)) {
                this.parseToolPlugin(reader);
                continue;
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.warning(localizer.localize(messageFactory.getMessage("unknown.tag", tag.toString())));
        }
        XMLReaderUtil.verifyReaderState(reader, 2);
    }

    private void parseToolPlugin(XMLReader reader) {
        Attributes attrs = reader.getAttributes();
        String pluginId = attrs.getValue(ATTR_PLUGIN_ID);
        String className = attrs.getValue(ATTR_CLASS_NAME);
        ToolPluginTag toolPluginTag = new ToolPluginTag(pluginId, className);
        while (reader.nextElementContent() == 1) {
            QName tag = reader.getName();
            if (tag.equals(QNAME_EXTENSION_POINT)) {
                ExtensionPointTag ExtensionPointTag2 = this.parseExtendPoint(reader);
                if (toolPluginTag.extensionPointMap == null) {
                    toolPluginTag.extensionPointMap = new HashMap();
                }
                toolPluginTag.extensionPointMap.put(ExtensionPointTag2.extendId, ExtensionPointTag2);
                continue;
            }
            if (tag.equals(QNAME_EXTENSION)) {
                ExtensionTag ExtensionTag2 = this.parseExtension(reader);
                if (toolPluginTag.extensionsList == null) {
                    toolPluginTag.extensionsList = new ArrayList();
                }
                toolPluginTag.extensionsList.add(ExtensionTag2);
                continue;
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.warning(localizer.localize(messageFactory.getMessage("unknown.tag", tag.toString())));
        }
        XMLReaderUtil.verifyReaderState(reader, 2);
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap();
        }
        this.pluginMap.put(pluginId, new ToolPluginAll(toolPluginTag));
    }

    public ToolPlugin getPlugin(String pluginId) {
        ToolPluginAll toolPluginAll;
        ToolPlugin toolPlugin = null;
        if (this.pluginMap != null && (toolPluginAll = (ToolPluginAll)this.pluginMap.get(pluginId)) != null) {
            toolPlugin = toolPluginAll.getToolPlugin();
        }
        return toolPlugin;
    }

    public Iterator getExtensions(String pluginId, String extendId) {
        ToolPlugin toolPlugin;
        ToolPluginAll toolPluginAll;
        Iterator i = null;
        if (this.pluginMap != null && (toolPluginAll = (ToolPluginAll)this.pluginMap.get(pluginId)) != null && (toolPlugin = toolPluginAll.getToolPlugin()) != null) {
            return toolPluginAll.getExtensions(extendId);
        }
        return i;
    }

    private void printAll() {
        System.out.println("All Plugins");
        System.out.println("===========");
        if (this.pluginMap != null) {
            for (Map.Entry entry : this.pluginMap.entrySet()) {
                System.out.println("pluginId=" + entry.getKey());
                System.out.println("------------------------");
                ToolPluginAll toolPluginAll = (ToolPluginAll)entry.getValue();
                System.out.println("toolPlugin=" + toolPluginAll.toolPlugin);
                System.out.println("extensionPointMap=" + toolPluginAll.toolPluginTag.extensionPointMap);
                System.out.println("extensionsList=" + toolPluginAll.toolPluginTag.extensionsList);
            }
        }
    }

    public static ToolPluginFactory getInstance() {
        if (factory == null) {
            factory = new ToolPluginFactory();
        }
        return factory;
    }

    static {
        QNAME_TOOL_PLUGINS = new QName(NS_NAME, "toolPlugins");
        QNAME_TOOL_PLUGIN = new QName(NS_NAME, "toolPlugin");
        QNAME_EXTENSION_POINT = new QName(NS_NAME, "extensionPoint");
        QNAME_EXTENSION = new QName(NS_NAME, "extension");
        factory = new ToolPluginFactory();
    }

    private class ExtensionPointTag {
        private String extendId;
        private String extendType;
        private List implementors;

        public ExtensionPointTag(String extendId, String extendType) {
            this.extendId = extendId;
            this.extendType = extendType;
        }

        public String toString() {
            return this.extendId + ":" + this.extendType + ":" + this.implementors;
        }
    }

    private class ExtensionTag {
        private String pluginId;
        private String extendId;

        public ExtensionTag(String pluginId, String extendId) {
            this.pluginId = pluginId;
            this.extendId = extendId;
        }

        public String toString() {
            return this.pluginId + ":" + this.extendId;
        }
    }

    private class ToolPluginAll {
        private ToolPlugin toolPlugin;
        private Map extensionsMap;
        private ToolPluginTag toolPluginTag;

        public ToolPluginAll(ToolPluginTag toolPluginTag) {
            this.toolPluginTag = toolPluginTag;
        }

        public ToolPlugin getToolPlugin() {
            if (this.toolPlugin == null) {
                ClassLoader cll = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> cl = cll.loadClass(this.toolPluginTag.className);
                    this.toolPlugin = (ToolPlugin)cl.newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return this.toolPlugin;
        }

        public Iterator getExtensions(String extendId) {
            ArrayList<ToolPlugin> implList;
            if (this.toolPluginTag.extensionPointMap == null) {
                return null;
            }
            ExtensionPointTag ExtensionPointTag2 = (ExtensionPointTag)this.toolPluginTag.extensionPointMap.get(extendId);
            if (ExtensionPointTag2 == null) {
                return null;
            }
            List allList = ExtensionPointTag2.implementors;
            if (allList == null) {
                return null;
            }
            if (this.extensionsMap == null) {
                this.extensionsMap = new HashMap();
            }
            if ((implList = (ArrayList<ToolPlugin>)this.extensionsMap.get(extendId)) == null) {
                implList = new ArrayList<ToolPlugin>();
                for (ToolPluginAll implAll : allList) {
                    ToolPlugin toolPlugin = implAll.getToolPlugin();
                    implList.add(toolPlugin);
                }
                this.extensionsMap.put(extendId, implList);
            }
            return implList.iterator();
        }
    }

    private class ToolPluginTag {
        private String pluginId;
        private String className;
        private Map extensionPointMap;
        private List extensionsList;

        public ToolPluginTag(String pluginId, String className) {
            this.pluginId = pluginId;
            this.className = className;
        }
    }
}

