/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common;

import com.sun.xml.registry.common.ConnectionFactoryFactory;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;

public class ConnectionFactoryImpl
extends ConnectionFactory
implements Referenceable {
    private Properties properties;

    @Override
    public void setProperties(Properties properties) throws JAXRException {
        this.properties = properties;
    }

    @Override
    public Properties getProperties() throws JAXRException {
        return this.properties;
    }

    @Override
    public Connection createConnection() throws JAXRException {
        ClassLoader classLoader;
        String string2 = (String)this.properties.get("javax.xml.registry.ConnectionFactoryClass");
        String string3 = (String)this.properties.get("javax.xml.registry.queryManagerURL");
        String string4 = (String)this.properties.get("javax.xml.registry.lifeCycleManagerURL");
        if (string3 == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Missing_connection_property_javax.xml.registry.queryManagerURL"));
        }
        if (string2 == null) {
            string2 = "com.sun.xml.registry.uddi.ConnectionFactoryImpl";
        }
        try {
            classLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            throw new JAXRException(exception.toString(), exception);
        }
        try {
            Class<?> clazz = null;
            clazz = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2);
            ConnectionFactory connectionFactory = (ConnectionFactory)clazz.newInstance();
            connectionFactory.setProperties(this.properties);
            return connectionFactory.createConnection();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Unable_to_create_connection"), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Unable_to_create_connection"), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Unable_to_create_connection"), illegalAccessException);
        }
    }

    @Override
    public FederatedConnection createFederatedConnection(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(ConnectionFactoryImpl.class.getName(), ConnectionFactoryFactory.class.getName(), null);
        return reference;
    }
}

