/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.felix.shell.ShellService;
import org.apache.felix.shell.remote.Activator;
import org.apache.felix.shell.remote.AtomicInteger;
import org.apache.felix.shell.remote.Listener;
import org.apache.felix.shell.remote.ReentrantLock;
import org.apache.felix.shell.remote.ServiceMediator;
import org.apache.felix.shell.remote.TerminalPrintStream;
import org.apache.felix.shell.remote.TerminalReader;

class Shell
implements Runnable {
    private Listener m_owner;
    private Socket m_Socket;
    private AtomicInteger m_UseCounter;

    public Shell(Listener owner, Socket s, AtomicInteger counter) {
        this.m_owner = owner;
        this.m_Socket = s;
        this.m_UseCounter = counter;
    }

    void terminate() {
        this.exit("\r\nFelix Remote Shell Console Terminating");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.m_owner.registerConnection(this);
        try {
            TerminalPrintStream out = new TerminalPrintStream(this.m_Socket.getOutputStream());
            BufferedReader in = new BufferedReader(new TerminalReader(this.m_Socket.getInputStream(), out));
            ReentrantLock lock = new ReentrantLock();
            out.println();
            ((PrintStream)out).println("Felix Remote Shell Console:");
            ((PrintStream)out).println("============================");
            ((PrintStream)out).println("");
            while (true) {
                ((PrintStream)out).print("-> ");
                String line = "";
                try {
                    line = in.readLine();
                    if (line == null) {
                        ((PrintStream)out).println("exit");
                        return;
                    }
                }
                catch (Exception ex) {
                    return;
                }
                line = line.trim();
                if (line.equalsIgnoreCase("exit")) return;
                if (line.equalsIgnoreCase("disconnect")) {
                    return;
                }
                ShellService shs = Activator.getServices().getFelixShellService(ServiceMediator.NO_WAIT);
                try {
                    lock.acquire();
                    shs.executeCommand(line, (PrintStream)out, (PrintStream)out);
                    continue;
                }
                catch (Exception ex) {
                    Activator.getServices().error("Shell::run()", ex);
                    continue;
                }
                finally {
                    lock.release();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            Activator.getServices().error("Shell::run()", ex);
            return;
        }
        finally {
            this.exit(null);
        }
    }

    private void exit(String message) {
        try {
            TerminalPrintStream out = new TerminalPrintStream(this.m_Socket.getOutputStream());
            if (message != null) {
                ((PrintStream)out).println(message);
            }
            ((PrintStream)out).println("Good Bye!");
            out.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.m_Socket.close();
        }
        catch (IOException ex) {
            Activator.getServices().error("Shell::exit()", ex);
        }
        this.m_owner.unregisterConnection(this);
        this.m_UseCounter.decrement();
    }
}

