/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.CorbaContactInfoBase;
import com.sun.corba.ee.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.SocketInfo;

public class SocketOrChannelContactInfoImpl
extends CorbaContactInfoBase
implements SocketInfo {
    protected boolean isHashCodeCached = false;
    protected int cachedHashCode;
    protected String socketType;
    protected String hostname;
    protected int port;

    protected SocketOrChannelContactInfoImpl() {
    }

    protected SocketOrChannelContactInfoImpl(ORB orb, CorbaContactInfoList contactInfoList) {
        this.orb = orb;
        this.contactInfoList = contactInfoList;
    }

    public SocketOrChannelContactInfoImpl(ORB orb, CorbaContactInfoList contactInfoList, String socketType, String hostname, int port) {
        this(orb, contactInfoList);
        this.socketType = socketType;
        this.hostname = hostname;
        this.port = port;
    }

    public SocketOrChannelContactInfoImpl(ORB orb, CorbaContactInfoList contactInfoList, IOR effectiveTargetIOR, short addressingDisposition, String socketType, String hostname, int port) {
        this(orb, contactInfoList, socketType, hostname, port);
        this.effectiveTargetIOR = effectiveTargetIOR;
        this.addressingDisposition = addressingDisposition;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    public boolean shouldCacheConnection() {
        return true;
    }

    @Override
    public String getConnectionCacheType() {
        return "SocketOrChannelConnectionCache";
    }

    @Override
    public CorbaConnection createConnection() {
        SocketOrChannelConnectionImpl connection = new SocketOrChannelConnectionImpl(this.orb, this, this.socketType, this.hostname, this.port);
        return connection;
    }

    @Override
    public String getMonitoringName() {
        return "SocketConnections";
    }

    @Override
    public String getType() {
        return this.socketType;
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int hashCode() {
        if (!this.isHashCodeCached) {
            this.cachedHashCode = this.socketType.hashCode() ^ this.hostname.hashCode() ^ this.port;
            this.isHashCodeCached = true;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SocketOrChannelContactInfoImpl)) {
            return false;
        }
        SocketOrChannelContactInfoImpl other = (SocketOrChannelContactInfoImpl)obj;
        if (this.port != other.port) {
            return false;
        }
        if (!this.hostname.equals(other.hostname)) {
            return false;
        }
        return !(this.socketType == null ? other.socketType != null : !this.socketType.equals(other.socketType));
    }

    @Override
    public String toString() {
        return "SocketOrChannelContactInfoImpl[" + this.socketType + " " + this.hostname + " " + this.port + "]";
    }

    @Override
    protected void dprint(String msg) {
        ORBUtility.dprint("SocketOrChannelContactInfoImpl", msg);
    }
}

