/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orb;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orb.ParserActionBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.Operation;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.misc.ObjectUtility;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class PrefixParserAction
extends ParserActionBase {
    private Class componentType;
    private ORBUtilSystemException wrapper;

    public PrefixParserAction(String propertyName, Operation operation, String fieldName, Class componentType) {
        super(propertyName, true, operation, fieldName);
        this.componentType = componentType;
        this.wrapper = ORB.getStaticLogWrapperTable().get_ORB_LIFECYCLE_ORBUtil();
    }

    @Override
    public Object apply(Properties props) {
        int prefixLength;
        String prefix = this.getPropertyName();
        if (prefix.charAt((prefixLength = prefix.length()) - 1) != '.') {
            prefix = prefix + '.';
            ++prefixLength;
        }
        LinkedList<Object> matches = new LinkedList<Object>();
        for (String string : props.keySet()) {
            if (!string.startsWith(prefix)) continue;
            String suffix = string.substring(prefixLength);
            String value = props.getProperty(string);
            Pair data = new Pair((Object)suffix, (Object)value);
            Object result = this.getOperation().operate(data);
            matches.add(result);
        }
        int n = matches.size();
        if (n > 0) {
            Object result = null;
            try {
                result = Array.newInstance(this.componentType, n);
            }
            catch (Throwable thr) {
                throw this.wrapper.couldNotCreateArray(thr, (Object)this.getPropertyName(), (Object)this.componentType, (Object)n);
            }
            Iterator iter2 = matches.iterator();
            int ctr = 0;
            while (iter2.hasNext()) {
                Object obj = iter2.next();
                try {
                    Array.set(result, ctr, obj);
                }
                catch (Throwable thr) {
                    throw this.wrapper.couldNotSetArray(thr, (Object)this.getPropertyName(), (Object)ctr, (Object)this.componentType, (Object)n, (Object)ObjectUtility.compactObjectToString(obj));
                }
                ++ctr;
            }
            return result;
        }
        return null;
    }
}

