/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.jsf.shale;

import java.util.ListIterator;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.UriManager;
import jmaki.runtime.UriManagerFactory;
import org.apache.shale.remoting.Mapping;
import org.apache.shale.remoting.Mappings;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.faces.MappingsHelper;

public class RemotingUriManager
implements UriManager,
UriManagerFactory {
    private Mappings mappings = null;
    private Mapping classPathMapping = null;
    private Mapping dynamicMapping = null;
    private Mapping webappMapping = null;
    private Mapping externalMapping = null;

    public String buildClassPathResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.classPathMapping == null) {
            String[] parameter = new String[]{"ClassPathResourceReference", Mechanism.CLASS_RESOURCE.toString()};
            throw new AjaxException(new LocalizedMessage("ERROR_URIMANAGER_CANNOTBUILDREFERENCE", parameter));
        }
        return this.classPathMapping.mapResourceId(FacesContext.getCurrentInstance(), "/META-INF" + resource);
    }

    public String buildDynamicResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.dynamicMapping == null) {
            String[] parameter = new String[]{"DynamicResourceReference", Mechanism.DYNAMIC_RESOURCE.toString()};
            throw new AjaxException(new LocalizedMessage("ERROR_URIMANAGER_CANNOTBUILDREFERENCE", parameter));
        }
        if (resource.startsWith("#{") && resource.endsWith("}")) {
            resource = "/" + resource.substring(2, resource.length() - 1).replace('.', '-');
        }
        return this.dynamicMapping.mapResourceId(FacesContext.getCurrentInstance(), resource);
    }

    public String buildExternalResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.externalMapping == null) {
            String[] parameter = new String[]{"ExternalResourceReference", Mechanism.OTHER_RESOURCE.toString()};
            throw new AjaxException(new LocalizedMessage("ERROR_URIMANAGER_CANNOTBUILDREFERENCE", parameter));
        }
        return this.externalMapping.mapResourceId(FacesContext.getCurrentInstance(), resource);
    }

    public String buildWebAppResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.webappMapping == null) {
            String[] parameter = new String[]{"WebAppResourceReference", Mechanism.WEBAPP_RESOURCE.toString()};
            throw new AjaxException(new LocalizedMessage("ERROR_URIMANAGER_CANNOTBUILDREFERENCE", parameter));
        }
        return this.webappMapping.mapResourceId(FacesContext.getCurrentInstance(), resource);
    }

    public UriManager getInstance(ServletContext ctx) throws AjaxException {
        this.mappings = new MappingsHelper().getMappings(FacesContext.getCurrentInstance());
        if (this.mappings == null) {
            throw new AjaxException(new LocalizedMessage("ERROR_SHALE_MAPPINGS"));
        }
        ListIterator mappingsIterator = this.mappings.getMappings().listIterator();
        while (mappingsIterator.hasNext()) {
            Mapping mapping = (Mapping)mappingsIterator.next();
            Mechanism mechanism = mapping.getMechanism();
            if (mechanism.equals(Mechanism.CLASS_RESOURCE)) {
                this.classPathMapping = mapping;
            }
            if (mechanism.equals(Mechanism.DYNAMIC_RESOURCE)) {
                this.dynamicMapping = mapping;
            }
            if (mechanism.equals(Mechanism.WEBAPP_RESOURCE)) {
                this.webappMapping = mapping;
            }
            if (!mechanism.equals(Mechanism.OTHER_RESOURCE)) continue;
            this.externalMapping = mapping;
        }
        return this;
    }
}

