/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.config;

import javax.servlet.ServletContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigUtil {
    public static boolean isInitParameterSet(ServletContext ctx, String initparameterName) {
        String parameterValue = ctx.getInitParameter(initparameterName);
        return parameterValue != null && !parameterValue.equals("");
    }

    public static boolean getBooleanInitParameter(ServletContext ctx, String initparameterName) {
        boolean parameterBoolean = false;
        if (ctx.getInitParameter(initparameterName) != null) {
            parameterBoolean = ctx.getInitParameter(initparameterName).equalsIgnoreCase("true");
        }
        return parameterBoolean;
    }

    public static long getLongInitParameter(ServletContext ctx, String initparameterName) {
        long parameterLong = -1L;
        if (ctx.getInitParameter(initparameterName) != null) {
            parameterLong = new Long(ctx.getInitParameter(initparameterName));
        }
        return parameterLong;
    }

    public static String jsonToObjectLiteral(JSONObject jo, StringBuffer buff) throws JSONException {
        if (buff == null) {
            buff = new StringBuffer("{");
        } else {
            buff.append("{");
        }
        JSONArray names = jo.names();
        for (int l = 0; names != null && l < names.length(); ++l) {
            String key = names.getString(l);
            String value = null;
            if (jo.optJSONObject(key) != null) {
                value = key + ":";
                buff.append(value);
                ConfigUtil.jsonToObjectLiteral(jo.optJSONObject(key), buff);
            } else if (jo.optJSONArray(key) != null) {
                value = key + ":";
                buff.append(value);
                ConfigUtil.jsonArrayToString(jo.optJSONArray(key), buff);
            } else if (jo.optLong(key, -1L) != -1L) {
                value = key + ":" + jo.get(key) + "";
                buff.append(value);
            } else if (jo.optDouble(key, -1.0) != -1.0) {
                value = key + ":" + jo.get(key) + "";
                buff.append(value);
            } else if (jo.opt(key) != null) {
                Object obj = jo.opt(key);
                value = obj instanceof Boolean ? key + ":" + jo.getBoolean(key) + "" : key + ":" + "'" + jo.get(key) + "'";
                buff.append(value);
            }
            if (l >= names.length() - 1) continue;
            buff.append(",");
        }
        buff.append("}");
        return buff.toString();
    }

    public static String jsonArrayToString(JSONArray ja, StringBuffer buff) throws JSONException {
        if (buff == null) {
            buff = new StringBuffer("[");
        } else {
            buff.append("[");
        }
        for (int key = 0; ja != null && key < ja.length(); ++key) {
            String value = null;
            if (ja.optJSONObject(key) != null) {
                ConfigUtil.jsonToObjectLiteral(ja.optJSONObject(key), buff);
            } else if (ja.optJSONArray(key) != null) {
                ConfigUtil.jsonArrayToString(ja.optJSONArray(key), buff);
            } else if (ja.optLong(key, -1L) != -1L) {
                value = ja.get(key) + "";
                buff.append(value);
            } else if (ja.optDouble(key, -1.0) != -1.0) {
                value = ja.get(key) + "";
                buff.append(value);
            } else if (ja.optBoolean(key)) {
                value = ja.getBoolean(key) + "";
                buff.append(value);
            } else if (ja.opt(key) != null) {
                Object obj = ja.opt(key);
                value = obj instanceof Boolean ? ja.getBoolean(key) + "" : "'" + ja.get(key) + "'";
                buff.append(value);
            }
            if (key >= ja.length() - 1) continue;
            buff.append(",");
        }
        buff.append("]");
        return buff.toString();
    }
}

