/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmaki.services;

import com.sun.jmaki.services.XmlHttpProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class XmlHttpProxyServlet
extends HttpServlet {
    private static String XHP_LAST_MODIFIED = "xhp_last_modified_key";
    private static String XHP_CONFIG = "/resources/xhp.json";
    private static String XHP_RESOURCES = "/resources/xsl/";
    private static String XHP_CLASSPATH_RESOURCES = "/META-INF/resources/xsl/";
    private static boolean allowXDomain = false;
    private static boolean rDebug = false;
    private Logger logger = null;
    private XmlHttpProxy xhp = null;
    private ServletContext ctx;
    private JSONObject services = null;

    public XmlHttpProxyServlet() {
        if (rDebug) {
            this.logger = this.getLogger();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.ctx = config.getServletContext();
        String xdomainString = this.ctx.getInitParameter("allowXDomain");
        if (xdomainString != null && "true".equals(xdomainString)) {
            allowXDomain = true;
            this.getLogger().severe("XmlHttpProxyServlet: intialization. xDomain access is enabled.");
        }
        String proxyHost = this.ctx.getInitParameter("proxyHost");
        String proxyPortString = this.ctx.getInitParameter("proxyPort");
        if (proxyHost != null && proxyPortString != null) {
            int proxyPort = 8080;
            try {
                proxyPort = new Integer(proxyPortString);
                this.xhp = new XmlHttpProxy(proxyHost, proxyPort);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().severe("XmlHttpProxyServlet: intialization error. The proxyPort must be a number");
                throw new ServletException("XmlHttpProxyServlet: intialization error. The proxyPort must be a number");
            }
        } else {
            this.xhp = new XmlHttpProxy();
        }
    }

    private void getServices() {
        InputStream is = null;
        try {
            URL url = this.ctx.getResource(XHP_CONFIG);
            is = url.openStream();
        }
        catch (Exception ex) {
            this.getLogger().severe("XmlHttpProxyServlet error getting services:" + ex);
        }
        this.services = XmlHttpProxy.loadServices(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        HttpSession session;
        if (!allowXDomain && (session = req.getSession(false)) == null) {
            res.setStatus(403);
            return;
        }
        String serviceKey = req.getParameter("id");
        if (serviceKey == null) {
            serviceKey = req.getParameter("key");
        }
        OutputStream out = null;
        PrintWriter writer = null;
        if (this.services == null || this.configUpdated()) {
            this.getServices();
        }
        try {
            String callback;
            String format;
            String xslURLString;
            String urlString;
            block41: {
                urlString = null;
                xslURLString = null;
                format = "json";
                callback = req.getParameter("callback");
                String urlParams = req.getParameter("urlparams");
                if (urlParams != null) {
                    urlParams = urlParams.replace(' ', '+');
                }
                try {
                    if (this.services.has(serviceKey)) {
                        String serviceURL;
                        JSONObject service = this.services.getJSONObject(serviceKey);
                        if (urlParams == null && service.has("defaultURLParams")) {
                            urlParams = service.getString("defaultURLParams");
                        }
                        serviceURL = (serviceURL = service.getString("url")).indexOf("?") == -1 ? serviceURL + "?" : serviceURL + "&";
                        String apikey = "";
                        if (service.has("apikey")) {
                            apikey = service.getString("apikey");
                        }
                        urlString = serviceURL + apikey + "&" + urlParams;
                        if (service.has("xslStyleSheet")) {
                            xslURLString = service.getString("xslStyleSheet");
                        }
                        break block41;
                    }
                    writer = res.getWriter();
                    if (serviceKey == null) {
                        writer.write("XmlHttpProxyServlet Error: id parameter specifying serivce required.");
                    } else {
                        writer.write("XmlHttpProxyServlet Error : service for id '" + serviceKey + "' not  found.");
                    }
                    writer.flush();
                    return;
                }
                catch (Exception ex) {
                    this.getLogger().severe("XmlHttpProxyServlet Error loading service: " + ex);
                }
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("format", format);
            if (callback != null) {
                paramsMap.put("callback", callback);
            }
            InputStream xslInputStream = null;
            if (urlString == null) {
                writer = res.getWriter();
                writer.write("XmlHttpProxyServlet parameters:  id[Required] urlparams[Optional] format[Optional] callback[Optional]");
                writer.flush();
                return;
            }
            res.setContentType("text/html;charset=UTF-8");
            out = res.getOutputStream();
            if (xslURLString != null) {
                URL xslURL = null;
                xslURL = this.ctx.getResource(XHP_RESOURCES + xslURLString);
                if (xslURL == null) {
                    xslURL = XmlHttpProxyServlet.class.getResource(XHP_CLASSPATH_RESOURCES + xslURLString);
                }
                if (xslURL != null) {
                    xslInputStream = xslURL.openStream();
                } else {
                    String message = "Could not locate the XSL stylesheet provided for service id " + serviceKey + ". Please check the XMLHttpProxy configuration.";
                    this.getLogger().severe(message);
                    try {
                        out.write(message.getBytes());
                        out.flush();
                    }
                    catch (IOException iox) {
                        // empty catch block
                    }
                }
            }
            this.xhp.doGet(urlString, out, xslInputStream, paramsMap);
            return;
        }
        catch (IOException iox) {
            this.getLogger().severe("XmlHttpProxyServlet: caught " + iox);
            try {
                writer = res.getWriter();
                writer.write("XmlHttpProxyServlet error loading service for " + serviceKey + " . Please notify the administrator.");
                writer.flush();
                return;
            }
            catch (IOException ix) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iox) {}
        }
    }

    private boolean configUpdated() {
        try {
            URL url = this.ctx.getResource(XHP_CONFIG);
            if (url == null) {
                return false;
            }
            URLConnection con = url.openConnection();
            long lastModified = con.getLastModified();
            long XHP_LAST_MODIFIEDModified = 0L;
            if (this.ctx.getAttribute(XHP_LAST_MODIFIED) == null) {
                this.ctx.setAttribute(XHP_LAST_MODIFIED, (Object)new Long(lastModified));
                return false;
            }
            XHP_LAST_MODIFIEDModified = (Long)this.ctx.getAttribute(XHP_LAST_MODIFIED);
            if (XHP_LAST_MODIFIEDModified < lastModified) {
                this.ctx.setAttribute(XHP_LAST_MODIFIED, (Object)new Long(lastModified));
                return true;
            }
        }
        catch (Exception ex) {
            this.getLogger().severe("XmlHttpProxyServlet error checking configuration: " + ex);
        }
        return false;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("com.sun.jmaki.Log");
        }
        return this.logger;
    }

    private void logMessage(String message) {
        if (rDebug) {
            this.getLogger().info(message);
        }
    }
}

