/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class PSNCollector {
    private static final int SN = 1;
    private static final int SYS = 2;
    private static final int CPU = 3;

    private PSNCollector() {
    }

    public static String getLinuxCPUManufacturer() {
        String contents;
        String tmp = PSNCollector.getLinuxPSNInfo(3);
        if (tmp != null) {
            return tmp;
        }
        File f = new File("/proc/cpuinfo");
        if (f.exists() && (contents = PSNCollector.getFileContents("/proc/cpuinfo")) != null) {
            StringTokenizer st = new StringTokenizer(contents, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int indx = line.indexOf("vendor_id");
                if (indx == -1 || (indx = line.indexOf(":")) == -1 || indx + 1 >= line.length()) continue;
                return line.substring(indx + 1).trim();
            }
        }
        return PSNCollector.getLinuxDMIInfo("dmi type 4", "manufacturer");
    }

    public static String getLinuxSystemManufacturer() {
        String tmp = PSNCollector.getLinuxPSNInfo(2);
        if (tmp != null) {
            return tmp;
        }
        return PSNCollector.getLinuxDMIInfo("dmi type 1", "manufacturer");
    }

    public static String getLinuxSN() {
        String tmp = PSNCollector.getLinuxPSNInfo(1);
        if (tmp != null) {
            return tmp;
        }
        return PSNCollector.getLinuxDMIInfo("dmi type 1", "serial number");
    }

    public static String getSolarisSN() {
        String tmp;
        String tmpSN = null;
        File f = new File("/var/run/psn");
        if (f.exists() && (tmp = PSNCollector.getFileContents("/var/run/psn")) != null) {
            return tmp.trim();
        }
        tmpSN = PSNCollector.getSneepSN();
        if (tmpSN != null) {
            return tmpSN;
        }
        tmpSN = PSNCollector.getSmbiosData("1", "Serial Number: ");
        if (tmpSN != null) {
            return tmpSN;
        }
        tmpSN = PSNCollector.getSmbiosData("3", "Serial Number: ");
        if (tmpSN != null) {
            return tmpSN;
        }
        return null;
    }

    public static String getSolarisCPUManufacturer() {
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        String tmpManufacturer = PSNCollector.getSmbiosData("3", "Manufacturer: ");
        if (tmpManufacturer != null) {
            return tmpManufacturer;
        }
        return null;
    }

    public static String getSolarisSystemManufacturer() {
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        String tmpManufacturer = PSNCollector.getSmbiosData("1", "Manufacturer: ");
        if (tmpManufacturer != null) {
            return tmpManufacturer;
        }
        return null;
    }

    private static String getLinuxPSNInfo(int target) {
        File f = new File("/var/run/psn");
        if (f.exists()) {
            String contents = PSNCollector.getFileContents("/var/run/psn");
            if (contents == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(contents, "\n");
            String tmp = contents;
            if (st.countTokens() >= target) {
                for (int i = 0; i < target; ++i) {
                    tmp = st.nextToken();
                }
                return tmp.trim();
            }
        }
        return null;
    }

    private static String getLinuxDMIInfo(String dmiType, String target) {
        String[] cmd = new String[]{"/usr/sbin/dmidecode"};
        String output = PSNCollector.getAllOutputFromCommandLine(cmd);
        if (output == null) {
            return null;
        }
        StringTokenizer newLineTok = new StringTokenizer(output, "\n");
        boolean dmiFlag = false;
        while (newLineTok.hasMoreTokens()) {
            String line = newLineTok.nextToken();
            if (dmiFlag) {
                int indx = line.toLowerCase().indexOf(target);
                if (indx == -1) continue;
                indx = line.toLowerCase().indexOf(target + ":");
                if (indx != -1 && line.length() > target.length() + 1) {
                    return line.substring(indx + target.length() + 1).trim();
                }
                StringTokenizer colonTok = new StringTokenizer(line, ":");
                String tmp = line.trim();
                while (colonTok.hasMoreTokens()) {
                    tmp = colonTok.nextToken().trim();
                }
                return tmp;
            }
            if (line.toLowerCase().indexOf(dmiType) == -1) continue;
            dmiFlag = true;
        }
        return null;
    }

    private static String getFromCommandLine(String[] cmd) {
        String res = null;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            int rv = proc.waitFor();
            if (rv == 0) {
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                line = br.readLine();
                if (line != null) {
                    res = line;
                }
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private static String getFileContents(String file) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private static String getAllOutputFromCommandLine(String[] cmd) {
        StringBuilder sb = new StringBuilder();
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            int rv = proc.waitFor();
            if (rv == 0) {
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private static String getSmbiosData(String type, String target) {
        String[] smbiosCMD = new String[]{"/usr/sbin/smbios", "-t", type};
        String output = PSNCollector.getAllOutputFromCommandLine(smbiosCMD);
        if (output == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(output, "\n");
        while (st.hasMoreTokens()) {
            String tmp;
            String tok;
            String line = st.nextToken();
            int indx = line.indexOf(tok = target);
            if (indx == -1 || (tmp = line.substring(tok.length() + 1).trim()) == null || tmp.equalsIgnoreCase("not available") || tmp.equalsIgnoreCase("to be filled by o.e.m")) continue;
            return tmp;
        }
        return null;
    }

    private static String getSneepSN() {
        String[] basedirCMD = new String[]{"pkgparam", "SUNWsneep", "BASEDIR"};
        String basedir = PSNCollector.getFromCommandLine(basedirCMD);
        if (basedir == null) {
            return null;
        }
        String[] sneepCMD = new String[]{basedir + "/bin/sneep"};
        String sneepSN = PSNCollector.getFromCommandLine(sneepCMD);
        if (sneepSN == null || sneepSN.equalsIgnoreCase("unknown")) {
            return null;
        }
        return sneepSN;
    }
}

