/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.cometd.BayeuxParser;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.EventRouter;
import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbUtils;
import com.sun.grizzly.cometd.util.JSONParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class EventRouterImpl
implements EventRouter {
    private static final String JSON_MESSAGES = "message";
    private final BayeuxParser bayeuxParser;

    public EventRouterImpl(BayeuxParser bayeuxParser) {
        this.bayeuxParser = bayeuxParser;
    }

    public void route(final CometdRequest req, final CometdResponse res) throws IOException {
        String[] messages = this.getMessages(req);
        CometdContext cometdContext = null;
        if (messages != null && messages.length > 0) {
            for (String message : messages) {
                List<Verb> verbs = VerbUtils.parseRequest(JSONParser.parse(message));
                for (final Verb verb : verbs) {
                    cometdContext = new CometdContext(){

                        public CometdRequest getRequest() {
                            return req;
                        }

                        public CometdResponse getResponse() {
                            return res;
                        }

                        public Verb getVerb() {
                            return verb;
                        }
                    };
                    this.bayeuxParser.parse(cometdContext);
                }
            }
        } else {
            throw new IOException("Invalid request");
        }
    }

    private String[] getMessages(CometdRequest req) throws IOException {
        String contentType = req.getContentType();
        String[] messages = null;
        if (contentType != null) {
            int semicolon = contentType.indexOf(59);
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType = semicolon >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
                messages = req.getParameterValues(JSON_MESSAGES);
            } else if ("text/json".equalsIgnoreCase(contentType)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                int s = -1;
                byte[] b = new byte[1024];
                InputStream is = req.getInputStream();
                for (int len = req.getContentLength(); len > 0 && (s = is.read(b)) > 0; len -= s) {
                    baos.write(b, 0, s);
                }
                messages = new String[]{baos.toString(req.getCharacterEncoding())};
            }
        }
        return messages;
    }
}

