/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.ejb;

import com.sun.jdo.api.persistence.mapping.ejb.AbstractNameMapper;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionException;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.mapping.ejb.MappingFile;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmpFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmrFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.ColumnPair;
import com.sun.jdo.api.persistence.mapping.ejb.beans.EntityMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.spi.persistence.generator.database.DatabaseGenerator;
import com.sun.jdo.spi.persistence.generator.database.MappingPolicy;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class MappingGenerator {
    private static final String CLASS_SUFFIX = "_JDOState";
    private static final String FAKE_NAME = "fakename";
    private final EJBInfoHelper infoHelper;
    private final Model model;
    private final AbstractNameMapper nameMapper;
    private final ClassLoader loader;
    private final ConversionHelper ddHelper;
    private boolean skipGeneratedFields = false;
    private List strongRefs = new ArrayList();

    public MappingGenerator(EJBInfoHelper infoHelper, ClassLoader loader, boolean skipGeneratedFields) {
        this.infoHelper = infoHelper;
        this.model = infoHelper.getModel();
        this.loader = loader;
        this.nameMapper = infoHelper.getNameMapper();
        this.ddHelper = infoHelper.createConversionHelper();
        this.skipGeneratedFields = skipGeneratedFields;
    }

    protected EJBInfoHelper getInfoHelper() {
        return this.infoHelper;
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    protected AbstractNameMapper getNameMapper() {
        return this.nameMapper;
    }

    protected ConversionHelper getConversionHelper() {
        return this.ddHelper;
    }

    public DatabaseGenerator.Results generateMappingClasses(String dbName, Boolean uniqueTableNames, Properties userPolicy, String inputFilesPath) throws IOException, Schema2BeansException, ModelException, DBException, ConversionException {
        SunCmpMappings sunCmpMappings = null;
        ArrayList pcClasses = new ArrayList();
        sunCmpMappings = this.getPartialSunCmpMappings(pcClasses, uniqueTableNames != null ? uniqueTableNames : false);
        this.ddHelper.setEnsureValidation(false);
        SchemaElement fakeSchema = new SchemaElement((SchemaElement.Impl)new SchemaElementImpl());
        fakeSchema.setName(DBIdentifier.create((String)FAKE_NAME));
        SchemaElement.addToCache((SchemaElement)fakeSchema);
        this.loadMappingClasses(sunCmpMappings, null);
        DatabaseGenerator.Results results = this.generateSchema(pcClasses, dbName, uniqueTableNames, userPolicy);
        SchemaElement schema = results.getSchema();
        Set mappingClasses = results.getMappingClasses();
        SchemaElement.removeFromCache((String)FAKE_NAME);
        SchemaElement.removeFromCache((String)schema.getName().getName());
        SchemaElement.addToCache((SchemaElement)schema);
        this.updateMappingClasses(mappingClasses);
        if (this.skipGeneratedFields) {
            for (MappingClassElement mapClassElt : mappingClasses) {
                if (mapClassElt == null) continue;
                String className = mapClassElt.getName();
                String ejbName = this.nameMapper.getEjbNameForPersistenceClass(className);
                PersistenceClassElement pce = this.model.getPersistenceClass(className);
                PersistenceFieldElement[] allFields = pce.getFields();
                if (allFields == null) continue;
                ArrayList<PersistenceFieldElement> generatedFieldList = new ArrayList<PersistenceFieldElement>();
                for (int i = 0; i < allFields.length; ++i) {
                    String pFieldName;
                    String ejbFieldName;
                    PersistenceFieldElement pfe = allFields[i];
                    if (pfe == null || !this.nameMapper.isGeneratedField(ejbName, ejbFieldName = this.nameMapper.getEjbFieldForPersistenceField(className, pFieldName = pfe.getName()))) continue;
                    generatedFieldList.add(pfe);
                }
                for (PersistenceFieldElement pfe : generatedFieldList) {
                    MappingFieldElement mfe = mapClassElt.getField(pfe.getName());
                    if (mfe == null || mfe.isVersion()) continue;
                    this.model.removeFieldElement(pfe);
                    mapClassElt.removeField(mfe);
                }
            }
        }
        return results;
    }

    protected Map loadMappingClasses(SunCmpMappings sunMapping, ClassLoader classLoader) throws DBException, ModelException, ConversionException {
        MappingFile mapFile = new MappingFile(classLoader);
        Map allMappings = mapFile.intoMappingClasses(sunMapping, this.ddHelper);
        this.updateMappingClasses(allMappings.values());
        return allMappings;
    }

    public void cleanup() {
        this.strongRefs.clear();
    }

    private DatabaseGenerator.Results generateSchema(List pcClasses, String dbName, Boolean useUniqueTableNames, Properties userPolicy) throws IOException, DBException, ModelException {
        MappingPolicy mappingPolicy = MappingPolicy.getMappingPolicy(dbName);
        mappingPolicy.setUserPolicy(userPolicy);
        if (useUniqueTableNames != null) {
            mappingPolicy.setUniqueTableName(useUniqueTableNames);
        }
        return DatabaseGenerator.generate(this.model, pcClasses, mappingPolicy, this.infoHelper.getSchemaNameToGenerate(), CLASS_SUFFIX, true);
    }

    private void updateMappingClasses(Collection mappingClasses) {
        for (MappingClassElement mapClassElt : mappingClasses) {
            this.model.updateKeyForClass(mapClassElt, null);
            this.strongRefs.add(mapClassElt);
        }
    }

    private SunCmpMappings getPartialSunCmpMappings(List pcClasses, boolean useUniqueTableNames) throws Schema2BeansException {
        AbstractNameMapper nameMapper2 = useUniqueTableNames ? this.infoHelper.createUniqueNameMapper() : this.nameMapper;
        SunCmpMappings mappings = null;
        mappings = new SunCmpMappings();
        SunCmpMapping mapping = new SunCmpMapping();
        mapping.setSchema(FAKE_NAME);
        for (String ejbName : this.infoHelper.getEjbNames()) {
            String pcClass = this.ddHelper.getMappedClassName(ejbName);
            String hashClassName = JavaTypeHelper.getShortClassName(pcClass);
            if (useUniqueTableNames && hashClassName.equals(ejbName)) {
                hashClassName = JavaTypeHelper.getShortClassName(nameMapper2.getPersistenceClassForEjbName(ejbName));
                pcClasses.add(new DatabaseGenerator.NameTuple(pcClass, ejbName, hashClassName));
            } else {
                pcClasses.add(new DatabaseGenerator.NameTuple(pcClass, ejbName));
            }
            EntityMapping entity = new EntityMapping();
            entity.setEjbName(ejbName);
            entity.setTableName(FAKE_NAME);
            Collection fields = this.infoHelper.getFieldsForEjb(ejbName);
            Collection rels = this.infoHelper.getRelationshipsForEjb(ejbName);
            fields.removeAll(rels);
            for (String fieldName : fields) {
                CmpFieldMapping cmpField = new CmpFieldMapping();
                cmpField.setFieldName(fieldName);
                cmpField.addColumnName(FAKE_NAME);
                entity.addCmpFieldMapping(cmpField);
            }
            for (String fieldName : rels) {
                CmrFieldMapping cmrField = new CmrFieldMapping();
                cmrField.setCmrFieldName(fieldName);
                ColumnPair columnPair = new ColumnPair();
                columnPair.addColumnName(FAKE_NAME);
                columnPair.addColumnName(FAKE_NAME);
                cmrField.addColumnPair(columnPair);
                entity.addCmrFieldMapping(cmrField);
            }
            mapping.addEntityMapping(entity);
        }
        mappings.addSunCmpMapping(mapping);
        return mappings;
    }

    protected boolean isPropertyDefined(String propertyValue) {
        return !StringHelper.isEmpty(propertyValue);
    }

    public static void updateColumn(ColumnElement column, int jdbcType, Integer length, Integer scale, Integer precision) throws DBException {
        column.setType(jdbcType);
        column.setLength(length);
        column.setScale(scale);
        column.setPrecision(precision);
    }

    public static void updateProperties(Properties prop, String className, String fieldName, int jdbcType, Integer length, Integer scale, Integer precision) {
        prop.setProperty(MappingPolicy.getOverrideForType(className, fieldName), MappingPolicy.getJdbcTypeName(jdbcType));
        MappingGenerator.updateProperty(prop, MappingPolicy.getOverrideForLength(className, fieldName), length);
        MappingGenerator.updateProperty(prop, MappingPolicy.getOverrideForScale(className, fieldName), scale);
        MappingGenerator.updateProperty(prop, MappingPolicy.getOverrideForPrecision(className, fieldName), precision);
    }

    private static void updateProperty(Properties prop, String key, Integer value) {
        if (value != null) {
            prop.setProperty(key, value.toString());
        } else {
            prop.remove(key);
        }
    }

    public static class SQLTypeUtil {
        private static final Map characterMap = new HashMap();
        private static final Map numericMap = new HashMap();
        private static final Map blobMap = new HashMap();
        private static final Map timeMap = new HashMap();
        private static final String NONE_ATTRIBUTE = "none";
        private static final String LENGTH_ATTRIBUTE = "length";
        private static final String SCALE_ATTRIBUTE = "scale";
        private static final String SCALE_PRECISION_ATTRIBUTE = "scale-precision";

        public static boolean isNumeric(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, numericMap);
        }

        public static boolean isCharacter(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, characterMap);
        }

        public static boolean isBlob(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, blobMap);
        }

        public static boolean isTime(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, timeMap);
        }

        private static boolean checkType(int jdbcType, Map jdbcTypes) {
            return jdbcTypes.containsKey(new Integer(jdbcType));
        }

        public static Collection getCompatibleTypes(int jdbcType) {
            if (SQLTypeUtil.isNumeric(jdbcType)) {
                return numericMap.keySet();
            }
            if (SQLTypeUtil.isCharacter(jdbcType)) {
                return characterMap.keySet();
            }
            if (SQLTypeUtil.isBlob(jdbcType)) {
                return blobMap.keySet();
            }
            if (SQLTypeUtil.isTime(jdbcType)) {
                return timeMap.keySet();
            }
            return null;
        }

        public static boolean hasScale(int jdbcType) {
            return SQLTypeUtil.getAttribute(jdbcType).equals(SCALE_ATTRIBUTE) || SQLTypeUtil.getAttribute(jdbcType).equals(SCALE_PRECISION_ATTRIBUTE);
        }

        public static boolean hasPrecision(int jdbcType) {
            return SQLTypeUtil.getAttribute(jdbcType).equals(SCALE_PRECISION_ATTRIBUTE);
        }

        public static boolean hasLength(int jdbcType) {
            return SQLTypeUtil.getAttribute(jdbcType).equals(LENGTH_ATTRIBUTE);
        }

        private static String getAttribute(int jdbcType) {
            if (SQLTypeUtil.isNumeric(jdbcType)) {
                return (String)numericMap.get(new Integer(jdbcType));
            }
            if (SQLTypeUtil.isCharacter(jdbcType)) {
                return (String)characterMap.get(new Integer(jdbcType));
            }
            if (SQLTypeUtil.isBlob(jdbcType)) {
                return (String)blobMap.get(new Integer(jdbcType));
            }
            if (SQLTypeUtil.isTime(jdbcType)) {
                return (String)timeMap.get(new Integer(jdbcType));
            }
            return NONE_ATTRIBUTE;
        }

        static {
            characterMap.put(new Integer(1), LENGTH_ATTRIBUTE);
            characterMap.put(new Integer(12), LENGTH_ATTRIBUTE);
            characterMap.put(new Integer(2005), LENGTH_ATTRIBUTE);
            numericMap.put(new Integer(-7), NONE_ATTRIBUTE);
            numericMap.put(new Integer(-6), NONE_ATTRIBUTE);
            numericMap.put(new Integer(5), NONE_ATTRIBUTE);
            numericMap.put(new Integer(-5), NONE_ATTRIBUTE);
            numericMap.put(new Integer(4), NONE_ATTRIBUTE);
            numericMap.put(new Integer(8), NONE_ATTRIBUTE);
            numericMap.put(new Integer(3), SCALE_PRECISION_ATTRIBUTE);
            numericMap.put(new Integer(7), NONE_ATTRIBUTE);
            blobMap.put(new Integer(2004), LENGTH_ATTRIBUTE);
            timeMap.put(new Integer(91), NONE_ATTRIBUTE);
            timeMap.put(new Integer(92), NONE_ATTRIBUTE);
            timeMap.put(new Integer(93), NONE_ATTRIBUTE);
        }
    }
}

