/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import java.util.logging.Level;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

class TransactedSubscriber
implements MessageListener {
    private String _subid = null;
    private StompTransactedSession _parent = null;
    private MessageConsumer _subscriber = null;
    private String _duraName = null;

    public TransactedSubscriber(String string, MessageConsumer messageConsumer, String string2, StompTransactedSession stompTransactedSession) throws Exception {
        this._subid = string;
        this._subscriber = messageConsumer;
        this._parent = stompTransactedSession;
        this._duraName = string2;
        this._subscriber.setMessageListener(this);
    }

    public String getDuraName() {
        return this._duraName;
    }

    public void startMessageDelivery() throws Exception {
        this._subscriber.setMessageListener(this);
    }

    public void onMessage(Message message) {
        try {
            this._parent._logger.log(Level.FINE, "onMessage message " + message.getJMSMessageID() + " for STOMP subscriber " + this._subid);
            this._parent.enqueue(this._subid, message);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public void close() throws Exception {
        this._subscriber.close();
    }
}

