/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolTxHelper {
    private String poolName;
    protected static final Logger _logger = LogDomains.getLogger(PoolTxHelper.class, (String)"javax.enterprise.resource.resourceadapter");

    public PoolTxHelper(String poolName) {
        this.poolName = poolName;
    }

    public boolean isLocalResourceEligibleForReuse(ResourceHandle h) {
        boolean result = false;
        if (!this.isLocalResourceInTransaction(h)) {
            try {
                this.enforceDelistment(h);
            }
            catch (SystemException se) {
                _logger.log(Level.FINE, "Exception while delisting the local resource [ of pool : " + this.poolName + " ] " + "forcibily from transaction", se);
                return result;
            }
            h.getResourceState().setEnlisted(false);
            result = true;
        }
        return result;
    }

    private void enforceDelistment(ResourceHandle h) throws SystemException {
        Set set;
        JavaEETransaction txn = (JavaEETransaction)ConnectorRuntime.getRuntime().getTransaction();
        if (txn != null && (set = txn.getResources(this.poolName)) != null) {
            set.remove(h);
        }
    }

    public boolean isLocalTransactionInProgress() {
        boolean result = false;
        try {
            JavaEETransaction txn = (JavaEETransaction)ConnectorRuntime.getRuntime().getTransaction();
            if (txn != null) {
                result = txn.isLocalTx();
            }
        }
        catch (SystemException e) {
            _logger.log(Level.FINE, "Exception while checking whether a local transaction is in progress while using pool : " + this.poolName, e);
        }
        return result;
    }

    public boolean isLocalResourceInTransaction(ResourceHandle h) {
        boolean result = true;
        try {
            JavaEETransaction txn = (JavaEETransaction)ConnectorRuntime.getRuntime().getTransaction();
            if (txn != null) {
                result = this.isNonXAResourceInTransaction(txn, h);
            }
        }
        catch (SystemException e) {
            _logger.log(Level.FINE, "Exception while checking whether the resource [ of pool : " + this.poolName + " ] " + "is nonxa and is enlisted in transaction : ", e);
        }
        return result;
    }

    public boolean isNonXAResource(ResourceHandle resource) {
        return !resource.getResourceSpec().isXA();
    }

    private boolean isNonXAResourceInTransaction(JavaEETransaction tran, ResourceHandle resource) {
        return resource.equals(tran.getNonXAResource());
    }

    public boolean isNonXAResourceAndFree(JavaEETransaction tran, ResourceHandle resource) {
        return resource.getResourceState().isFree() && this.isNonXAResource(resource) && this.isNonXAResourceInTransaction(tran, resource);
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle resource) {
        try {
            JavaEETransaction j2eetran = (JavaEETransaction)tran;
            HashSet<ResourceHandle> set = j2eetran.getResources(this.poolName);
            if (set == null) {
                set = new HashSet<ResourceHandle>();
                j2eetran.setResources(set, this.poolName);
            }
            set.add(resource);
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool [ " + this.poolName + " ]: resourceEnlisted:" + "transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
        }
        ResourceState state = resource.getResourceState();
        state.setEnlisted(true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool [ " + this.poolName + " ]: resourceEnlisted: " + resource);
        }
    }

    public List<ResourceHandle> transactionCompleted(Transaction tran, int status, String poolName) {
        JavaEETransaction j2eetran;
        ArrayList<ResourceHandle> delistedResources = new ArrayList<ResourceHandle>();
        try {
            j2eetran = (JavaEETransaction)tran;
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: transactionCompleted: transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
            return delistedResources;
        }
        Set set = j2eetran.getResources(poolName);
        if (set == null) {
            return delistedResources;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ResourceHandle resource = (ResourceHandle)iter.next();
            ResourceState state = resource.getResourceState();
            state.setEnlisted(false);
            delistedResources.add(resource);
            iter.remove();
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "Pool: transactionCompleted: " + resource);
        }
        return delistedResources;
    }
}

