/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Jps {
    private Map<String, Integer> pidMap = new HashMap<String, Integer>();
    private static final File jpsExe;
    private static final String jpsName;

    public static final int getPid(String mainClassName) {
        Jps jps = new Jps();
        Integer integer = jps.pidMap.get(mainClassName);
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static final boolean isPid(int apid) {
        return new Jps().pidMap.containsValue(apid);
    }

    private Jps() {
        try {
            String[] ss;
            if (jpsExe == null) {
                return;
            }
            ProcessBuilder pb = new ProcessBuilder(jpsExe.getPath());
            Process p = pb.start();
            ProcessStreamDrainer saver = ProcessStreamDrainer.save("jps", p);
            saver.waitFor();
            String jpsOutput = saver.getOutString();
            for (String line : ss = jpsOutput.split("[\n\r]")) {
                String[] sublines;
                if (line == null || line.length() <= 0 || (sublines = line.split(" ")) == null || sublines.length != 2) continue;
                int aPid = 0;
                try {
                    aPid = Integer.parseInt(sublines[0]);
                }
                catch (Exception e) {
                    continue;
                }
                this.pidMap.put(sublines[1], aPid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        jpsName = OS.isWindows() ? "jps.exe" : "jps";
        String javaroot = System.getProperty("java.home");
        String relpath = "/bin/" + jpsName;
        File fhere = new File(javaroot + relpath);
        File fthere = new File(javaroot + "/.." + relpath);
        jpsExe = fhere.isFile() ? SmartFile.sanitize(fhere) : (fthere.isFile() ? SmartFile.sanitize(fthere) : null);
    }
}

