/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.io;

import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartFile {
    private String path;
    private static final String SLASH = "/";

    public static File sanitize(File f) {
        SmartFile sf = new SmartFile(f);
        return new File(sf.path);
    }

    public static String sanitize(String filename) {
        SmartFile sf = new SmartFile(filename);
        return sf.path;
    }

    public static String sanitizePaths(String pathsString) {
        if (!SmartFile.ok(pathsString)) {
            return pathsString;
        }
        try {
            String[] paths = pathsString.split(File.pathSeparator);
            StringBuilder sb = new StringBuilder();
            HashSet<String> pathsSet = new HashSet<String>();
            LinkedList<String> pathsList = new LinkedList<String>();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (!SmartFile.ok(path) || !pathsSet.add(path = SmartFile.sanitize(path))) continue;
                pathsList.add(path);
            }
            boolean firstElement = true;
            for (String path : pathsList) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    sb.append(File.pathSeparator);
                }
                sb.append(path);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return pathsString;
        }
    }

    private SmartFile(File f) {
        if (f == null) {
            throw new NullPointerException();
        }
        this.convert(f.getAbsolutePath());
    }

    private SmartFile(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        s = StringUtils.removeEnclosingQuotes(s);
        this.convert(new File(s).getAbsolutePath());
    }

    private void convert(String oldPath) {
        if (GFLauncherUtils.isWindows()) {
            this.convertWindows(oldPath);
        } else {
            this.convertNix(oldPath);
        }
    }

    private void convertWindows(String oldPath) {
        try {
            this.path = new File(oldPath).getCanonicalPath();
            if (!this.path.startsWith("\\")) {
                this.path = this.path.replace('\\', '/');
            }
        }
        catch (IOException ex) {
            this.path = oldPath.replace('\\', '/');
        }
    }

    private void convertNix(String oldPath) {
        String[] elemsArray = oldPath.split(SLASH);
        ArrayList<String> elems = new ArrayList<String>();
        for (String s : elemsArray) {
            elems.add(s);
        }
        this.path = SLASH;
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            String elem = (String)it.next();
            if (elem.length() > 0) continue;
            it.remove();
        }
        block2: while (this.hasDots(elems)) {
            for (int i = 0; i < elems.size(); ++i) {
                String elem = (String)elems.get(i);
                if (elem.equals(".")) {
                    elems.remove(i);
                    continue block2;
                }
                if (!elem.equals("..")) continue;
                elems.remove(i);
                if (i <= 0) {
                    return;
                }
                elems.remove(i - 1);
                continue block2;
            }
        }
        for (String s : elems) {
            this.path = this.path + s + SLASH;
        }
        if (this.path.length() > 1) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    private boolean hasDots(List<String> elems) {
        return elems.contains(".") || elems.contains("..");
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

