/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.PerfReader;
import java.net.URISyntaxException;
import sun.jvmstat.monitor.IntegerMonitor;
import sun.jvmstat.monitor.LongMonitor;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.StringMonitor;
import sun.jvmstat.monitor.VmIdentifier;

public class PerfReaderImpl
implements PerfReader {
    private volatile MonitoredVm thisVm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MonitoredVm getThisVm() {
        if (this.thisVm == null) {
            PerfReaderImpl perfReaderImpl = this;
            synchronized (perfReaderImpl) {
                if (this.thisVm == null) {
                    try {
                        MonitoredHost localHost = MonitoredHost.getMonitoredHost("localhost");
                        VmIdentifier vmIdent = new VmIdentifier("0");
                        this.thisVm = localHost.getMonitoredVm(vmIdent);
                    }
                    catch (MonitorException me) {
                        throw new IllegalArgumentException("jvmstat perf counters not available: " + me);
                    }
                    catch (URISyntaxException use) {
                        throw new IllegalArgumentException("jvmstat perf counters not available: " + use);
                    }
                }
            }
        }
        return this.thisVm;
    }

    private Monitor findByName(String name) {
        try {
            return this.getThisVm().findByName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int perfInt(String name) {
        Monitor mon = this.findByName(name);
        if (mon == null) {
            throw new IllegalArgumentException("no such counter: " + name);
        }
        if (mon instanceof IntegerMonitor) {
            return ((IntegerMonitor)mon).intValue();
        }
        if (mon instanceof LongMonitor) {
            return (int)((LongMonitor)mon).longValue();
        }
        throw new IllegalArgumentException(name + " is not an int");
    }

    public long perfLong(String name) {
        Monitor mon = this.findByName(name);
        if (mon == null) {
            throw new IllegalArgumentException("no such counter: " + name);
        }
        if (mon instanceof LongMonitor) {
            return ((LongMonitor)mon).longValue();
        }
        throw new IllegalArgumentException(name + " is not a long");
    }

    public String perfString(String name) {
        Monitor mon = this.findByName(name);
        if (mon == null) {
            throw new IllegalArgumentException("no such counter: " + name);
        }
        if (mon instanceof StringMonitor) {
            return ((StringMonitor)mon).stringValue();
        }
        throw new IllegalArgumentException(name + " is not a string");
    }
}

