/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.ErrorReturnInstrumentor;
import com.sun.btrace.runtime.InstrumentUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class MethodEntryExitInstrumentor
extends ErrorReturnInstrumentor {
    private boolean isConstructor;
    private boolean entryCalled;

    public MethodEntryExitInstrumentor(MethodVisitor mv, int access, String name, String desc) {
        super(mv, access, name, desc);
        this.isConstructor = name.equals("<init>");
    }

    @Override
    public void visitCode() {
        if (!this.isConstructor) {
            this.entryCalled = true;
            this.onMethodEntry();
        }
        super.visitCode();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        super.visitMethodInsn(opcode, owner, name, desc);
        if (this.isConstructor && !this.entryCalled && name.equals("<init>")) {
            this.entryCalled = true;
            this.onMethodEntry();
        }
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                if (!this.entryCalled) {
                    this.entryCalled = true;
                    this.onMethodEntry();
                }
                this.onMethodReturn(opcode);
                break;
            }
        }
        super.visitInsn(opcode);
    }

    protected void onMethodEntry() {
        this.println("on method entry");
    }

    protected void onMethodReturn(int opcode) {
        this.println("on method return");
    }

    @Override
    protected void onErrorReturn() {
        this.println("on method error return");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.ErrorReturnInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodEntryExitInstrumentor(mv, access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

